/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enhancement.field;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.object.enhancement.field.ODocumentFieldOTypeHandlingStrategy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ODocumentSplitRecordBytesOTypeHandlingStrategy
implements ODocumentFieldOTypeHandlingStrategy {
    private static final int DEFAULT_CHUNK_SIZE = 64;
    private static final int BYTES_PER_KB = 1024;
    private final int chunkSize;

    public ODocumentSplitRecordBytesOTypeHandlingStrategy() {
        this(64);
    }

    public ODocumentSplitRecordBytesOTypeHandlingStrategy(int chunkSizeInKb) {
        this.chunkSize = chunkSizeInKb * 1024;
    }

    @Override
    public ODocument store(ODocument iRecord, String fieldName, Object fieldValue) {
        byte[] bytes = fieldValue != null ? (byte[])fieldValue : null;
        ODatabaseDocumentInternal database = iRecord.getDatabase();
        ArrayList<ORID> chunks = (ArrayList<ORID>)iRecord.field(fieldName);
        if (chunks != null) {
            for (ORID oRid : chunks) {
                database.delete(oRid);
            }
            iRecord.removeField(fieldName);
        }
        if (bytes != null) {
            chunks = new ArrayList<ORID>();
            int nextChunkLength = this.chunkSize;
            for (int offset = 0; offset < bytes.length; offset += nextChunkLength) {
                int clusterId;
                if (offset + nextChunkLength > bytes.length) {
                    nextChunkLength = bytes.length - offset;
                }
                if ((clusterId = iRecord.getIdentity().getClusterId()) < 0) {
                    clusterId = database.getBlobClusterIds().size() > 0 ? ((Integer)database.getBlobClusterIds().iterator().next()).intValue() : database.getDefaultClusterId();
                }
                chunks.add(((ORecord)database.save((Object)new ORecordBytes(Arrays.copyOfRange(bytes, offset, offset + nextChunkLength)), database.getClusterNameById(clusterId))).getIdentity());
            }
            iRecord.field(fieldName, chunks);
        }
        return iRecord;
    }

    @Override
    public Object load(ODocument iRecord, String fieldName) {
        iRecord.setLazyLoad(false);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (OIdentifiable id : (List)iRecord.field(fieldName)) {
            ORecordBytes chunk = (ORecordBytes)id.getRecord();
            try {
                chunk.toOutputStream((OutputStream)outputStream);
            }
            catch (IOException e) {
                throw OException.wrapException((OException)new OSerializationException("Error loading binary field " + fieldName), (Throwable)e);
            }
            chunk.unload();
        }
        return outputStream.toByteArray();
    }

    @Override
    public OType getOType() {
        return OType.BINARY;
    }
}

