/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.jpa.parsing;

import com.orientechnologies.orient.object.jpa.parsing.PersistenceXml;
import com.orientechnologies.orient.object.jpa.parsing.PersistenceXmlUtil;
import com.orientechnologies.orient.object.jpa.parsing.StopSAXParser;
import java.util.EnumSet;
import javax.persistence.PersistenceException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SchemaLocatingHandler
extends DefaultHandler {
    private String schemaVersion = "";

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        PersistenceXml element = PersistenceXml.parse(localName == null || localName.isEmpty() ? name : localName);
        this.schemaVersion = PersistenceXmlUtil.parseSchemaVersion(uri, element, attributes);
        if (this.schemaVersion != null) {
            throw new StopSAXParser();
        }
        if (PersistenceXml.TAG_PERSISTENCE != element && EnumSet.allOf(PersistenceXml.class).contains((Object)element)) {
            throw new PersistenceException("Cannot find schema version attribute in <persistence> tag");
        }
    }

    public String getVersion() {
        return this.schemaVersion;
    }
}

