/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.object.OLazyObjectListInterface;
import com.orientechnologies.orient.core.db.object.OObjectLazyMultivalueElement;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.OLazyCollectionUtil;
import com.orientechnologies.orient.object.db.OObjectDatabaseTx;
import com.orientechnologies.orient.object.db.OObjectLazyListIterator;
import com.orientechnologies.orient.object.enhancement.OObjectEntityEnhancer;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.enhancement.OObjectProxyMethodHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyObject;

public class OObjectLazyList<TYPE>
extends ArrayList<TYPE>
implements OLazyObjectListInterface<TYPE>,
OObjectLazyMultivalueElement<List<TYPE>>,
Serializable {
    private static final long serialVersionUID = -1665952780303555865L;
    private ProxyObject sourceRecord;
    private final List<OIdentifiable> recordList;
    private String fetchPlan;
    private boolean converted = false;
    private boolean convertToRecord = true;
    private final boolean orphanRemoval;

    public OObjectLazyList(Object iSourceRecord, List<OIdentifiable> iRecordList, boolean orphanRemoval) {
        this.sourceRecord = iSourceRecord instanceof ProxyObject ? (ProxyObject)iSourceRecord : null;
        this.recordList = iRecordList;
        this.orphanRemoval = orphanRemoval;
        for (int i = 0; i < iRecordList.size(); ++i) {
            super.add(i, null);
        }
    }

    public OObjectLazyList(Object iSourceRecord, List<OIdentifiable> iRecordList, Collection<? extends TYPE> iSourceList, boolean orphanRemoval) {
        this.sourceRecord = iSourceRecord instanceof ProxyObject ? (ProxyObject)iSourceRecord : null;
        this.recordList = iRecordList;
        this.orphanRemoval = orphanRemoval;
        for (int i = 0; i < iRecordList.size(); ++i) {
            super.add(i, null);
        }
        this.addAll(iSourceList);
    }

    @Override
    public Iterator<TYPE> iterator() {
        return new OObjectLazyListIterator(this, this.sourceRecord);
    }

    @Override
    public Spliterator<TYPE> spliterator() {
        return Spliterators.spliterator(this, 16);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Proxy) {
            return this.recordList.contains(OObjectEntitySerializer.getDocument((Proxy)o));
        }
        if (o instanceof OIdentifiable) {
            return this.recordList.contains(o);
        }
        this.convertAll();
        return super.contains(o);
    }

    @Override
    public boolean add(TYPE element) {
        boolean dirty = false;
        if (element instanceof OIdentifiable) {
            OIdentifiable record = (OIdentifiable)element;
            if (this.converted) {
                this.converted = false;
            }
            if (this.recordList.add(record)) {
                this.setDirty();
                if (this.orphanRemoval && record != null && this.sourceRecord != null) {
                    ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().remove(record.getIdentity());
                }
                return true;
            }
        } else if (element instanceof Proxy) {
            ODocument record = OObjectEntitySerializer.getDocument((Proxy)element);
            if (this.orphanRemoval && record != null && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().remove(record.getIdentity());
            }
            dirty = this.recordList.add((OIdentifiable)record);
        } else {
            element = OObjectEntitySerializer.serializeObject(element, this.getDatabase());
            ODocument record = OObjectEntitySerializer.getDocument((Proxy)element);
            if (this.orphanRemoval && record != null && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().remove(record.getIdentity());
            }
            dirty = this.recordList.add((OIdentifiable)record);
        }
        if (dirty) {
            this.setDirty();
        }
        return super.add(element);
    }

    @Override
    public void add(int index, TYPE element) {
        this.setDirty();
        if (element instanceof OIdentifiable) {
            OIdentifiable record = (OIdentifiable)element;
            if (this.converted) {
                this.converted = false;
            }
            if (this.orphanRemoval && record != null && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().remove(record.getIdentity());
            }
            this.recordList.add(index, record);
            return;
        }
        if (element instanceof Proxy) {
            ODocument record = OObjectEntitySerializer.getDocument((Proxy)element);
            if (this.orphanRemoval && record != null && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().remove(record.getIdentity());
            }
            this.recordList.add(index, (OIdentifiable)record);
        } else {
            element = OObjectEntitySerializer.serializeObject(element, this.getDatabase());
            ODocument record = OObjectEntitySerializer.getDocument((Proxy)element);
            if (this.orphanRemoval && record != null && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().remove(record.getIdentity());
            }
            this.recordList.add(index, (OIdentifiable)record);
        }
        super.add(index, element);
    }

    @Override
    public TYPE get(int index) {
        Object o = super.get(index);
        if (o == null) {
            OIdentifiable record = this.recordList.get(index);
            if (record == null || record.getRecord() == null) {
                OLogManager.instance().warn((Object)this, "Record " + ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getDoc().getIdentity() + " references a deleted instance", new Object[0]);
                return null;
            }
            o = OObjectEntityEnhancer.getInstance().getProxiedInstance(((ODocument)record.getRecord()).getClassName(), this.getDatabase().getEntityManager(), (ODocument)record.getRecord(), this.sourceRecord, new Object[0]);
            super.set(index, o);
        }
        return (TYPE)o;
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Proxy) {
            return this.recordList.indexOf(OObjectEntitySerializer.getDocument((Proxy)o));
        }
        if (o instanceof OIdentifiable) {
            return this.recordList.indexOf(o);
        }
        this.convertAll();
        return super.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Proxy) {
            return this.recordList.lastIndexOf(OObjectEntitySerializer.getDocument((Proxy)o));
        }
        if (o instanceof OIdentifiable) {
            return this.recordList.lastIndexOf(o);
        }
        this.convertAll();
        return super.lastIndexOf(o);
    }

    @Override
    public Object[] toArray() {
        this.convertAll();
        return super.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.convertAll();
        return super.toArray(a);
    }

    @Override
    public int size() {
        return this.recordList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.recordList.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        this.setDirty();
        if (o instanceof OIdentifiable) {
            int elementIndex = this.recordList.indexOf(o);
            int n = elementIndex = elementIndex > -1 ? elementIndex : this.recordList.indexOf(((OIdentifiable)o).getRecord());
            if (elementIndex > -1 && this.indexLoaded(elementIndex)) {
                super.remove(elementIndex);
            }
            if (this.orphanRemoval && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(((OIdentifiable)o).getIdentity());
            }
            return this.recordList.remove(o);
        }
        if (o instanceof Proxy) {
            ODocument record = OObjectEntitySerializer.getDocument((Proxy)o);
            if (this.orphanRemoval && record != null && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(record.getIdentity());
            }
            this.recordList.remove(record);
        } else {
            ODocument record = this.getDatabase().getRecordByUserObject(o, false);
            if (this.orphanRemoval && record != null && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(record.getIdentity());
            }
            this.recordList.remove(record);
        }
        return super.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends TYPE> c) {
        boolean dirty = false;
        for (TYPE element : c) {
            dirty |= this.add(element);
        }
        if (dirty) {
            this.setDirty();
        }
        return dirty;
    }

    @Override
    public boolean addAll(int index, Collection<? extends TYPE> c) {
        for (TYPE element : c) {
            this.add(index, element);
            ++index;
        }
        if (c.size() > 0) {
            this.setDirty();
        }
        return c.size() > 0;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean dirty = true;
        for (Object o : c) {
            dirty = this.remove(o) || dirty;
        }
        if (dirty) {
            this.setDirty();
        }
        return dirty;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        for (TYPE value : this) {
            if (c.contains(value)) continue;
            this.remove(value);
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.setDirty();
        if (this.orphanRemoval && this.sourceRecord != null) {
            for (OIdentifiable value : this.recordList) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(value.getIdentity());
            }
        }
        this.recordList.clear();
        super.clear();
    }

    @Override
    public TYPE set(int index, TYPE element) {
        if (element instanceof OIdentifiable) {
            OIdentifiable record = (OIdentifiable)element;
            if (this.converted) {
                this.converted = false;
            }
            if (this.orphanRemoval && record != null && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().remove(record.getIdentity());
            }
            this.recordList.set(index, record);
        } else if (element instanceof Proxy) {
            ODocument record = OObjectEntitySerializer.getDocument((Proxy)element);
            if (this.orphanRemoval && record != null && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().remove(record.getIdentity());
            }
            this.recordList.set(index, (OIdentifiable)record);
        } else {
            element = OObjectEntitySerializer.serializeObject(element, this.getDatabase());
            ODocument record = this.getDatabase().getRecordByUserObject(element, false);
            if (this.orphanRemoval && record != null && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().remove(record.getIdentity());
            }
            this.recordList.set(index, (OIdentifiable)record);
        }
        this.setDirty();
        return super.set(index, element);
    }

    @Override
    public TYPE remove(int index) {
        Object element;
        OIdentifiable record = this.recordList.remove(index);
        if (this.indexLoaded(index)) {
            if (this.orphanRemoval && record != null && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(record.getIdentity());
            }
            element = super.remove(index);
        } else {
            if (this.orphanRemoval && record != null && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(record.getIdentity());
            }
            element = OObjectEntityEnhancer.getInstance().getProxiedInstance(((ODocument)record.getRecord()).getClassName(), this.getDatabase().getEntityManager(), (ODocument)record.getRecord(), this.sourceRecord, new Object[0]);
        }
        this.setDirty();
        return (TYPE)element;
    }

    @Override
    public ListIterator<TYPE> listIterator() {
        return super.listIterator();
    }

    @Override
    public ListIterator<TYPE> listIterator(int index) {
        return super.listIterator(index);
    }

    @Override
    public List<TYPE> subList(int fromIndex, int toIndex) {
        return super.subList(fromIndex, toIndex);
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public OObjectLazyList<TYPE> setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
        return this;
    }

    public boolean isConvertToRecord() {
        return this.convertToRecord;
    }

    @Override
    public void setConvertToRecord(boolean convertToRecord) {
        this.convertToRecord = convertToRecord;
    }

    @Override
    public boolean isConverted() {
        return this.converted;
    }

    public void detach() {
        this.convertAll();
    }

    @Override
    public void detach(boolean nonProxiedInstance) {
        this.convertAll();
    }

    protected void convertAll() {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.convert(i);
        }
        this.converted = true;
    }

    public void setDirty() {
        if (this.sourceRecord != null) {
            ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).setDirty();
        }
    }

    @Override
    public List<TYPE> getNonOrientInstance() {
        ArrayList list = new ArrayList();
        list.addAll(this);
        return list;
    }

    @Override
    public Object getUnderlying() {
        return this.recordList;
    }

    private void convert(int iIndex) {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        Object o = super.get(iIndex);
        if (o == null) {
            ODatabaseDocumentInternal database = this.getDatabase().getUnderlying();
            o = this.recordList.get(iIndex);
            ODocument doc = o instanceof ORID ? (ODocument)database.load((ORID)o, this.fetchPlan) : (ODocument)o;
            if (o == null) {
                OLogManager.instance().warn((Object)this, "Record " + ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getDoc().getIdentity() + " references a deleted instance", new Object[0]);
                return;
            }
            super.set(iIndex, OObjectEntityEnhancer.getInstance().getProxiedInstance(doc.getClassName(), this.getDatabase().getEntityManager(), doc, this.sourceRecord, new Object[0]));
        }
    }

    @Override
    public void detachAll(boolean nonProxiedInstance, Map<Object, Object> alreadyDetached, Map<Object, Object> lazyObjects) {
        this.convertAndDetachAll(nonProxiedInstance, alreadyDetached, lazyObjects);
    }

    protected void convertAndDetachAll(boolean nonProxiedInstance, Map<Object, Object> alreadyDetached, Map<Object, Object> lazyObjects) {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.convertAndDetachAll(i, nonProxiedInstance, alreadyDetached, lazyObjects);
        }
        this.converted = true;
    }

    private void convertAndDetachAll(int iIndex, boolean nonProxiedInstance, Map<Object, Object> alreadyDetached, Map<Object, Object> lazyObjects) {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        Object o = super.get(iIndex);
        if (o == null) {
            ODatabaseDocumentInternal database = this.getDatabase().getUnderlying();
            o = this.recordList.get(iIndex);
            ODocument doc = o instanceof ORID ? (ODocument)database.load((ORID)o, this.fetchPlan) : (ODocument)o;
            if (o == null) {
                OLogManager.instance().warn((Object)this, "Record " + ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getDoc().getIdentity() + " references a deleted instance", new Object[0]);
                return;
            }
            o = OObjectEntityEnhancer.getInstance().getProxiedInstance(doc.getClassName(), this.getDatabase().getEntityManager(), doc, this.sourceRecord, new Object[0]);
            o = this.getDatabase().detachAll(o, nonProxiedInstance, alreadyDetached, lazyObjects);
            super.set(iIndex, o);
        }
    }

    protected OObjectDatabaseTx getDatabase() {
        return OLazyCollectionUtil.getDatabase();
    }

    protected boolean indexLoaded(int iIndex) {
        return super.get(iIndex) != null;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

