/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.object.db.OObjectDatabaseTx;
import java.util.List;
import java.util.Map;

public class OrientDBObject
implements AutoCloseable {
    private OrientDB orientDB;

    public OrientDBObject(OrientDB orientDB) {
        this.orientDB = orientDB;
    }

    public OrientDBObject(String environment, OrientDBConfig config) {
        this(environment, null, null, config);
    }

    public OrientDBObject(String environment, String serverUser, String serverPassword, OrientDBConfig config) {
        this.orientDB = new OrientDB(environment, serverUser, serverPassword, config);
    }

    public ODatabaseObject open(String name, String user, String password) {
        return new OObjectDatabaseTx((ODatabaseDocumentInternal)this.orientDB.open(name, user, password));
    }

    public ODatabaseObject open(String name, String user, String password, OrientDBConfig config) {
        return new OObjectDatabaseTx((ODatabaseDocumentInternal)this.orientDB.open(name, user, password, config));
    }

    public void create(String name, ODatabaseType type) {
        this.orientDB.create(name, type);
    }

    public void create(String name, ODatabaseType type, OrientDBConfig config) {
        this.orientDB.create(name, type, config);
    }

    public OResultSet execute(String script, Map<String, Object> params) {
        return this.orientDB.execute(script, params);
    }

    public OResultSet execute(String script, Object ... params) {
        return this.orientDB.execute(script, params);
    }

    public boolean exists(String name) {
        return this.orientDB.exists(name);
    }

    public void drop(String name) {
        this.orientDB.drop(name);
    }

    public List<String> list() {
        return this.orientDB.list();
    }

    @Override
    public void close() {
        this.orientDB.close();
    }

    protected OrientDB getOrientDB() {
        return this.orientDB;
    }
}

