/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.serialization;

import com.orientechnologies.common.reflection.OReflectionHelper;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.serialization.serializer.object.OObjectSerializer;
import com.orientechnologies.orient.object.entity.OObjectEntityClassHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public class OObjectSerializerContext
implements OObjectSerializer<Object, Object> {
    private final Map<Class<?>, OObjectSerializer> customSerializers = new LinkedHashMap();

    public void bind(OObjectSerializer serializer, ODatabase database) {
        Type[] actualTypes = OReflectionHelper.getGenericTypes(serializer.getClass());
        if (actualTypes[0] instanceof Class) {
            this.customSerializers.put((Class)actualTypes[0], serializer);
            OObjectEntityClassHandler.getInstance(database.getURL()).deregisterEntityClass((Class)actualTypes[0]);
        } else if (actualTypes[0] instanceof ParameterizedType) {
            this.customSerializers.put((Class)((ParameterizedType)actualTypes[0]).getRawType(), serializer);
            OObjectEntityClassHandler.getInstance(database.getURL()).deregisterEntityClass((Class)((ParameterizedType)actualTypes[0]).getRawType());
        }
    }

    public void unbind(OObjectSerializer serializer) {
        ParameterizedType pt;
        Type genericType = serializer.getClass().getGenericInterfaces()[0];
        if (genericType != null && genericType instanceof ParameterizedType && (pt = (ParameterizedType)genericType).getActualTypeArguments() != null && pt.getActualTypeArguments().length > 1) {
            Type[] actualTypes = pt.getActualTypeArguments();
            if (actualTypes[0] instanceof Class) {
                this.customSerializers.remove((Class)actualTypes[0]);
            } else if (actualTypes[0] instanceof ParameterizedType) {
                this.customSerializers.remove((Class)((ParameterizedType)actualTypes[0]).getRawType());
            }
        }
    }

    public boolean isClassBinded(Class<?> iClass) {
        return this.customSerializers.get(iClass) != null;
    }

    public Class<?> getBoundClassTarget(Class<?> iClass) {
        if (this.isClassBinded(iClass)) {
            Type[] actualTypes = OReflectionHelper.getGenericTypes(this.customSerializers.get(iClass).getClass());
            if (actualTypes[1] instanceof Class) {
                return (Class)actualTypes[1];
            }
            if (actualTypes[1] instanceof ParameterizedType) {
                return (Class)((ParameterizedType)actualTypes[1]).getRawType();
            }
            throw new IllegalStateException("Class " + iClass.getName() + " reported as binded but is not a class?");
        }
        return null;
    }

    @Override
    public Object serializeFieldValue(Class<?> iClass, Object iFieldValue) {
        for (Class<?> type : this.customSerializers.keySet()) {
            if (!type.isInstance(iFieldValue) && (iFieldValue != null || type != Void.class)) continue;
            iFieldValue = this.customSerializers.get(type).serializeFieldValue(iClass, iFieldValue);
            break;
        }
        return iFieldValue;
    }

    @Override
    public Object unserializeFieldValue(Class<?> iClass, Object iFieldValue) {
        if (iClass != null) {
            for (Class<?> type : this.customSerializers.keySet()) {
                if (!type.isAssignableFrom(iClass) && type != Void.class) continue;
                return this.customSerializers.get(type).unserializeFieldValue(iClass, iFieldValue);
            }
        }
        return iFieldValue;
    }
}

