/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OSyncClusterTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class ORequestSyncClusterTask
extends OAbstractRemoteTask {
    protected String clusterName;

    public ORequestSyncClusterTask() {
    }

    public ORequestSyncClusterTask(String iClusterName) {
        this.clusterName = iClusterName;
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedConfiguration dbCfg = iManager.getDatabaseConfiguration(this.getName());
        List<String> nodes = dbCfg.getServers(this.clusterName, null);
        nodes.remove(iManager.getLocalNodeName());
        iManager.sendRequest(database.getName(), null, nodes, new OSyncClusterTask(this.clusterName), ODistributedRequest.EXECUTION_MODE.NO_RESPONSE);
        return Boolean.FALSE;
    }

    @Override
    public OAbstractRemoteTask.RESULT_STRATEGY getResultStrategy() {
        return OAbstractRemoteTask.RESULT_STRATEGY.UNION;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    @Override
    public boolean isRequireNodeOnline() {
        return false;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public String getName() {
        return "req_deploy_cluster";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.clusterName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.clusterName = in.readUTF();
    }

    @Override
    public boolean isRequiredOpenDatabase() {
        return true;
    }
}

