/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OFixTxTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;

public class OCompletedTxTask
extends OAbstractReplicatedTask {
    private static final long serialVersionUID = 1L;
    private final Set<ORID> locks;

    public OCompletedTxTask() {
        this.locks = new HashSet<ORID>();
    }

    public OCompletedTxTask(Set<ORID> iLocks) {
        this.locks = iLocks;
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "completing transaction against db=%s locks=%s...", database.getName(), this.locks);
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)database);
        ODistributedDatabase ddb = iManager.getMessageService().getDatabase(database.getName());
        for (ORID r : this.locks) {
            ddb.unlockRecord(r);
        }
        return Boolean.TRUE;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    @Override
    public OFixTxTask getFixTask(ODistributedRequest iRequest, OAbstractRemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse) {
        return null;
    }

    @Override
    public OAbstractRemoteTask getUndoTask(ODistributedRequest iRequest, Object iBadResponse) {
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.locks.size());
        for (ORID task : this.locks) {
            out.writeObject(task);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.locks.clear();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.locks.add((ORID)in.readObject());
        }
    }

    @Override
    public long getDistributedTimeout() {
        long to = OGlobalConfiguration.DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT.getValueAsLong();
        return to + to / 2L * (long)this.locks.size();
    }

    @Override
    public String getName() {
        return "tx-completed";
    }

    @Override
    public String getPayload() {
        return null;
    }
}

