/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSaveThreadLocal;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;

public abstract class OAbstractRecordReplicatedTask
extends OAbstractReplicatedTask {
    protected ORecordId rid;
    protected int version;
    protected int partitionKey = -1;
    protected boolean lockRecords = true;
    protected transient ORecord previousRecord;

    public OAbstractRecordReplicatedTask init(ORecord record) {
        this.rid = (ORecordId)record.getIdentity();
        this.version = record.getVersion();
        this.definePartitionKey(record);
        return this;
    }

    private void definePartitionKey(ORecord record) {
        Set indexes;
        OClass clazz;
        if (!(record instanceof ODocument) || record == null) {
            return;
        }
        ODocument doc = (ODocument)record;
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db != null && (clazz = db.getMetadata().getSchema().getClassByClusterId(this.rid.getClusterId())) != null && (indexes = clazz.getIndexes()) != null && !indexes.isEmpty()) {
            for (OIndex idx : indexes) {
                boolean changed = false;
                if (doc != null) {
                    for (String changeFiled : doc.getDirtyFields()) {
                        if (!idx.getDefinition().getFields().contains(changeFiled)) continue;
                        changed = true;
                        break;
                    }
                } else {
                    changed = true;
                }
                if (!changed || !idx.isUnique()) continue;
                this.partitionKey = idx.getName().hashCode();
            }
        }
    }

    public OAbstractRecordReplicatedTask init(ORecordId iRid, int iVersion) {
        this.rid = iRid;
        this.version = iVersion;
        this.definePartitionKey(ORecordSaveThreadLocal.getLast());
        return this;
    }

    public abstract Object executeRecordTask(ODistributedRequestId var1, OServer var2, ODistributedServerManager var3, ODatabaseDocumentInternal var4) throws Exception;

    public abstract ORecord getRecord();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedDatabase ddb = iManager.getMessageService().getDatabase(database.getName());
        ORecordId rid2Lock = this.rid;
        if (!this.rid.isPersistent()) {
            rid2Lock = new ORecordId(this.rid.getClusterId(), -1L);
        }
        if (this.lockRecords) {
            ddb.lockRecord((ORID)rid2Lock, requestId, OGlobalConfiguration.DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT.getValueAsLong() / 2L);
        }
        try {
            Object object = this.executeRecordTask(requestId, iServer, iManager, database);
            return object;
        }
        finally {
            if (this.lockRecords) {
                ddb.unlockRecord((OIdentifiable)rid2Lock, requestId);
            }
        }
    }

    @Override
    public int[] getPartitionKey() {
        return new int[]{this.partitionKey > -1 ? this.partitionKey : this.rid.getClusterId()};
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.rid + " v." + this.version + ")";
    }

    public ORecordId getRid() {
        return this.rid;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean checkForClusterAvailability(String localNode, ODistributedConfiguration cfg) {
        String clusterName = ODatabaseRecordThreadLocal.instance().get().getClusterNameById(this.rid.getClusterId());
        return cfg.isServerContainingCluster(localNode, clusterName);
    }

    public ORecord prepareUndoOperation() {
        if (this.previousRecord == null) {
            OStorageOperationResult loaded = ODatabaseRecordThreadLocal.instance().get().getStorage().getUnderlying().readRecord(this.rid, null, true, false, null);
            if (loaded == null || loaded.getResult() == null) {
                return null;
            }
            this.previousRecord = Orient.instance().getRecordFactoryManager().newInstance(((ORawBuffer)loaded.getResult()).recordType);
            ORecordInternal.fill((ORecord)this.previousRecord, (ORID)this.rid, (int)((ORawBuffer)loaded.getResult()).version, (byte[])((ORawBuffer)loaded.getResult()).getBuffer(), (boolean)false);
        }
        return this.previousRecord;
    }

    public void checkRecordExists() {
        this.prepareUndoOperation();
        if (this.previousRecord == null) {
            throw new ORecordNotFoundException((ORID)this.rid);
        }
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        this.rid.toStream(out);
        out.writeInt(this.version);
        out.writeInt(this.partitionKey);
        if (this.lastLSN != null) {
            out.writeBoolean(true);
            this.lastLSN.toStream(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.rid = new ORecordId();
        this.rid.fromStream(in);
        this.version = in.readInt();
        this.partitionKey = in.readInt();
        boolean hasLastLSN = in.readBoolean();
        if (hasLastLSN) {
            this.lastLSN = new OLogSequenceNumber(in);
        }
    }

    public void setLockRecords(boolean lockRecords) {
        this.lockRecords = lockRecords;
    }

    public void setLastLSN(OLogSequenceNumber lastLSN) {
        this.lastLSN = lastLSN;
    }
}

