/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.orient.client.remote.message.OBinaryPushRequest;
import com.orientechnologies.orient.server.OPushManager;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OPushEventType {
    private final ConcurrentMap<String, OBinaryPushRequest<?>> databases = new ConcurrentHashMap();
    protected final ConcurrentMap<String, Set<WeakReference<ONetworkProtocolBinary>>> listeners = new ConcurrentHashMap<String, Set<WeakReference<ONetworkProtocolBinary>>>();

    public synchronized void send(String database, OBinaryPushRequest<?> request, OPushManager pushManager) {
        OBinaryPushRequest<?> prev = this.databases.put(database, request);
        if (prev == null) {
            pushManager.genericNotify(this.listeners, database, this);
        }
    }

    public synchronized OBinaryPushRequest<?> getRequest(String database) {
        return (OBinaryPushRequest)this.databases.remove(database);
    }

    public synchronized void subscribe(String database, ONetworkProtocolBinary protocol) {
        HashSet<WeakReference<ONetworkProtocolBinary>> pushSockets = (HashSet<WeakReference<ONetworkProtocolBinary>>)this.listeners.get(database);
        if (pushSockets == null) {
            pushSockets = new HashSet<WeakReference<ONetworkProtocolBinary>>();
            this.listeners.put(database, pushSockets);
        }
        pushSockets.add(new WeakReference<ONetworkProtocolBinary>(protocol));
    }

    public synchronized void cleanListeners() {
        for (Set value : this.listeners.values()) {
            Iterator iter = value.iterator();
            while (iter.hasNext()) {
                if (((WeakReference)iter.next()).get() != null) continue;
                iter.remove();
            }
        }
    }
}

