/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.orient.core.cache.OCommandCache;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OConcurrentLegacyResultSet;
import com.orientechnologies.orient.core.sql.query.OLegacyResultSet;
import com.orientechnologies.orient.server.network.protocol.binary.OAbstractCommandResultListener;

public final class OCommandCacheRemoteResultListener
extends OAbstractCommandResultListener {
    private final OCommandCache cmdCache;
    private OLegacyResultSet collector = new OConcurrentLegacyResultSet();

    public OCommandCacheRemoteResultListener(OCommandResultListener wrappedResultListener, OCommandCache cmdCache) {
        super(wrappedResultListener);
        this.cmdCache = cmdCache;
    }

    @Override
    public boolean isEmpty() {
        return this.collector != null && this.collector.isEmpty();
    }

    public boolean result(Object iRecord) {
        if (this.collector != null) {
            if (this.collector.currentSize() > this.cmdCache.getMaxResultsetSize()) {
                this.collector = null;
            } else if (iRecord != null && iRecord instanceof ORecord) {
                this.collector.add(iRecord);
            }
        }
        return true;
    }

    @Override
    public Object getResult() {
        return this.collector;
    }

    @Override
    public void end() {
        this.collector.setCompleted();
    }

    public void linkdedBySimpleValue(ODocument doc) {
        if (this.wrappedResultListener instanceof OAbstractCommandResultListener) {
            ((OAbstractCommandResultListener)this.wrappedResultListener).linkdedBySimpleValue(doc);
        }
    }
}

