/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;
import java.util.Iterator;
import java.util.stream.Stream;

public class OServerCommandGetIndex
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"GET|index/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.getUrl(), 3, "Syntax error: index/<database>/<index-name>/<key>");
        iRequest.getData().commandInfo = "Index get";
        try (ODatabaseDocumentInternal db = null;){
            db = this.getProfiledDatabaseInstance(iRequest);
            OIndex index = db.getMetadata().getIndexManagerInternal().getIndex(db, urlParts[2]);
            if (index == null) {
                throw new IllegalArgumentException("Index name '" + urlParts[2] + "' not found");
            }
            try (Stream stream = index.getInternal().getRids((Object)urlParts[3]);){
                Iterator iterator = stream.iterator();
                if (!iterator.hasNext()) {
                    iResponse.send(404, "Not Found", "text/plain", null, null);
                } else {
                    StringBuilder buffer = new StringBuilder(128);
                    buffer.append('[');
                    int count = 0;
                    while (iterator.hasNext()) {
                        ORID item = (ORID)iterator.next();
                        if (count > 0) {
                            buffer.append(", ");
                        }
                        buffer.append(item.getRecord().toJSON());
                        ++count;
                    }
                    buffer.append(']');
                    if (this.isJsonResponse(iResponse)) {
                        iResponse.send(200, "OK", "application/json", buffer.toString(), null);
                    } else {
                        iResponse.send(200, "OK", "text/plain", buffer.toString(), null);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

