/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartContentBaseParser;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartDatabaseImportContentParser;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartRequestCommand;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class OServerCommandPostImportDatabase
extends OHttpMultipartRequestCommand<String, InputStream>
implements OCommandOutputListener {
    protected static final String[] NAMES = new String[]{"POST|import/*"};
    protected StringWriter buffer;
    protected InputStream importData;
    protected ODatabaseDocumentInternal database;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        if (!iRequest.isMultipart()) {
            this.database = this.getProfiledDatabaseInstance(iRequest);
            try {
                ODatabaseImport importer = new ODatabaseImport(this.database, (InputStream)new ByteArrayInputStream(iRequest.getContent().getBytes("UTF8")), (OCommandOutputListener)this);
                for (Map.Entry<String, String> option : iRequest.getParameters().entrySet()) {
                    importer.setOption(option.getKey(), option.getValue());
                }
                importer.importDatabase();
                iResponse.send(200, "OK", "application/json", "{\"responseText\": \"Database imported Correctly, see server log for more informations.\"}", null);
            }
            catch (Exception e) {
                iResponse.send(500, e.getMessage() + ": " + e.getCause() != null ? e.getCause().getMessage() : "", "application/json", "{\"responseText\": \"" + e.getMessage() + ": " + (e.getCause() != null ? e.getCause().getMessage() : "") + "\"}", null);
            }
            finally {
                if (this.database != null) {
                    this.database.close();
                }
                this.database = null;
            }
        } else if (iRequest.getMultipartStream() == null || iRequest.getMultipartStream().available() <= 0) {
            iResponse.send(405, "Content stream is null or empty", "text/plain", "Content stream is null or empty", null);
        } else {
            this.database = this.getProfiledDatabaseInstance(iRequest);
            try {
                this.parse(iRequest, iResponse, new OHttpMultipartContentBaseParser(), new OHttpMultipartDatabaseImportContentParser(), (ODatabaseDocument)this.database);
                ODatabaseImport importer = new ODatabaseImport(this.database, this.importData, (OCommandOutputListener)this);
                for (Map.Entry<String, String> option : iRequest.getParameters().entrySet()) {
                    importer.setOption(option.getKey(), option.getValue());
                }
                importer.importDatabase();
                iResponse.send(200, "OK", "application/json", "{\"responseText\": \"Database imported Correctly, see server log for more informations.\"}", null);
            }
            catch (Exception e) {
                iResponse.send(500, e.getMessage() + ": " + e.getCause() != null ? e.getCause().getMessage() : "", "application/json", "{\"responseText\": \"" + e.getMessage() + ": " + (e.getCause() != null ? e.getCause().getMessage() : "") + "\"}", null);
            }
            finally {
                if (this.database != null) {
                    this.database.close();
                }
                this.database = null;
                if (this.importData != null) {
                    this.importData.close();
                }
                this.importData = null;
            }
        }
        return false;
    }

    @Override
    protected void processBaseContent(OHttpRequest iRequest, String iContentResult, HashMap<String, String> headers) throws Exception {
    }

    @Override
    protected void processFileContent(OHttpRequest iRequest, InputStream iContentResult, HashMap<String, String> headers) throws Exception {
        this.importData = iContentResult;
    }

    @Override
    protected String getDocumentParamenterName() {
        return "linkValue";
    }

    @Override
    protected String getFileParamenterName() {
        return "databaseFile";
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    public void onMessage(String iText) {
        String msg = iText.startsWith("\n") ? iText.substring(1) : iText;
        OLogManager.instance().info((Object)this, msg, OCommonConst.EMPTY_OBJECT_ARRAY);
    }
}

