/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.network.protocol.http.OChunkedResponse;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponseAbstract;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;

public class OHttpResponseImpl
extends OHttpResponseAbstract {
    public OHttpResponseImpl(OutputStream iOutStream, String iHttpVersion, String[] iAdditionalHeaders, String iResponseCharSet, String iServerInfo, String iSessionId, String iCallbackFunction, boolean iKeepAlive, OClientConnection connection, OContextConfiguration contextConfiguration) {
        super(iOutStream, iHttpVersion, iAdditionalHeaders, iResponseCharSet, iServerInfo, iSessionId, iCallbackFunction, iKeepAlive, connection, contextConfiguration);
    }

    @Override
    public void send(int iCode, String iReason, String iContentType, Object iContent, String iHeaders) throws IOException {
        boolean empty;
        if (this.isSendStarted()) {
            return;
        }
        this.setSendStarted(true);
        if (this.getCallbackFunction() != null) {
            this.setContent(this.getCallbackFunction() + "(" + iContent + ")");
            this.setContentType("text/javascript");
        } else {
            if (this.getContent() == null || this.getContent().length() == 0) {
                this.setContent(iContent != null ? iContent.toString() : null);
            }
            if (this.getContentType() == null || this.getContentType().length() == 0) {
                this.setContentType(iContentType);
            }
        }
        boolean bl = empty = this.getContent() == null || this.getContent().length() == 0;
        if (this.getCode() > 0) {
            this.writeStatus(this.getCode(), iReason);
        } else {
            this.writeStatus(empty && iCode == 200 ? 204 : iCode, iReason);
        }
        this.writeHeaders(this.getContentType(), this.isKeepAlive());
        if (iHeaders != null) {
            this.writeLine(iHeaders);
        }
        if (this.getSessionId() != null) {
            String sameSite = this.isSameSiteCookie() ? "SameSite=Strict;" : "";
            this.writeLine("Set-Cookie: OSESSIONID=" + this.getSessionId() + "; Path=/; HttpOnly;" + sameSite);
        }
        byte[] binaryContent = null;
        if (!empty) {
            binaryContent = this.getContentEncoding() != null && this.getContentEncoding().equals("gzip") ? this.compress(this.getContent()) : this.getContent().getBytes(utf8);
        }
        this.writeLine("Content-Length: " + (empty ? 0 : binaryContent.length));
        this.writeLine(null);
        if (binaryContent != null) {
            this.getOut().write(binaryContent);
        }
        this.flush();
    }

    @Override
    public void writeStatus(int iStatus, String iReason) throws IOException {
        this.writeLine(this.getHttpVersion() + " " + iStatus + " " + iReason);
    }

    @Override
    public void sendStream(int iCode, String iReason, String iContentType, InputStream iContent, long iSize) throws IOException {
        this.sendStream(iCode, iReason, iContentType, iContent, iSize, null, null);
    }

    @Override
    public void sendStream(int iCode, String iReason, String iContentType, InputStream iContent, long iSize, String iFileName) throws IOException {
        this.sendStream(iCode, iReason, iContentType, iContent, iSize, iFileName, null);
    }

    @Override
    public void sendStream(int iCode, String iReason, String iContentType, InputStream iContent, long iSize, String iFileName, Map<String, String> additionalHeaders) throws IOException {
        this.writeStatus(iCode, iReason);
        this.writeHeaders(iContentType);
        this.writeLine("Content-Transfer-Encoding: binary");
        if (iFileName != null) {
            this.writeLine("Content-Disposition: attachment; filename=\"" + iFileName + "\"");
        }
        if (additionalHeaders != null) {
            for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                this.writeLine(String.format("%s: %s", entry.getKey(), entry.getValue()));
            }
        }
        if (iSize < 0L) {
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            if (iContent != null) {
                int b;
                while ((b = iContent.read()) > -1) {
                    o.write(b);
                }
            }
            byte[] content = o.toByteArray();
            iContent = new ByteArrayInputStream(content);
            iSize = content.length;
        }
        this.writeLine("Content-Length: " + iSize);
        this.writeLine(null);
        if (iContent != null) {
            int b;
            while ((b = iContent.read()) > -1) {
                this.getOut().write(b);
            }
        }
        this.flush();
    }

    @Override
    public void sendStream(int iCode, String iReason, String iContentType, String iFileName, OCallable<Void, OChunkedResponse> iWriter) throws IOException {
        this.writeStatus(iCode, iReason);
        this.writeHeaders(iContentType);
        this.writeLine("Content-Transfer-Encoding: binary");
        this.writeLine("Transfer-Encoding: chunked");
        if (iFileName != null) {
            this.writeLine("Content-Disposition: attachment; filename=\"" + iFileName + "\"");
        }
        this.writeLine(null);
        OChunkedResponse chunkedOutput = new OChunkedResponse(this);
        iWriter.call((Object)chunkedOutput);
        chunkedOutput.close();
        this.flush();
    }

    @Override
    public void checkConnection() throws IOException {
        Socket socket = this.getConnection().getProtocol() == null || this.getConnection().getProtocol().getChannel() == null ? null : this.getConnection().getProtocol().getChannel().socket;
        if (socket == null || socket.isClosed() || socket.isInputShutdown()) {
            OLogManager.instance().debug((Object)this, "[OHttpResponse] found and removed pending closed channel %d (%s)", new Object[]{this.getConnection(), socket});
            throw new IOException("Connection is closed");
        }
    }
}

