/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.security.OParsedToken;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkHttpExecutor;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartBaseInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class OHttpRequestAbstract
implements OHttpRequest {
    private final OContextConfiguration configuration;
    private final InputStream in;
    private final ONetworkProtocolData data;
    private final ONetworkHttpExecutor executor;
    private String content;
    private Map<String, String> parameters;
    private String sessionId;
    private String authorization;
    private String databaseName;

    public OHttpRequestAbstract(ONetworkHttpExecutor iExecutor, InputStream iInStream, ONetworkProtocolData iData, OContextConfiguration iConfiguration) {
        this.executor = iExecutor;
        this.in = iInStream;
        this.data = iData;
        this.configuration = iConfiguration;
    }

    @Override
    public String getUser() {
        return this.getAuthorization() != null ? this.getAuthorization().substring(0, this.getAuthorization().indexOf(":")) : null;
    }

    @Override
    public InputStream getInputStream() {
        return this.getIn();
    }

    @Override
    public String getParameter(String iName) {
        return this.getParameters() != null ? this.getParameters().get(iName) : null;
    }

    @Override
    public void addHeader(String h) {
        int pos;
        if (this.getHeaders() == null) {
            this.setHeaders(new HashMap<String, String>());
        }
        if ((pos = h.indexOf(58)) > -1) {
            this.getHeaders().put(h.substring(0, pos).trim().toLowerCase(Locale.ENGLISH), h.substring(pos + 1).trim());
        }
    }

    @Override
    public Map<String, String> getUrlEncodedContent() {
        if (this.getContent() == null || this.getContent().length() < 1) {
            return null;
        }
        HashMap<String, String> retMap = new HashMap<String, String>();
        try {
            String[] pairs = this.getContent().split("\\&");
            for (int i = 0; i < pairs.length; ++i) {
                String[] fields = pairs[i].split("=");
                if (fields.length != 2) continue;
                String key = URLDecoder.decode(fields[0], "UTF-8");
                String value = URLDecoder.decode(fields[1], "UTF-8");
                retMap.put(key, value);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return retMap;
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public String getHeader(String iName) {
        return this.getHeaders().get(iName.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public abstract Map<String, String> getHeaders();

    @Override
    public String getRemoteAddress() {
        if (this.getData().caller != null) {
            return this.getData().caller;
        }
        return this.getExecutor().getRemoteAddress();
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public abstract String getUrl();

    @Override
    public OContextConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public InputStream getIn() {
        return this.in;
    }

    @Override
    public ONetworkProtocolData getData() {
        return this.data;
    }

    @Override
    public ONetworkHttpExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public String getAuthorization() {
        return this.authorization;
    }

    @Override
    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public abstract void setUrl(String var1);

    @Override
    public abstract String getHttpMethod();

    @Override
    public abstract void setHttpMethod(String var1);

    @Override
    public abstract String getHttpVersion();

    @Override
    public abstract void setHttpVersion(String var1);

    @Override
    public abstract String getContentType();

    @Override
    public abstract void setContentType(String var1);

    @Override
    public abstract String getContentEncoding();

    @Override
    public abstract void setContentEncoding(String var1);

    @Override
    public abstract String getAcceptEncoding();

    @Override
    public abstract void setAcceptEncoding(String var1);

    @Override
    public abstract OHttpMultipartBaseInputStream getMultipartStream();

    @Override
    public abstract void setMultipartStream(OHttpMultipartBaseInputStream var1);

    @Override
    public abstract String getBoundary();

    @Override
    public abstract void setBoundary(String var1);

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public abstract boolean isMultipart();

    @Override
    public abstract void setMultipart(boolean var1);

    @Override
    public abstract String getIfMatch();

    @Override
    public abstract void setIfMatch(String var1);

    @Override
    public abstract String getAuthentication();

    @Override
    public abstract void setAuthentication(String var1);

    @Override
    public abstract boolean isKeepAlive();

    @Override
    public abstract void setKeepAlive(boolean var1);

    @Override
    public abstract void setHeaders(Map<String, String> var1);

    @Override
    public abstract String getBearerTokenRaw();

    @Override
    public abstract void setBearerTokenRaw(String var1);

    @Override
    public abstract OParsedToken getBearerToken();

    @Override
    public abstract void setBearerToken(OParsedToken var1);
}

