/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;

public class OServerCommandPostClass
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"POST|class/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.getUrl(), 3, "Syntax error: class/<database>/<class-name>");
        iRequest.getData().commandInfo = "Create class";
        iRequest.getData().commandDetail = urlParts[2];
        try (ODatabaseDocumentInternal db = null;){
            db = this.getProfiledDatabaseInstance(iRequest);
            if (db.getMetadata().getSchema().getClass(urlParts[2]) != null) {
                throw new IllegalArgumentException("Class '" + urlParts[2] + "' already exists");
            }
            db.getMetadata().getSchema().createClass(urlParts[2]);
            iResponse.send(201, "Created", "text/plain", db.getMetadata().getSchema().getClasses().size(), null);
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

