/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.orient.client.remote.message.OBinaryPushRequest;
import com.orientechnologies.orient.server.OPushInfo;
import com.orientechnologies.orient.server.OPushManager;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OPushEventType {
    private final ConcurrentMap<String, OBinaryPushRequest<?>> databases = new ConcurrentHashMap();
    protected final ConcurrentMap<String, Set<OPushInfo>> listeners = new ConcurrentHashMap<String, Set<OPushInfo>>();

    public synchronized void send(String database, OBinaryPushRequest<?> request, OPushManager pushManager) {
        OBinaryPushRequest<?> prev = this.databases.put(database, request);
        if (prev == null) {
            pushManager.genericNotify(this.listeners, database, this);
        }
    }

    public synchronized OBinaryPushRequest<?> getRequest(String database) {
        return (OBinaryPushRequest)this.databases.remove(database);
    }

    public synchronized void subscribe(String database, OPushInfo protocol) {
        Set pushSockets = (Set)this.listeners.get(database);
        if (pushSockets == null) {
            pushSockets = Collections.newSetFromMap(new ConcurrentHashMap());
            this.listeners.put(database, pushSockets);
        }
        pushSockets.add(protocol);
    }

    public synchronized void cleanListeners(OPushManager manager) {
        for (Set value : this.listeners.values()) {
            Iterator iter = value.iterator();
            while (iter.hasNext()) {
                OPushInfo ref = (OPushInfo)iter.next();
                if (ref.protocol().get() != null) continue;
                manager.close(ref);
                iter.remove();
            }
        }
    }
}

