/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.security.OSecurityConfig;
import com.orientechnologies.orient.core.security.OSyslog;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerConfigurationManager;
import com.orientechnologies.orient.server.plugin.OServerPluginInfo;

public class OServerSecurityConfig
implements OSecurityConfig {
    private OServer server;
    private OServerConfigurationManager serverCfg;
    private OSyslog sysLog;

    public OServerSecurityConfig(OServer server, OServerConfigurationManager serverCfg) {
        this.server = server;
        this.serverCfg = serverCfg;
    }

    public OSyslog getSyslog() {
        OServerPluginInfo syslogPlugin;
        if (this.sysLog == null && this.server != null && this.server.getPluginManager() != null && (syslogPlugin = this.server.getPluginManager().getPluginByName("syslog")) != null) {
            this.sysLog = (OSyslog)syslogPlugin.getInstance();
        }
        return this.sysLog;
    }

    public String getConfigurationFile() {
        String configFile = OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}/config/security.json");
        String ssf = this.server.getContextConfiguration().getValueAsString(OGlobalConfiguration.SERVER_SECURITY_FILE);
        if (ssf != null) {
            configFile = ssf;
        }
        return configFile;
    }
}

