/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.stresstest;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.stresstest.OConsoleProgressWriter;
import com.orientechnologies.orient.stresstest.ODatabaseIdentifier;
import com.orientechnologies.orient.stresstest.ODatabaseUtils;
import com.orientechnologies.orient.stresstest.OStressTesterCommandLineParser;
import com.orientechnologies.orient.stresstest.OStressTesterSettings;
import com.orientechnologies.orient.stresstest.workload.OCheckWorkload;
import com.orientechnologies.orient.stresstest.workload.OWorkload;
import com.orientechnologies.orient.stresstest.workload.OWorkloadFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OStressTester {
    private final ODatabaseIdentifier databaseIdentifier;
    private OConsoleProgressWriter consoleProgressWriter;
    private final OStressTesterSettings settings;
    private static final OWorkloadFactory workloadFactory = new OWorkloadFactory();
    private List<OWorkload> workloads = new ArrayList<OWorkload>();

    public OStressTester(List<OWorkload> workloads, ODatabaseIdentifier databaseIdentifier, OStressTesterSettings settings) throws Exception {
        this.workloads = workloads;
        this.databaseIdentifier = databaseIdentifier;
        this.settings = settings;
    }

    public static void main(String[] args) {
        System.out.println(String.format("OrientDB Stress Tool v.%s - %s", OConstants.getVersion(), "Copyrights (c) 2016 OrientDB LTD"));
        int returnValue = 1;
        try {
            OStressTester stressTester = OStressTesterCommandLineParser.getStressTester(args);
            returnValue = stressTester.execute();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        System.exit(returnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        int returnCode;
        block10: {
            block8: {
                returnCode = 0;
                OLogManager.instance().setConsoleLevel("SEVERE");
                ODatabaseUtils.createDatabase(this.databaseIdentifier);
                System.out.println(String.format("Created database [%s].", this.databaseIdentifier.getUrl()));
                try {
                    for (OWorkload workload : this.workloads) {
                        this.consoleProgressWriter = new OConsoleProgressWriter(workload);
                        this.consoleProgressWriter.start();
                        this.consoleProgressWriter.printMessage(String.format("\nStarting workload %s (concurrencyLevel=%d)...", workload.getName(), this.settings.concurrencyLevel));
                        long startTime = System.currentTimeMillis();
                        workload.execute(this.settings, this.databaseIdentifier);
                        long endTime = System.currentTimeMillis();
                        this.consoleProgressWriter.sendShutdown();
                        System.out.println(String.format("\n- Total execution time: %.3f secs", Float.valueOf((float)(endTime - startTime) / 1000.0f)));
                        System.out.println(workload.getFinalResult());
                        this.dumpHaMetrics();
                        if (!this.settings.checkDatabase || !(workload instanceof OCheckWorkload)) continue;
                        System.out.println(String.format("- Checking database...", new Object[0]));
                        ((OCheckWorkload)((Object)workload)).check(this.databaseIdentifier);
                        System.out.println(String.format("- Check completed", new Object[0]));
                    }
                    if (this.settings.resultOutputFile != null) {
                        this.writeFile();
                    }
                    if (!this.settings.keepDatabaseAfterTest && this.databaseIdentifier.getMode() != OMode.MEMORY) break block8;
                }
                catch (Exception ex) {
                    block9: {
                        try {
                            System.err.println("\nAn error has occurred while running the stress test: " + ex.getMessage());
                            returnCode = 1;
                            if (!this.settings.keepDatabaseAfterTest && this.databaseIdentifier.getMode() != OMode.MEMORY) break block9;
                        }
                        catch (Throwable throwable) {
                            if (this.settings.keepDatabaseAfterTest || this.databaseIdentifier.getMode() == OMode.MEMORY) {
                                this.consoleProgressWriter.printMessage(String.format("\nDatabase is available on [%s].", this.databaseIdentifier.getUrl()));
                            } else {
                                ODatabaseUtils.dropDatabase(this.databaseIdentifier);
                                this.consoleProgressWriter.printMessage(String.format("\nDropped database [%s].", this.databaseIdentifier.getUrl()));
                            }
                            throw throwable;
                        }
                        this.consoleProgressWriter.printMessage(String.format("\nDatabase is available on [%s].", this.databaseIdentifier.getUrl()));
                    }
                    ODatabaseUtils.dropDatabase(this.databaseIdentifier);
                    this.consoleProgressWriter.printMessage(String.format("\nDropped database [%s].", this.databaseIdentifier.getUrl()));
                }
                this.consoleProgressWriter.printMessage(String.format("\nDatabase is available on [%s].", this.databaseIdentifier.getUrl()));
                break block10;
            }
            ODatabaseUtils.dropDatabase(this.databaseIdentifier);
            this.consoleProgressWriter.printMessage(String.format("\nDropped database [%s].", this.databaseIdentifier.getUrl()));
        }
        return returnCode;
    }

    private void dumpHaMetrics() {
        if (this.settings.haMetrics) {
            ODatabase db = ODatabaseUtils.openDatabase(this.databaseIdentifier, OStorageRemote.CONNECTION_STRATEGY.STICKY);
            try {
                String output = (String)db.command((OCommandRequest)new OCommandSQL("ha status -latency -messages -output=text")).execute(new Object[0]);
                System.out.println("HA METRICS");
                System.out.println(output);
            }
            catch (Exception exception) {
            }
            finally {
                db.close();
            }
        }
    }

    private void writeFile() {
        try {
            StringBuilder output = new StringBuilder();
            output.append("{\"result\":[");
            int i = 0;
            for (OWorkload workload : this.workloads) {
                if (i++ > 0) {
                    output.append(",");
                }
                output.append(workload.getFinalResultAsJson());
            }
            output.append("]}");
            OIOUtils.writeFile((File)new File(this.settings.resultOutputFile), (String)output.toString());
        }
        catch (IOException e) {
            System.err.println("\nError on writing the result file : " + e.getMessage());
        }
    }

    public int getThreadsNumber() {
        return this.settings.concurrencyLevel;
    }

    public OMode getMode() {
        return this.databaseIdentifier.getMode();
    }

    public ODatabaseIdentifier getDatabaseIdentifier() {
        return this.databaseIdentifier;
    }

    public String getPassword() {
        return this.databaseIdentifier.getPassword();
    }

    public int getTransactionsNumber() {
        return this.settings.operationsPerTransaction;
    }

    public static OWorkloadFactory getWorkloadFactory() {
        return workloadFactory;
    }

    public static enum OMode {
        PLOCAL,
        MEMORY,
        REMOTE,
        DISTRIBUTED;

    }
}

