/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.console;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.console.OConsoleApplication;
import com.orientechnologies.common.console.OConsoleReader;
import com.orientechnologies.common.console.TTYConsoleReader;
import com.orientechnologies.common.console.annotation.ConsoleCommand;
import com.orientechnologies.common.console.annotation.ConsoleParameter;
import com.orientechnologies.common.exception.OSystemException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.ODatabaseImportRemote;
import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.console.OTableFormatter;
import com.orientechnologies.orient.console.OrientConsole;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.OSignalHandler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandExecutorScript;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBConfigBuilder;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.db.OrientDBRemote;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentRemote;
import com.orientechnologies.orient.core.db.document.RecordReader;
import com.orientechnologies.orient.core.db.document.SimpleRecordReader;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.tool.OBonsaiTreeRepair;
import com.orientechnologies.orient.core.db.tool.ODatabaseCompare;
import com.orientechnologies.orient.core.db.tool.ODatabaseExport;
import com.orientechnologies.orient.core.db.tool.ODatabaseExportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.core.db.tool.ODatabaseImportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseRepair;
import com.orientechnologies.orient.core.db.tool.OGraphRepair;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORetryQueryException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.intent.OIntentMassiveRead;
import com.orientechnologies.orient.core.iterator.OIdentifiableIterator;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.util.OURLConnection;
import com.orientechnologies.orient.core.util.OURLHelper;
import com.orientechnologies.orient.server.config.OServerConfigurationManager;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class OConsoleDatabaseApp
extends OrientConsole
implements OCommandOutputListener,
OProgressListener {
    protected ODatabaseDocumentInternal currentDatabase;
    protected String currentDatabaseName;
    protected ORecord currentRecord;
    protected int currentRecordIdx;
    protected List<OIdentifiable> currentResultSet;
    protected Object currentResult;
    protected OURLConnection urlConnection;
    protected OrientDB orientDB;
    private int lastPercentStep;
    private String currentDatabaseUserName;
    private String currentDatabaseUserPassword;
    private int maxMultiValueEntries = 10;

    public OConsoleDatabaseApp(String[] args) {
        super(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int result = 0;
        boolean interactiveMode = OConsoleDatabaseApp.isInteractiveMode((String[])args);
        try {
            OConsoleDatabaseApp console = new OConsoleDatabaseApp(args);
            boolean tty = false;
            try {
                if (OConsoleDatabaseApp.setTerminalToCBreak(interactiveMode)) {
                    tty = true;
                }
                Runtime.getRuntime().addShutdownHook(new Thread(() -> OConsoleDatabaseApp.restoreTerminal(interactiveMode)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            new OSignalHandler().installDefaultSignals(signal -> OConsoleDatabaseApp.restoreTerminal(interactiveMode));
            if (tty) {
                console.setReader((OConsoleReader)new TTYConsoleReader(console.historyEnabled()));
            }
            result = console.run();
        }
        finally {
            OConsoleDatabaseApp.restoreTerminal(interactiveMode);
        }
        Orient.instance().shutdown();
        System.exit(result);
    }

    protected static void restoreTerminal(boolean interactiveMode) {
        try {
            OConsoleDatabaseApp.stty("echo", interactiveMode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static boolean setTerminalToCBreak(boolean interactiveMode) throws IOException, InterruptedException {
        int result = OConsoleDatabaseApp.stty("-icanon min 1", interactiveMode);
        if (result != 0) {
            return false;
        }
        OConsoleDatabaseApp.stty("-echo", interactiveMode);
        return true;
    }

    protected static int stty(String args, boolean interactiveMode) throws IOException, InterruptedException {
        if (!interactiveMode) {
            return -1;
        }
        String cmd = "stty " + args + " < /dev/tty";
        Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", cmd});
        p.waitFor(10L, TimeUnit.SECONDS);
        return p.exitValue();
    }

    private void checkDefaultPassword(String database, String user, String password) {
        if (("admin".equals(user) && "admin".equals(password) || "reader".equals(user) && "reader".equals(password) || "writer".equals(user) && "writer".equals(password)) && OGlobalConfiguration.WARNING_DEFAULT_USERS.getValueAsBoolean()) {
            this.message(String.format("IMPORTANT! Using default password is unsafe, please change password for user '%s' on database '%s'", user, database), new Object[0]);
        }
    }

    @ConsoleCommand(aliases={"use database"}, description="Connect to a database or a remote Server instance", onlineHelp="Console-Command-Connect")
    public void connect(@ConsoleParameter(name="url", description="The url of the remote server or the database to connect to in the format '<mode>:<path>'") String iURL, @ConsoleParameter(name="user", description="User name") String iUserName, @ConsoleParameter(name="password", description="User password", optional=true) String iUserPassword) throws IOException {
        this.disconnect();
        if (iUserPassword == null) {
            this.message("Enter password: ", new Object[0]);
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in));
            iUserPassword = br.readLine();
            this.message("\n", new Object[0]);
        }
        this.currentDatabaseUserName = iUserName;
        this.currentDatabaseUserPassword = iUserPassword;
        this.urlConnection = OURLHelper.parseNew((String)iURL);
        if (this.urlConnection.getDbName() != null && !"".equals(this.urlConnection.getDbName())) {
            this.checkDefaultPassword(this.urlConnection.getDbName(), this.currentDatabaseUserName, this.currentDatabaseUserPassword);
        }
        this.orientDB = new OrientDB(this.urlConnection.getType() + ":" + this.urlConnection.getPath(), iUserName, iUserPassword, OrientDBConfig.defaultConfig());
        if (!"".equals(this.urlConnection.getDbName())) {
            this.message("\nConnecting to database [" + iURL + "] with user '" + iUserName + "'...", new Object[0]);
            this.currentDatabase = (ODatabaseDocumentInternal)this.orientDB.open(this.urlConnection.getDbName(), iUserName, iUserPassword);
            this.currentDatabaseName = this.currentDatabase.getName();
        }
        this.message("OK", new Object[0]);
        ODocument distribCfg = this.getDistributedConfiguration();
        if (distribCfg != null) {
            this.listServers();
        }
    }

    @ConsoleCommand(aliases={"close database"}, description="Disconnect from the current database", onlineHelp="Console-Command-Disconnect")
    public void disconnect() {
        if (this.currentDatabase != null) {
            this.message("\nDisconnecting from the database [" + this.currentDatabaseName + "]...", new Object[0]);
            this.currentDatabase.activateOnCurrentThread();
            if (!this.currentDatabase.isClosed()) {
                this.currentDatabase.close();
            }
            this.currentDatabase = null;
            this.currentDatabaseName = null;
            this.currentRecord = null;
            this.message("OK", new Object[0]);
            this.out.println();
        }
        this.urlConnection = null;
        if (this.orientDB != null) {
            this.orientDB.close();
        }
    }

    @ConsoleCommand(description="Create a new database. For encrypted database or portion of database, set the variable 'storage.encryptionKey' with the key to use", onlineHelp="Console-Command-Create-Database")
    public void createDatabase(@ConsoleParameter(name="database-url", description="The url of the database to create in the format '<mode>:<path>'") String databaseURL, @ConsoleParameter(name="user", optional=true, description="Server administrator name") String userName, @ConsoleParameter(name="password", optional=true, description="Server administrator password") String userPassword, @ConsoleParameter(name="storage-type", optional=true, description="The type of the storage: 'plocal' for disk-based databases and 'memory' for in-memory database") String storageType, @ConsoleParameter(name="db-type", optional=true, description="The type of the database used between 'document' and 'graph'. By default is graph.") String databaseType, @ConsoleParameter(name="[options]", optional=true, description="Additional options, example: -encryption=aes -compression=nothing") String options) throws IOException {
        OrientDBInternal internal;
        this.disconnect();
        if (userName == null) {
            userName = "admin";
        }
        if (userPassword == null) {
            userPassword = "admin";
        }
        this.currentDatabaseUserName = userName;
        this.currentDatabaseUserPassword = userPassword;
        Map<String, String> omap = this.parseCommandOptions(options);
        this.urlConnection = OURLHelper.parseNew((String)databaseURL);
        OrientDBConfigBuilder config = OrientDBConfig.builder();
        for (Map.Entry<String, String> oentry : omap.entrySet()) {
            if ("-encryption".equalsIgnoreCase(oentry.getKey())) {
                config.addConfig(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD, (Object)oentry.getValue());
                continue;
            }
            if (!"-compression".equalsIgnoreCase(oentry.getKey())) continue;
            config.addConfig(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD, (Object)oentry.getValue());
        }
        ODatabaseType type = storageType != null ? ODatabaseType.valueOf((String)storageType.toUpperCase()) : this.urlConnection.getDbType().orElse(ODatabaseType.PLOCAL);
        this.message("\nCreating database [" + databaseURL + "] using the storage type [" + type + "]...", new Object[0]);
        String conn = this.urlConnection.getType() + ":" + this.urlConnection.getPath();
        if (this.orientDB != null) {
            OrientDBInternal contectSession = OrientDBInternal.extract((OrientDB)this.orientDB);
            String user = OrientDBInternal.extractUser((OrientDB)this.orientDB);
            if (!contectSession.getConnectionUrl().equals(conn) || user == null || !user.equals(userName)) {
                this.orientDB = new OrientDB(conn, this.currentDatabaseUserName, this.currentDatabaseUserPassword, config.build());
            }
        } else {
            this.orientDB = new OrientDB(conn, this.currentDatabaseUserName, this.currentDatabaseUserPassword, config.build());
        }
        String backupPath = omap.remove("-restore");
        if (backupPath != null) {
            internal = OrientDBInternal.extract((OrientDB)this.orientDB);
            internal.restore(this.urlConnection.getDbName(), this.currentDatabaseUserName, this.currentDatabaseUserPassword, type, backupPath, config.build());
        } else {
            internal = OrientDBInternal.extract((OrientDB)this.orientDB);
            if (internal.isEmbedded()) {
                this.orientDB.execute("create database ? " + type + " users (? identified by ? role admin) ", new Object[]{this.urlConnection.getDbName(), this.currentDatabaseUserName, this.currentDatabaseUserPassword});
            } else {
                this.orientDB.create(this.urlConnection.getDbName(), (ODatabaseType)this.urlConnection.getDbType().get());
            }
        }
        this.currentDatabase = (ODatabaseDocumentInternal)this.orientDB.open(this.urlConnection.getDbName(), userName, userPassword);
        this.currentDatabaseName = this.currentDatabase.getName();
        this.message("\nDatabase created successfully.", new Object[0]);
        this.message("\n\nCurrent database is: " + databaseURL, new Object[0]);
    }

    protected Map<String, String> parseCommandOptions(@ConsoleParameter(name="[options]", optional=true, description="Additional options, example: -encryption=aes -compression=nothing") String options) {
        HashMap<String, String> omap = new HashMap<String, String>();
        if (options != null) {
            List kvOptions = OStringSerializerHelper.smartSplit((String)options, (char)',', (boolean)false, (char[])new char[0]);
            for (String option : kvOptions) {
                String[] values = option.split("=");
                if (values.length == 2) {
                    omap.put(values[0], values[1]);
                    continue;
                }
                omap.put(values[0], null);
            }
        }
        return omap;
    }

    @ConsoleCommand(description="List all the databases available on the connected server", onlineHelp="Console-Command-List-Databases")
    public void listDatabases() throws IOException {
        if (this.orientDB != null) {
            List databases = this.orientDB.list();
            this.message("\nFound %d databases:\n", new Object[]{databases.size()});
            for (String database : databases) {
                this.message("\n* %s ", new Object[]{database});
            }
        } else {
            this.message("\nNot connected to the Server instance. You've to connect to the Server using server's credentials (look at orientdb-*server-config.xml file)", new Object[0]);
        }
        this.out.println();
    }

    @ConsoleCommand(description="List all the active connections to the server", onlineHelp="Console-Command-List-Connections")
    public void listConnections() throws IOException {
        this.checkForRemoteServer();
        OrientDBRemote remote = (OrientDBRemote)OrientDBInternal.extract((OrientDB)this.orientDB);
        ODocument serverInfo = remote.getServerInfo(this.currentDatabaseUserName, this.currentDatabaseUserPassword);
        ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
        List connections = (List)serverInfo.field("connections");
        for (Map conn : connections) {
            ODocument row = new ODocument();
            String commandDetail = (String)conn.get("commandInfo");
            if (commandDetail != null && ((String)conn.get("commandDetail")).length() > 1) {
                commandDetail = commandDetail + " (" + conn.get("commandDetail") + ")";
            }
            row.fields("ID", conn.get("connectionId"), new Object[]{"REMOTE_ADDRESS", conn.get("remoteAddress"), "PROTOC", conn.get("protocol"), "LAST_OPERATION_ON", conn.get("lastCommandOn"), "DATABASE", conn.get("db"), "USER", conn.get("user"), "COMMAND", commandDetail, "TOT_REQS", conn.get("totalRequests")});
            resultSet.add(row);
        }
        Collections.sort(resultSet, new Comparator<OIdentifiable>(){

            @Override
            public int compare(OIdentifiable o1, OIdentifiable o2) {
                String o1s = (String)((ODocument)o1).field("LAST_OPERATION_ON");
                String o2s = (String)((ODocument)o2).field("LAST_OPERATION_ON");
                return o2s.compareTo(o1s);
            }
        });
        OTableFormatter formatter = new OTableFormatter(this);
        formatter.setMaxWidthSize(this.getConsoleWidth());
        formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
        formatter.writeRecords(resultSet, -1);
        this.out.println();
    }

    @ConsoleCommand(description="Reload the database schema")
    public void reloadSchema() throws IOException {
        this.message("\nreloading database schema...", new Object[0]);
        this.updateDatabaseInfo();
        this.message("\n\nDone.", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Create a new cluster in the current database. The cluster can be physical or memory")
    public void createCluster(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nCluster created correctly in %.2f seconds\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Remove a cluster in the current database. The cluster can be physical or memory")
    public void dropCluster(@ConsoleParameter(name="cluster-name", description="The name or the id of the cluster to remove") String iClusterName) {
        this.checkForDatabase();
        this.message("\nDropping cluster [" + iClusterName + "] in database " + this.currentDatabaseName + "...", new Object[0]);
        boolean result = this.currentDatabase.dropCluster(iClusterName);
        if (!result) {
            try {
                int clusterId = Integer.parseInt(iClusterName);
                if (clusterId > -1) {
                    result = this.currentDatabase.dropCluster(clusterId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result) {
            this.message("\nCluster correctly removed", new Object[0]);
        } else {
            this.message("\nCannot find the cluster to remove", new Object[0]);
        }
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Alters a cluster in the current database. The cluster can be physical or memory")
    public void alterCluster(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nCluster updated successfully.\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Begins a transaction. All the changes will remain local")
    public void begin() throws IOException {
        this.checkForDatabase();
        if (this.currentDatabase.getTransaction().isActive()) {
            this.message("\nError: an active transaction is currently open (id=" + this.currentDatabase.getTransaction().getId() + "). Commit or rollback before starting a new one.", new Object[0]);
            return;
        }
        if (this.currentDatabase.isRemote()) {
            this.message("\nWARNING - Transactions are not supported from console in remote, please use an sql script: \neg.\n\nscript sql\nbegin;\n<your commands here>\ncommit;\nend\n\n", new Object[0]);
            return;
        }
        this.currentDatabase.begin();
        this.message("\nTransaction " + this.currentDatabase.getTransaction().getId() + " is running", new Object[0]);
    }

    @ConsoleCommand(description="Commits transaction changes to the database")
    public void commit() throws IOException {
        this.checkForDatabase();
        if (!this.currentDatabase.getTransaction().isActive()) {
            this.message("\nError: no active transaction is currently open.", new Object[0]);
            return;
        }
        long begin = System.currentTimeMillis();
        int txId = this.currentDatabase.getTransaction().getId();
        this.currentDatabase.commit();
        this.message("\nTransaction " + txId + " has been committed in " + (System.currentTimeMillis() - begin) + "ms", new Object[0]);
    }

    @ConsoleCommand(description="Rolls back transaction changes to the previous state")
    public void rollback() throws IOException {
        this.checkForDatabase();
        if (!this.currentDatabase.getTransaction().isActive()) {
            this.message("\nError: no active transaction is running right now.", new Object[0]);
            return;
        }
        long begin = System.currentTimeMillis();
        int txId = this.currentDatabase.getTransaction().getId();
        this.currentDatabase.rollback();
        this.message("\nTransaction " + txId + " has been rollbacked in " + (System.currentTimeMillis() - begin) + "ms", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Truncate the class content in the current database")
    public void truncateClass(@ConsoleParameter(name="text", description="The name of the class to truncate") String iCommandText) {
        this.sqlCommand("truncate", iCommandText, "\nClass truncated.\n", false);
    }

    @ConsoleCommand(splitInWords=false, description="Truncate the cluster content in the current database")
    public void truncateCluster(@ConsoleParameter(name="text", description="The name of the class to truncate") String iCommandText) {
        this.sqlCommand("truncate", iCommandText, "\nTruncated %d record(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Truncate a record deleting it at low level")
    public void truncateRecord(@ConsoleParameter(name="text", description="The record(s) to truncate") String iCommandText) {
        this.sqlCommand("truncate", iCommandText, "\nTruncated %d record(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(description="Load a record in memory using passed fetch plan")
    public void loadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId, @ConsoleParameter(name="fetch-plan", description="The fetch plan to load the record with") String iFetchPlan) {
        this.loadRecordInternal(iRecordId, iFetchPlan);
    }

    @ConsoleCommand(description="Load a record in memory and set it as the current")
    public void loadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId) {
        this.loadRecordInternal(iRecordId, null);
    }

    @ConsoleCommand(description="Reloads a record using passed fetch plan")
    public void reloadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId, @ConsoleParameter(name="fetch-plan", description="The fetch plan to load the record with") String iFetchPlan) {
        this.reloadRecordInternal(iRecordId, iFetchPlan);
    }

    @ConsoleCommand(description="Reload a record and set it as the current one", onlineHelp="Console-Command-Reload-Record")
    public void reloadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId) {
        this.reloadRecordInternal(iRecordId, null);
    }

    @ConsoleCommand(splitInWords=false, description="Explain how a command is executed profiling it", onlineHelp="SQL-Explain")
    public void explain(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        Object result = this.sqlCommand("explain", iCommandText, "\n", false);
        if (result != null && result instanceof ODocument) {
            this.message((String)((ODocument)result).getProperty("executionPlanAsString"), new Object[0]);
        } else if (result != null && result instanceof List && ((List)result).size() == 1 && ((List)result).get(0) instanceof OResult) {
            this.message((String)((OResult)((List)result).get(0)).getProperty("executionPlanAsString"), new Object[0]);
        } else if (result != null && result instanceof List && ((List)result).size() == 1 && ((List)result).get(0) instanceof ODocument) {
            this.message((String)((ODocument)((List)result).get(0)).getProperty("executionPlanAsString"), new Object[0]);
        }
    }

    @ConsoleCommand(splitInWords=false, description="Executes a command inside a transaction")
    public void transactional(@ConsoleParameter(name="command-text", description="The command to execute") String iCommandText) {
        this.sqlCommand("transactional", iCommandText, "\nResult: '%s'. Executed in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Insert a new record into the database", onlineHelp="SQL-Insert")
    public void insert(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("insert", iCommandText, "\nInserted record '%s' in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Create a new vertex into the database", onlineHelp="SQL-Create-Vertex")
    public void createVertex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nCreated vertex '%s' in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Create a new edge into the database", onlineHelp="SQL-Create-Edge")
    public void createEdge(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        String command = "create " + iCommandText;
        this.resetResultSet();
        long start = System.currentTimeMillis();
        OResultSet rs = this.currentDatabase.command(command, new Object[0]);
        List<OIdentifiable> result = rs.stream().map(x -> x.toElement()).collect(Collectors.toList());
        rs.close();
        float elapsedSeconds = this.getElapsedSecs(start);
        this.setResultset(result);
        int displayLimit = Integer.parseInt((String)this.properties.get("limit"));
        this.dumpResultSet(displayLimit);
        this.message("\nCreated '%s' edges in %f sec(s).\n", new Object[]{result.size(), Float.valueOf(elapsedSeconds)});
    }

    @ConsoleCommand(description="Switches on storage profiling for upcoming set of commands")
    public void profileStorageOn() {
        this.sqlCommand("profile", " storage on", "\nProfiling of storage is switched on.\n", false);
    }

    @ConsoleCommand(description="Switches off storage profiling for issued set of commands and returns reslut of profiling.")
    public void profileStorageOff() {
        Collection result = (Collection)this.sqlCommand("profile", " storage off", "\nProfiling of storage is switched off\n", false);
        String profilingWasNotSwitchedOn = "Can not retrieve results of profiling, probably profiling was not switched on";
        if (result == null) {
            this.message("Can not retrieve results of profiling, probably profiling was not switched on", new Object[0]);
            return;
        }
        Iterator profilerIterator = result.iterator();
        if (profilerIterator.hasNext()) {
            ODocument profilerDocument = (ODocument)profilerIterator.next();
            if (profilerDocument == null) {
                this.message("Can not retrieve results of profiling, probably profiling was not switched on", new Object[0]);
            } else {
                this.message("Profiling result is : \n%s\n", new Object[]{profilerDocument.toJSON("prettyPrint")});
            }
        } else {
            this.message("Can not retrieve results of profiling, probably profiling was not switched on", new Object[0]);
        }
    }

    @ConsoleCommand(splitInWords=false, description="Update records in the database", onlineHelp="SQL-Update")
    public void update(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("update", iCommandText, "\nUpdated record(s) '%s' in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.currentDatabase.getLocalCache().invalidate();
    }

    @ConsoleCommand(splitInWords=false, description="High Availability commands", onlineHelp="SQL-HA")
    public void ha(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("ha", iCommandText, "\nExecuted '%s' in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Move vertices to another position (class/cluster)", priority=8, onlineHelp="SQL-Move-Vertex")
    public void moveVertex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("move", iCommandText, "\nMove vertex command executed with result '%s' in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Optimizes the current database", onlineHelp="SQL-Optimize-Database")
    public void optimizeDatabase(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("optimize", iCommandText, "\nDatabase optimized '%s' in %f sec(s).\n", true);
    }

    @ConsoleCommand(description="Force calling of JVM Garbage Collection")
    public void gc() {
        System.gc();
    }

    @ConsoleCommand(splitInWords=false, description="Delete records from the database", onlineHelp="SQL-Delete")
    public void delete(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("delete", iCommandText, "\nDelete record(s) '%s' in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.currentDatabase.getLocalCache().invalidate();
    }

    @ConsoleCommand(splitInWords=false, description="Grant privileges to a role", onlineHelp="SQL-Grant")
    public void grant(@ConsoleParameter(name="text", description="Grant command") String iCommandText) {
        this.sqlCommand("grant", iCommandText, "\nPrivilege granted to the role: %s.\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Revoke privileges to a role", onlineHelp="SQL-Revoke")
    public void revoke(@ConsoleParameter(name="text", description="Revoke command") String iCommandText) {
        this.sqlCommand("revoke", iCommandText, "\nPrivilege revoked to the role: %s.\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Create a link from a JOIN", onlineHelp="SQL-Create-Link")
    public void createLink(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nCreated %d link(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Find all references the target record id @rid", onlineHelp="SQL-Find-References")
    public void findReferences(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("find", iCommandText, "\nFound %s in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Alter a database property", onlineHelp="SQL-Alter-Database")
    public void alterDatabase(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nDatabase updated successfully.\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Freeze database and flush on the disk", onlineHelp="Console-Command-Freeze-Database")
    public void freezeDatabase(@ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.checkForDatabase();
        String dbName = this.currentDatabase.getName();
        if (this.currentDatabase.getURL().startsWith("remote")) {
            if (storageType == null) {
                storageType = "plocal";
            }
            new OServerAdmin(this.currentDatabase.getURL()).connect(this.currentDatabaseUserName, this.currentDatabaseUserPassword).freezeDatabase(storageType);
        } else {
            this.currentDatabase.freeze();
        }
        this.message("\n\nDatabase '" + dbName + "' was frozen successfully", new Object[0]);
    }

    @ConsoleCommand(description="Release database after freeze", onlineHelp="Console-Command-Release-Db")
    public void releaseDatabase(@ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.checkForDatabase();
        String dbName = this.currentDatabase.getName();
        if (this.currentDatabase.getURL().startsWith("remote")) {
            if (storageType == null) {
                storageType = "plocal";
            }
            new OServerAdmin(this.currentDatabase.getURL()).connect(this.currentDatabaseUserName, this.currentDatabaseUserPassword).releaseDatabase(storageType);
        } else {
            this.currentDatabase.release();
        }
        this.message("\n\nDatabase '" + dbName + "' was released successfully", new Object[0]);
    }

    @ConsoleCommand(description="Flushes all database content to the disk")
    public void flushDatabase(@ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.freezeDatabase(storageType);
        this.releaseDatabase(storageType);
    }

    @ConsoleCommand(description="Display current record")
    public void current() {
        this.dumpRecordDetails();
    }

    @ConsoleCommand(description="Move the current record stream to the next one in result set")
    public void next() {
        this.setCurrentRecord(this.currentRecordIdx + 1);
        this.dumpRecordDetails();
    }

    @ConsoleCommand(description="Move the current record stream to the previous one in result set")
    public void prev() {
        this.setCurrentRecord(this.currentRecordIdx - 1);
        this.dumpRecordDetails();
    }

    @ConsoleCommand(splitInWords=false, description="Alter a class in the database schema")
    public void alterClass(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nClass updated successfully.\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Create a class", onlineHelp="SQL-Create-Class")
    public void createClass(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nClass created successfully.\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Create a sequence in the database")
    public void createSequence(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nSequence created successfully.\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Alter an existent sequence in the database")
    public void alterSequence(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nSequence altered successfully.\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Remove a sequence from the database")
    public void dropSequence(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("drop", iCommandText, "Sequence removed successfully.\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Create a user", onlineHelp="SQL-Create-User")
    public void createUser(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nUser created successfully.\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Drop a user", onlineHelp="SQL-Drop-User")
    public void dropUser(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("drop", iCommandText, "\nUser dropped successfully.\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Alter a class property in the database schema", onlineHelp="SQL-Alter-Property")
    public void alterProperty(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nProperty updated successfully.\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Create a property", onlineHelp="SQL-Create-Property")
    public void createProperty(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nProperty created successfully.\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Create a stored function", onlineHelp="SQL-Create-Function")
    public void createFunction(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nFunction created successfully with id=%s.\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Traverse records and display the results", onlineHelp="SQL-Traverse")
    public void traverse(@ConsoleParameter(name="query-text", description="The traverse to execute") String iQueryText) {
        int limit = iQueryText.toLowerCase(Locale.ENGLISH).contains(" limit ") ? -1 : Integer.parseInt((String)this.properties.get("limit"));
        long start = System.currentTimeMillis();
        OResultSet rs = this.currentDatabase.command("traverse " + iQueryText, new Object[0]);
        this.setResultset(rs.stream().map(x -> x.toElement()).collect(Collectors.toList()));
        rs.close();
        float elapsedSeconds = this.getElapsedSecs(start);
        this.dumpResultSet(limit);
        this.message("\n\n" + this.currentResultSet.size() + " item(s) found. Traverse executed in " + elapsedSeconds + " sec(s).", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Execute a query against the database and display the results", onlineHelp="SQL-Query")
    public void select(@ConsoleParameter(name="query-text", description="The query to execute") String iQueryText) {
        int displayLimit;
        int queryLimit;
        this.checkForDatabase();
        if (iQueryText == null) {
            return;
        }
        if ((iQueryText = iQueryText.trim()).length() == 0 || iQueryText.equalsIgnoreCase("select")) {
            return;
        }
        iQueryText = "select " + iQueryText;
        if (iQueryText.toLowerCase(Locale.ENGLISH).contains(" limit ")) {
            queryLimit = -1;
            displayLimit = -1;
        } else {
            displayLimit = Integer.parseInt((String)this.properties.get("limit"));
            queryLimit = displayLimit > 0 ? displayLimit + 1 : -1;
        }
        long start = System.currentTimeMillis();
        ArrayList<OIdentifiable> result = new ArrayList<OIdentifiable>();
        try (OResultSet rs = this.currentDatabase.query(iQueryText, new Object[0]);){
            int count = 0;
            while (rs.hasNext() && (queryLimit < 0 || count < queryLimit)) {
                OResult item = rs.next();
                if (item.isBlob()) {
                    result.add((OIdentifiable)item.getBlob().get());
                    continue;
                }
                result.add((OIdentifiable)item.toElement());
            }
        }
        this.setResultset(result);
        float elapsedSeconds = this.getElapsedSecs(start);
        this.dumpResultSet(displayLimit);
        long tot = displayLimit > -1 ? (long)Math.min(this.currentResultSet.size(), displayLimit) : (long)this.currentResultSet.size();
        this.message("\n\n" + tot + " item(s) found. Query executed in " + elapsedSeconds + " sec(s).", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Execute a MATCH query against the database and display the results", onlineHelp="SQL-Match")
    public void match(@ConsoleParameter(name="query-text", description="The query to execute") String iQueryText) {
        int displayLimit;
        int queryLimit;
        this.checkForDatabase();
        if (iQueryText == null) {
            return;
        }
        if ((iQueryText = iQueryText.trim()).length() == 0 || iQueryText.equalsIgnoreCase("match")) {
            return;
        }
        iQueryText = "match " + iQueryText;
        if (iQueryText.toLowerCase(Locale.ENGLISH).contains(" limit ")) {
            queryLimit = -1;
            displayLimit = -1;
        } else {
            displayLimit = Integer.parseInt((String)this.properties.get("limit"));
            queryLimit = displayLimit + 1;
        }
        long start = System.currentTimeMillis();
        ArrayList<OIdentifiable> result = new ArrayList<OIdentifiable>();
        OResultSet rs = this.currentDatabase.query(iQueryText, new Object[0]);
        int count = 0;
        while (rs.hasNext() && (queryLimit < 0 || count < queryLimit)) {
            result.add((OIdentifiable)rs.next().toElement());
        }
        rs.close();
        this.setResultset(result);
        float elapsedSeconds = this.getElapsedSecs(start);
        this.dumpResultSet(displayLimit);
        long tot = displayLimit > -1 ? (long)Math.min(this.currentResultSet.size(), displayLimit) : (long)this.currentResultSet.size();
        this.message("\n\n" + tot + " item(s) found. Query executed in " + elapsedSeconds + " sec(s).", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Move from current record by evaluating a predicate against current record")
    public void move(@ConsoleParameter(name="text", description="The sql predicate to evaluate") String iText) {
        if (iText == null) {
            return;
        }
        if (this.currentRecord == null) {
            return;
        }
        Object result = new OSQLPredicate(iText).evaluate((OIdentifiable)this.currentRecord, null, null);
        if (result != null) {
            if (result instanceof OIdentifiable) {
                this.setResultset(new ArrayList<OIdentifiable>());
                this.currentRecord = ((OIdentifiable)result).getRecord();
                this.dumpRecordDetails();
            } else if (result instanceof List) {
                this.setResultset((List)result);
                this.dumpResultSet(-1);
            } else if (result instanceof Iterator) {
                ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>();
                while (((Iterator)result).hasNext()) {
                    list.add((OIdentifiable)((Iterator)result).next());
                }
                this.setResultset(list);
                this.dumpResultSet(-1);
            } else {
                this.setResultset(new ArrayList<OIdentifiable>());
            }
        }
    }

    @ConsoleCommand(splitInWords=false, description="Evaluate a predicate against current record")
    public void eval(@ConsoleParameter(name="text", description="The sql predicate to evaluate") String iText) {
        if (iText == null) {
            return;
        }
        if (this.currentRecord == null) {
            return;
        }
        Object result = new OSQLPredicate(iText).evaluate((OIdentifiable)this.currentRecord, null, null);
        if (result != null) {
            this.out.println("\n" + result);
        }
    }

    @ConsoleCommand(splitInWords=false, description="Execute a script containing multiple commands separated by ; or new line")
    public void script(@ConsoleParameter(name="text", description="Commands to execute, one per line") String iText) {
        int languageEndPos = iText.indexOf(";");
        String[] splitted = iText.split(" ")[0].split(";")[0].split("\n")[0].split("\t");
        String language = splitted[0];
        if ((iText = iText.substring(language.length() + 1)).trim().length() == 0) {
            throw new IllegalArgumentException("Missing language in script (sql, js, gremlin, etc.) as first argument");
        }
        this.executeServerSideScript(language, iText);
    }

    @ConsoleCommand(splitInWords=false, description="Execute javascript commands in the console")
    public void js(@ConsoleParameter(name="text", description="The javascript to execute. Use 'db' to reference to a document database, 'gdb' for a graph database") String iText) {
        if (iText == null) {
            return;
        }
        this.resetResultSet();
        long start = System.currentTimeMillis();
        while (true) {
            try {
                OCommandExecutorScript cmd = new OCommandExecutorScript();
                cmd.parse((OCommandRequest)new OCommandScript("Javascript", iText));
                this.currentResult = cmd.execute(null);
            }
            catch (ORetryQueryException e) {
                continue;
            }
            break;
        }
        float elapsedSeconds = this.getElapsedSecs(start);
        this.parseResult();
        if (this.currentResultSet != null) {
            this.dumpResultSet(-1);
            this.message("\nClient side script executed in %f sec(s). Returned %d records", new Object[]{Float.valueOf(elapsedSeconds), this.currentResultSet.size()});
        } else {
            this.message("\nClient side script executed in %f sec(s). Value returned is: %s", new Object[]{Float.valueOf(elapsedSeconds), this.currentResult});
        }
    }

    @ConsoleCommand(splitInWords=false, description="Execute javascript commands against a remote server")
    public void jss(@ConsoleParameter(name="text", description="The javascript to execute. Use 'db' to reference to a document database, 'gdb' for a graph database") String iText) {
        this.checkForRemoteServer();
        this.executeServerSideScript("javascript", iText);
    }

    @ConsoleCommand(description="Set a server user. If the user already exists, the password and permissions are updated. For more information look at http://orientdb.com/docs/last/Security.html#orientdb-server-security", onlineHelp="Console-Command-Set-Server-User")
    public void setServerUser(@ConsoleParameter(name="user-name", description="User name") String iServerUserName, @ConsoleParameter(name="user-password", description="User password") String iServerUserPasswd, @ConsoleParameter(name="user-permissions", description="Permissions, look at http://orientdb.com/docs/last/Security.html#servers-resources") String iPermissions) {
        if (iServerUserName == null || iServerUserName.length() == 0) {
            throw new IllegalArgumentException("User name null or empty");
        }
        if (iPermissions == null || iPermissions.length() == 0) {
            throw new IllegalArgumentException("User permissions null or empty");
        }
        File serverCfgFile = new File("../config/orientdb-server-config.xml");
        if (!serverCfgFile.exists()) {
            throw new OConfigurationException("Cannot access to file " + serverCfgFile);
        }
        try {
            OServerConfigurationManager serverCfg = new OServerConfigurationManager(serverCfgFile);
            String defAlgo = OGlobalConfiguration.SECURITY_USER_PASSWORD_DEFAULT_ALGORITHM.getValueAsString();
            String hashedPassword = OSecurityManager.createHash((String)iServerUserPasswd, (String)defAlgo, (boolean)true);
            serverCfg.setUser(iServerUserName, hashedPassword, iPermissions);
            serverCfg.saveConfiguration();
            this.message("\nServer user '%s' set correctly", new Object[]{iServerUserName});
        }
        catch (Exception e) {
            this.error("\nError on loading %s file: %s", new Object[]{serverCfgFile, e.toString()});
        }
    }

    @ConsoleCommand(description="Drop a server user. For more information look at http://orientdb.com/docs/last/Security.html#orientdb-server-security", onlineHelp="Console-Command-Drop-Server-User")
    public void dropServerUser(@ConsoleParameter(name="user-name", description="User name") String iServerUserName) {
        if (iServerUserName == null || iServerUserName.length() == 0) {
            throw new IllegalArgumentException("User name null or empty");
        }
        File serverCfgFile = new File("../config/orientdb-server-config.xml");
        if (!serverCfgFile.exists()) {
            throw new OConfigurationException("Cannot access to file " + serverCfgFile);
        }
        try {
            OServerConfigurationManager serverCfg = new OServerConfigurationManager(serverCfgFile);
            if (!serverCfg.existsUser(iServerUserName)) {
                this.error("\nServer user '%s' not found in configuration", new Object[]{iServerUserName});
                return;
            }
            serverCfg.dropUser(iServerUserName);
            serverCfg.saveConfiguration();
            this.message("\nServer user '%s' dropped correctly", new Object[]{iServerUserName});
        }
        catch (Exception e) {
            this.error("\nError on loading %s file: %s", new Object[]{serverCfgFile, e.toString()});
        }
    }

    @ConsoleCommand(description="Display all the server user names. For more information look at http://orientdb.com/docs/last/Security.html#orientdb-server-security", onlineHelp="Console-Command-List-Server-User")
    public void listServerUsers() {
        File serverCfgFile = new File("../config/orientdb-server-config.xml");
        if (!serverCfgFile.exists()) {
            throw new OConfigurationException("Cannot access to file " + serverCfgFile);
        }
        try {
            OServerConfigurationManager serverCfg = new OServerConfigurationManager(serverCfgFile);
            this.message("\nSERVER USERS\n", new Object[0]);
            Set<OServerUserConfiguration> users = serverCfg.getUsers();
            if (users.isEmpty()) {
                this.message("\nNo users found", new Object[0]);
            } else {
                for (OServerUserConfiguration u : users) {
                    this.message("\n- '%s', permissions: %s", new Object[]{u.name, u.resources});
                }
            }
        }
        catch (Exception e) {
            this.error("\nError on loading %s file: %s", new Object[]{serverCfgFile, e.toString()});
        }
    }

    @ConsoleCommand(splitInWords=false, description="Create an index against a property", onlineHelp="SQL-Create-Index")
    public void createIndex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.message("\n\nCreating index...", new Object[0]);
        this.sqlCommand("create", iCommandText, "\nCreated index successfully in %f sec(s).\n", false);
        this.updateDatabaseInfo();
        this.message("\n\nIndex created successfully", new Object[0]);
    }

    @ConsoleCommand(description="Delete the current database", onlineHelp="Console-Command-Drop-Database")
    public void dropDatabase(@ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.checkForDatabase();
        String dbName = this.currentDatabase.getName();
        this.currentDatabase.close();
        if (!(storageType == null || "plocal".equalsIgnoreCase(storageType) || "local".equalsIgnoreCase(storageType) || "memory".equalsIgnoreCase(storageType))) {
            this.message("\n\nInvalid storage type for db: '" + storageType + "'", new Object[0]);
            return;
        }
        this.orientDB.drop(dbName);
        this.currentDatabase = null;
        this.currentDatabaseName = null;
        this.message("\n\nDatabase '" + dbName + "' deleted successfully", new Object[0]);
    }

    @ConsoleCommand(description="Delete the specified database", onlineHelp="Console-Command-Drop-Database")
    public void dropDatabase(@ConsoleParameter(name="database-url", description="The url of the database to drop in the format '<mode>:<path>'") String iDatabaseURL, @ConsoleParameter(name="user", description="Server administrator name") String iUserName, @ConsoleParameter(name="password", description="Server administrator password") String iUserPassword, @ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.connect(iDatabaseURL, iUserName, iUserPassword);
        this.dropDatabase(null);
    }

    @ConsoleCommand(splitInWords=false, description="Remove an index", onlineHelp="SQL-Drop-Index")
    public void dropIndex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.message("\n\nRemoving index...", new Object[0]);
        this.sqlCommand("drop", iCommandText, "\nDropped index in %f sec(s).\n", false);
        this.updateDatabaseInfo();
        this.message("\n\nIndex removed successfully", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Rebuild an index if it is automatic", onlineHelp="SQL-Rebuild-Index")
    public void rebuildIndex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.message("\n\nRebuilding index(es)...", new Object[0]);
        this.sqlCommand("rebuild", iCommandText, "\nRebuilt index(es). Found %d link(s) in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.message("\n\nIndex(es) rebuilt successfully", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Remove a class from the schema", onlineHelp="SQL-Drop-Class")
    public void dropClass(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.sqlCommand("drop", iCommandText, "\nRemoved class in %f sec(s).\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Remove a property from a class", onlineHelp="SQL-Drop-Property")
    public void dropProperty(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.sqlCommand("drop", iCommandText, "\nRemoved class property in %f sec(s).\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Browse all records of a class", onlineHelp="Console-Command-Browse-Class")
    public void browseClass(@ConsoleParameter(name="class-name", description="The name of the class") String iClassName) {
        this.checkForDatabase();
        this.resetResultSet();
        ORecordIteratorClass it = this.currentDatabase.browseClass(iClassName);
        this.browseRecords((OIdentifiableIterator<?>)it);
    }

    @ConsoleCommand(description="Browse all records of a cluster", onlineHelp="Console-Command-Browse-Cluster")
    public void browseCluster(@ConsoleParameter(name="cluster-name", description="The name of the cluster") String iClusterName) {
        this.checkForDatabase();
        this.resetResultSet();
        ORecordIteratorCluster it = this.currentDatabase.browseCluster(iClusterName);
        this.browseRecords((OIdentifiableIterator<?>)it);
    }

    @ConsoleCommand(aliases={"display"}, description="Display current record attributes", onlineHelp="Console-Command-Display-Record")
    public void displayRecord(@ConsoleParameter(name="number", description="The number of the record in the most recent result set") String iRecordNumber) {
        this.checkForDatabase();
        if (iRecordNumber == null || this.currentResultSet == null) {
            this.checkCurrentObject();
        } else {
            int recNumber = Integer.parseInt(iRecordNumber);
            if (this.currentResultSet.size() == 0) {
                throw new OSystemException("No result set where to find the requested record. Execute a query first.");
            }
            if (this.currentResultSet.size() <= recNumber) {
                String resultSize = this.currentResultSet.size() > 0 ? "-" + (this.currentResultSet.size() - 1) : "";
                throw new OSystemException("The record requested is not part of current result set (0" + resultSize + ")");
            }
            this.setCurrentRecord(recNumber);
        }
        this.dumpRecordDetails();
    }

    @ConsoleCommand(aliases={"status"}, description="Display information about the database", onlineHelp="Console-Command-Info")
    public void info() {
        if (this.currentDatabaseName != null) {
            this.message("\nCurrent database: " + this.currentDatabaseName + " (url=" + this.currentDatabase.getURL() + ")", new Object[0]);
            this.currentDatabase.getMetadata().reload();
            if (this.currentDatabase.isRemote()) {
                this.listServers();
            }
            this.listProperties();
            this.listClusters(null);
            this.listClasses();
            this.listIndexes();
        }
    }

    @ConsoleCommand(description="Display the database properties")
    public void listProperties() {
        if (this.currentDatabase == null) {
            return;
        }
        OStorageConfiguration dbCfg = this.currentDatabase.getStorageInfo().getConfiguration();
        this.message("\n\nDATABASE PROPERTIES", new Object[0]);
        if (dbCfg.getProperties() != null) {
            ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
            if (dbCfg.getName() != null) {
                resultSet.add(new ODocument().field("NAME", (Object)"Name").field("VALUE", (Object)dbCfg.getName()));
            }
            resultSet.add(new ODocument().field("NAME", (Object)"Version").field("VALUE", (Object)dbCfg.getVersion()));
            resultSet.add(new ODocument().field("NAME", (Object)"Conflict-Strategy").field("VALUE", (Object)dbCfg.getConflictStrategy()));
            resultSet.add(new ODocument().field("NAME", (Object)"Date-Format").field("VALUE", (Object)dbCfg.getDateFormat()));
            resultSet.add(new ODocument().field("NAME", (Object)"Datetime-Format").field("VALUE", (Object)dbCfg.getDateTimeFormat()));
            resultSet.add(new ODocument().field("NAME", (Object)"Timezone").field("VALUE", (Object)dbCfg.getTimeZone().getID()));
            resultSet.add(new ODocument().field("NAME", (Object)"Locale-Country").field("VALUE", (Object)dbCfg.getLocaleCountry()));
            resultSet.add(new ODocument().field("NAME", (Object)"Locale-Language").field("VALUE", (Object)dbCfg.getLocaleLanguage()));
            resultSet.add(new ODocument().field("NAME", (Object)"Charset").field("VALUE", (Object)dbCfg.getCharset()));
            resultSet.add(new ODocument().field("NAME", (Object)"Schema-RID").field("VALUE", (Object)dbCfg.getSchemaRecordId(), new OType[]{OType.LINK}));
            resultSet.add(new ODocument().field("NAME", (Object)"Index-Manager-RID").field("VALUE", (Object)dbCfg.getIndexMgrRecordId(), new OType[]{OType.LINK}));
            OTableFormatter formatter = new OTableFormatter(this);
            formatter.setMaxWidthSize(this.getConsoleWidth());
            formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
            formatter.writeRecords(resultSet, -1);
            this.message("\n", new Object[0]);
            if (!dbCfg.getProperties().isEmpty()) {
                this.message("\n\nDATABASE CUSTOM PROPERTIES:", new Object[0]);
                ArrayList<ODocument> dbResultSet = new ArrayList<ODocument>();
                for (OStorageEntryConfiguration cfg : dbCfg.getProperties()) {
                    dbResultSet.add(new ODocument().field("NAME", (Object)cfg.name).field("VALUE", (Object)cfg.value));
                }
                OTableFormatter dbFormatter = new OTableFormatter(this);
                formatter.setMaxWidthSize(this.getConsoleWidth());
                formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
                dbFormatter.writeRecords(dbResultSet, -1);
            }
        }
    }

    @ConsoleCommand(aliases={"desc"}, description="Display a class in the schema", onlineHelp="Console-Command-Info-Class")
    public void infoClass(@ConsoleParameter(name="class-name", description="The name of the class") String iClassName) {
        ODocument row;
        Set indexes;
        this.checkForDatabase();
        this.currentDatabase.getMetadata().reload();
        OClass cls = this.currentDatabase.getMetadata().getImmutableSchemaSnapshot().getClass(iClassName);
        if (cls == null) {
            this.message("\n! Class '" + iClassName + "' does not exist in the database '" + this.currentDatabaseName + "'", new Object[0]);
            return;
        }
        this.message("\nCLASS '" + cls.getName() + "'\n", new Object[0]);
        long count = this.currentDatabase.countClass(cls.getName(), false);
        this.message("\nRecords..............: " + count, new Object[0]);
        if (cls.getShortName() != null) {
            this.message("\nAlias................: " + cls.getShortName(), new Object[0]);
        }
        if (cls.hasSuperClasses()) {
            this.message("\nSuper classes........: " + Arrays.toString(cls.getSuperClassesNames().toArray()), new Object[0]);
        }
        this.message("\nDefault cluster......: " + this.currentDatabase.getClusterNameById(cls.getDefaultClusterId()) + " (id=" + cls.getDefaultClusterId() + ")", new Object[0]);
        StringBuilder clusters = new StringBuilder();
        for (int clId : cls.getClusterIds()) {
            if (clusters.length() > 0) {
                clusters.append(", ");
            }
            clusters.append(this.currentDatabase.getClusterNameById(clId));
            clusters.append("(");
            clusters.append(clId);
            clusters.append(")");
        }
        this.message("\nSupported clusters...: " + clusters.toString(), new Object[0]);
        this.message("\nCluster selection....: " + cls.getClusterSelection().getName(), new Object[0]);
        this.message("\nOversize.............: " + cls.getClassOverSize(), new Object[0]);
        if (!cls.getSubclasses().isEmpty()) {
            this.message("\nSubclasses.........: ", new Object[0]);
            int i = 0;
            for (OClass c : cls.getSubclasses()) {
                if (i > 0) {
                    this.message(", ", new Object[0]);
                }
                this.message(c.getName(), new Object[0]);
                ++i;
            }
            this.out.println();
        }
        if (cls.properties().size() > 0) {
            this.message("\n\nPROPERTIES", new Object[0]);
            ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
            for (OProperty p : cls.properties()) {
                try {
                    ODocument row2 = new ODocument();
                    resultSet.add(row2);
                    row2.field("NAME", (Object)p.getName());
                    row2.field("TYPE", (Object)p.getType());
                    row2.field("LINKED-TYPE/CLASS", p.getLinkedClass() != null ? p.getLinkedClass() : p.getLinkedType());
                    row2.field("MANDATORY", (Object)p.isMandatory());
                    row2.field("READONLY", (Object)p.isReadonly());
                    row2.field("NOT-NULL", (Object)p.isNotNull());
                    row2.field("MIN", (Object)(p.getMin() != null ? p.getMin() : ""));
                    row2.field("MAX", (Object)(p.getMax() != null ? p.getMax() : ""));
                    row2.field("COLLATE", (Object)(p.getCollate() != null ? p.getCollate().getName() : ""));
                    row2.field("DEFAULT", (Object)(p.getDefaultValue() != null ? p.getDefaultValue() : ""));
                }
                catch (Exception row2) {}
            }
            OTableFormatter formatter = new OTableFormatter(this);
            formatter.setMaxWidthSize(this.getConsoleWidth());
            formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
            formatter.writeRecords(resultSet, -1);
        }
        if (!(indexes = cls.getClassIndexes()).isEmpty()) {
            this.message("\n\nINDEXES (" + indexes.size() + " altogether)", new Object[0]);
            ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
            for (OIndex index : indexes) {
                row = new ODocument();
                resultSet.add(row);
                row.field("NAME", (Object)index.getName());
                OIndexDefinition indexDefinition = index.getDefinition();
                if (indexDefinition == null) continue;
                List fields = indexDefinition.getFields();
                row.field("PROPERTIES", (Object)fields);
            }
            OTableFormatter formatter = new OTableFormatter(this);
            formatter.setMaxWidthSize(this.getConsoleWidth());
            formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
            formatter.writeRecords(resultSet, -1);
        }
        if (cls.getCustomKeys().size() > 0) {
            this.message("\n\nCUSTOM ATTRIBUTES", new Object[0]);
            ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
            for (String k : cls.getCustomKeys()) {
                try {
                    row = new ODocument();
                    resultSet.add(row);
                    row.field("NAME", (Object)k);
                    row.field("VALUE", (Object)cls.getCustom(k));
                }
                catch (Exception exception) {}
            }
            OTableFormatter formatter = new OTableFormatter(this);
            formatter.setMaxWidthSize(this.getConsoleWidth());
            formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
            formatter.writeRecords(resultSet, -1);
        }
    }

    @ConsoleCommand(description="Display a class property", onlineHelp="Console-Command-Info-Property")
    public void infoProperty(@ConsoleParameter(name="property-name", description="The name of the property as <class>.<property>") String iPropertyName) {
        Collection indexes;
        this.checkForDatabase();
        if (iPropertyName.indexOf(46) == -1) {
            throw new OSystemException("Property name is in the format <class>.<property>");
        }
        String[] parts = iPropertyName.split("\\.");
        OClass cls = this.currentDatabase.getMetadata().getImmutableSchemaSnapshot().getClass(parts[0]);
        if (cls == null) {
            this.message("\n! Class '" + parts[0] + "' does not exist in the database '" + this.currentDatabaseName + "'", new Object[0]);
            return;
        }
        OProperty prop = cls.getProperty(parts[1]);
        if (prop == null) {
            this.message("\n! Property '" + parts[1] + "' does not exist in class '" + parts[0] + "'", new Object[0]);
            return;
        }
        this.message("\nPROPERTY '" + prop.getFullName() + "'\n", new Object[0]);
        this.message("\nType.................: " + prop.getType(), new Object[0]);
        this.message("\nMandatory............: " + prop.isMandatory(), new Object[0]);
        this.message("\nNot null.............: " + prop.isNotNull(), new Object[0]);
        this.message("\nRead only............: " + prop.isReadonly(), new Object[0]);
        this.message("\nDefault value........: " + prop.getDefaultValue(), new Object[0]);
        this.message("\nMinimum value........: " + prop.getMin(), new Object[0]);
        this.message("\nMaximum value........: " + prop.getMax(), new Object[0]);
        this.message("\nREGEXP...............: " + prop.getRegexp(), new Object[0]);
        this.message("\nCollate..............: " + prop.getCollate(), new Object[0]);
        this.message("\nLinked class.........: " + prop.getLinkedClass(), new Object[0]);
        this.message("\nLinked type..........: " + prop.getLinkedType(), new Object[0]);
        if (prop.getCustomKeys().size() > 0) {
            this.message("\n\nCUSTOM ATTRIBUTES", new Object[0]);
            ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
            for (Object k : prop.getCustomKeys()) {
                try {
                    ODocument row = new ODocument();
                    resultSet.add(row);
                    row.field("NAME", k);
                    row.field("VALUE", (Object)prop.getCustom((String)k));
                }
                catch (Exception row) {}
            }
            OTableFormatter formatter = new OTableFormatter(this);
            formatter.setMaxWidthSize(this.getConsoleWidth());
            formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
            formatter.writeRecords(resultSet, -1);
        }
        if (!(indexes = prop.getAllIndexes()).isEmpty()) {
            this.message("\n\nINDEXES (" + indexes.size() + " altogether)", new Object[0]);
            ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
            for (OIndex index : indexes) {
                ODocument row = new ODocument();
                resultSet.add(row);
                row.field("NAME", (Object)index.getName());
                OIndexDefinition indexDefinition = index.getDefinition();
                if (indexDefinition == null) continue;
                List fields = indexDefinition.getFields();
                row.field("PROPERTIES", (Object)fields);
            }
            OTableFormatter formatter = new OTableFormatter(this);
            formatter.setMaxWidthSize(this.getConsoleWidth());
            formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
            formatter.writeRecords(resultSet, -1);
        }
    }

    @ConsoleCommand(description="Display all indexes", aliases={"indexes"}, onlineHelp="Console-Command-List-Indexes")
    public void listIndexes() {
        if (this.currentDatabaseName != null) {
            this.message("\n\nINDEXES", new Object[0]);
            ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
            int totalIndexes = 0;
            long totalRecords = 0L;
            ArrayList indexes = new ArrayList(this.currentDatabase.getMetadata().getIndexManagerInternal().getIndexes(this.currentDatabase));
            indexes.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
            long totalIndexedRecords = 0L;
            for (OIndex index : indexes) {
                ODocument row = new ODocument();
                resultSet.add(row);
                long indexSize = index.getSize();
                totalIndexedRecords += indexSize;
                row.field("NAME", (Object)index.getName());
                row.field("TYPE", (Object)index.getType());
                row.field("RECORDS", (Object)indexSize);
                try {
                    OIndexDefinition indexDefinition = index.getDefinition();
                    long size = index.getInternal().size();
                    if (indexDefinition != null) {
                        row.field("CLASS", (Object)indexDefinition.getClassName());
                        row.field("COLLATE", (Object)indexDefinition.getCollate().getName());
                        List fields = indexDefinition.getFields();
                        StringBuilder buffer = new StringBuilder();
                        for (int i = 0; i < fields.size(); ++i) {
                            if (buffer.length() > 0) {
                                buffer.append(",");
                            }
                            buffer.append((String)fields.get(i));
                            buffer.append("(");
                            buffer.append(indexDefinition.getTypes()[i]);
                            buffer.append(")");
                        }
                        row.field("FIELDS", (Object)buffer.toString());
                    }
                    ++totalIndexes;
                    totalRecords += size;
                }
                catch (Exception exception) {}
            }
            OTableFormatter formatter = new OTableFormatter(this);
            formatter.setMaxWidthSize(this.getConsoleWidth());
            formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
            formatter.setColumnAlignment("RECORDS", OTableFormatter.ALIGNMENT.RIGHT);
            ODocument footer = new ODocument();
            footer.field("NAME", (Object)"TOTAL");
            footer.field("RECORDS", (Object)totalIndexedRecords);
            formatter.setFooter(footer);
            formatter.writeRecords(resultSet, -1);
        } else {
            this.message("\nNo database selected yet.", new Object[0]);
        }
    }

    @ConsoleCommand(description="Display all the configured clusters", aliases={"clusters"}, onlineHelp="Console-Command-List-Clusters")
    public void listClusters(@ConsoleParameter(name="[options]", optional=true, description="Additional options, example: -v=verbose") String options) {
        Map<String, String> commandOptions = this.parseCommandOptions(options);
        if (this.currentDatabaseName != null) {
            ODocument dDatabaseCfg;
            this.message("\n\nCLUSTERS (collections)", new Object[0]);
            ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
            long totalElements = 0L;
            long totalSpaceUsed = 0L;
            long totalTombstones = 0L;
            ArrayList clusters = new ArrayList(this.currentDatabase.getClusterNames());
            Collections.sort(clusters);
            ODocument dClusters = null;
            ODocument dCfg = this.getDistributedConfiguration();
            if (dCfg != null && (dDatabaseCfg = (ODocument)dCfg.field("database")) != null) {
                dClusters = (ODocument)dDatabaseCfg.field("clusters");
            }
            boolean isRemote = this.currentDatabase.isRemote();
            for (String clusterName : clusters) {
                try {
                    ODocument row = new ODocument();
                    resultSet.add(row);
                    int clusterId = this.currentDatabase.getClusterIdByName(clusterName);
                    String conflictStrategy = Optional.ofNullable(this.currentDatabase.getClusterRecordConflictStrategy(clusterId)).orElse("");
                    long count = this.currentDatabase.countClusterElements(clusterName);
                    totalElements += count;
                    OClass cls = this.currentDatabase.getMetadata().getSchema().getClassByClusterId(clusterId);
                    String className = Optional.ofNullable(cls).map(OClass::getName).orElse(null);
                    row.field("NAME", (Object)clusterName);
                    row.field("ID", (Object)clusterId);
                    row.field("CLASS", (Object)className);
                    if (!this.currentDatabase.isRemote()) {
                        row.field("CONFLICT-STRATEGY", (Object)conflictStrategy);
                    }
                    row.field("COUNT", (Object)count);
                    if (dClusters == null) continue;
                    ODocument dClusterCfg = (ODocument)dClusters.field(clusterName);
                    if (dClusterCfg == null) {
                        dClusterCfg = (ODocument)dClusters.field("*");
                    }
                    if (dClusterCfg == null) continue;
                    ArrayList servers = new ArrayList((Collection)dClusterCfg.field("servers"));
                    boolean newNode = servers.remove("<NEW_NODE>");
                    if (!servers.isEmpty()) {
                        row.field("OWNER_SERVER", servers.get(0));
                        if (servers.size() > 1) {
                            servers.remove(0);
                            row.field("OTHER_SERVERS", servers);
                        }
                    }
                    row.field("AUTO_DEPLOY_NEW_NODE", (Object)newNode);
                }
                catch (Exception e) {
                    if (!(e instanceof OIOException)) continue;
                    break;
                }
            }
            OTableFormatter formatter = new OTableFormatter(this);
            formatter.setMaxWidthSize(this.getConsoleWidth());
            formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
            formatter.setColumnAlignment("ID", OTableFormatter.ALIGNMENT.RIGHT);
            formatter.setColumnAlignment("COUNT", OTableFormatter.ALIGNMENT.RIGHT);
            formatter.setColumnAlignment("OWNER_SERVER", OTableFormatter.ALIGNMENT.CENTER);
            formatter.setColumnAlignment("OTHER_SERVERS", OTableFormatter.ALIGNMENT.CENTER);
            formatter.setColumnAlignment("AUTO_DEPLOY_NEW_NODE", OTableFormatter.ALIGNMENT.CENTER);
            if (!isRemote) {
                formatter.setColumnAlignment("SPACE-USED", OTableFormatter.ALIGNMENT.RIGHT);
                if (commandOptions.containsKey("-v")) {
                    formatter.setColumnAlignment("TOMBSTONES", OTableFormatter.ALIGNMENT.RIGHT);
                }
            }
            ODocument footer = new ODocument();
            footer.field("NAME", (Object)"TOTAL");
            footer.field("COUNT", (Object)totalElements);
            if (!isRemote) {
                footer.field("SPACE-USED", (Object)OFileUtils.getSizeAsString((long)totalSpaceUsed));
                if (commandOptions.containsKey("-v")) {
                    footer.field("TOMBSTONES", (Object)totalTombstones);
                }
            }
            formatter.setFooter(footer);
            formatter.writeRecords(resultSet, -1);
            this.message("\n", new Object[0]);
        } else {
            this.message("\nNo database selected yet.", new Object[0]);
        }
    }

    @ConsoleCommand(description="Display all the configured classes", aliases={"classes"}, onlineHelp="Console-Command-List-Classes")
    public void listClasses() {
        if (this.currentDatabaseName != null) {
            this.message("\n\nCLASSES", new Object[0]);
            ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
            long totalElements = 0L;
            this.currentDatabase.getMetadata().reload();
            ArrayList classes = new ArrayList(this.currentDatabase.getMetadata().getImmutableSchemaSnapshot().getClasses());
            Collections.sort(classes, new Comparator<OClass>(){

                @Override
                public int compare(OClass o1, OClass o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            for (OClass cls : classes) {
                try {
                    ODocument row = new ODocument();
                    resultSet.add(row);
                    StringBuilder clusters = new StringBuilder(1024);
                    if (cls.isAbstract()) {
                        clusters.append("-");
                    } else {
                        int[] clusterIds = cls.getClusterIds();
                        for (int i = 0; i < clusterIds.length; ++i) {
                            if (i > 0) {
                                clusters.append(",");
                            }
                            clusters.append(this.currentDatabase.getClusterNameById(clusterIds[i]));
                            clusters.append("(");
                            clusters.append(clusterIds[i]);
                            clusters.append(")");
                        }
                    }
                    long count = this.currentDatabase.countClass(cls.getName(), false);
                    totalElements += count;
                    String superClasses = cls.hasSuperClasses() ? Arrays.toString(cls.getSuperClassesNames().toArray()) : "";
                    row.field("NAME", (Object)cls.getName());
                    row.field("SUPER-CLASSES", (Object)superClasses);
                    row.field("CLUSTERS", (Object)clusters);
                    row.field("COUNT", (Object)count);
                }
                catch (Exception exception) {}
            }
            OTableFormatter formatter = new OTableFormatter(this);
            formatter.setMaxWidthSize(this.getConsoleWidth());
            formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
            formatter.setColumnAlignment("COUNT", OTableFormatter.ALIGNMENT.RIGHT);
            ODocument footer = new ODocument();
            footer.field("NAME", (Object)"TOTAL");
            footer.field("COUNT", (Object)totalElements);
            formatter.setFooter(footer);
            formatter.writeRecords(resultSet, -1);
            this.message("\n", new Object[0]);
        } else {
            this.message("\nNo database selected yet.", new Object[0]);
        }
    }

    @ConsoleCommand(description="Display all the connected servers that manage current database", onlineHelp="Console-Command-List-Servers")
    public void listServers() {
        ODocument distribCfg = this.getDistributedConfiguration();
        if (distribCfg == null) {
            this.message("\n\nDistributed configuration is not active, cannot retrieve server list", new Object[0]);
            return;
        }
        ArrayList<OIdentifiable> servers = new ArrayList<OIdentifiable>();
        Collection members = (Collection)distribCfg.field("members");
        if (members != null) {
            this.message("\n\nCONFIGURED SERVERS", new Object[0]);
            for (ODocument m : members) {
                ODocument server = new ODocument();
                server.field("Name", m.field("name"));
                server.field("Status", m.field("status"));
                server.field("Connections", m.field("connections"));
                server.field("StartedOn", m.field("startedOn"));
                Collection listeners = (Collection)m.field("listeners");
                if (listeners != null) {
                    for (Map l : listeners) {
                        String protocol = (String)l.get("protocol");
                        if (protocol.equals("ONetworkProtocolBinary")) {
                            server.field("Binary", l.get("listen"));
                            continue;
                        }
                        if (!protocol.equals("ONetworkProtocolHttpDb")) continue;
                        server.field("HTTP", l.get("listen"));
                    }
                }
                long usedMem = (Long)m.field("usedMemory");
                long freeMem = (Long)m.field("freeMemory");
                long maxMem = (Long)m.field("maxMemory");
                server.field("UsedMemory", (Object)String.format("%s (%.2f%%)", OFileUtils.getSizeAsString((long)usedMem), Float.valueOf((float)usedMem / (float)maxMem * 100.0f)));
                server.field("FreeMemory", (Object)String.format("%s (%.2f%%)", OFileUtils.getSizeAsString((long)freeMem), Float.valueOf((float)freeMem / (float)maxMem * 100.0f)));
                server.field("MaxMemory", (Object)OFileUtils.getSizeAsString((long)maxMem));
                servers.add((OIdentifiable)server);
            }
        }
        this.currentResultSet = servers;
        new OTableFormatter(this).setMaxWidthSize(this.getConsoleWidth()).writeRecords(servers, -1);
    }

    @ConsoleCommand(description="Loook up a record using the dictionary. If found, set it as the current record", onlineHelp="Console-Command-Dictionary-Get")
    public void dictionaryGet(@ConsoleParameter(name="key", description="The key to search") String iKey) {
        this.checkForDatabase();
        this.currentRecord = (ORecord)this.currentDatabase.getDictionary().get(iKey);
        if (this.currentRecord == null) {
            this.message("\nEntry not found in dictionary.", new Object[0]);
        } else {
            this.currentRecord = this.currentRecord.load();
            this.displayRecord(null);
        }
    }

    @ConsoleCommand(description="Insert or modify an entry in the database dictionary. The entry is comprised of key=String, value=record-id", onlineHelp="Console-Command-Dictionary-Put")
    public void dictionaryPut(@ConsoleParameter(name="key", description="The key to bind") String iKey, @ConsoleParameter(name="record-id", description="The record-id of the record to bind to the key") String iRecordId) {
        this.checkForDatabase();
        this.currentRecord = (ORecord)this.currentDatabase.load((ORID)new ORecordId(iRecordId));
        if (this.currentRecord == null) {
            this.message("\nError: record with id '" + iRecordId + "' was not found in database", new Object[0]);
        } else {
            this.currentDatabase.getDictionary().put(iKey, (Object)this.currentRecord);
            this.displayRecord(null);
            this.message("\nThe entry " + iKey + "=" + iRecordId + " has been inserted in the database dictionary", new Object[0]);
        }
    }

    @ConsoleCommand(description="Remove the association in the dictionary", onlineHelp="Console-Command-Dictionary-Remove")
    public void dictionaryRemove(@ConsoleParameter(name="key", description="The key to remove") String iKey) {
        this.checkForDatabase();
        boolean result = this.currentDatabase.getDictionary().remove(iKey);
        if (!result) {
            this.message("\nEntry not found in dictionary.", new Object[0]);
        } else {
            this.message("\nEntry removed from the dictionary.", new Object[0]);
        }
    }

    @ConsoleCommand(description="Displays the status of the cluster nodes")
    public void clusterStatus() throws IOException {
        this.checkForRemoteServer();
        try {
            this.message("\nCluster status:", new Object[0]);
            ODocument clusterStatus = ((OrientDBRemote)OrientDBInternal.extract((OrientDB)this.orientDB)).getClusterStatus(this.currentDatabaseUserName, this.currentDatabaseUserPassword);
            this.out.println(clusterStatus.toJSON("attribSameRow,alwaysFetchEmbedded,fetchPlan:*:0"));
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Check database integrity", splitInWords=false)
    public void checkDatabase(@ConsoleParameter(name="options", description="Options: -v", optional=true) String iOptions) throws IOException {
        this.checkForDatabase();
        if (this.currentDatabase.getStorage().isRemote()) {
            this.message("\nCannot check integrity of non-local database. Connect to it using local mode.", new Object[0]);
            return;
        }
        boolean verbose = iOptions != null && iOptions.contains("-v");
        this.message("\nChecking storage.", new Object[0]);
        try {
            ((OAbstractPaginatedStorage)this.currentDatabase.getStorage()).check(verbose, (OCommandOutputListener)this);
        }
        catch (ODatabaseImportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Repair database structure", splitInWords=false)
    public void repairDatabase(@ConsoleParameter(name="options", description="Options: [--fix-graph] [--force-embedded-ridbags] [--fix-links] [-v]] [--fix-ridbags] [--fix-bonsai]", optional=true) String iOptions) throws IOException {
        boolean fix_bonsai;
        boolean fix_links;
        boolean fix_graph;
        this.checkForDatabase();
        boolean force_embedded = iOptions == null || iOptions.contains("--force-embedded-ridbags");
        boolean bl = fix_graph = iOptions == null || iOptions.contains("--fix-graph");
        if (force_embedded) {
            OGlobalConfiguration.RID_BAG_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD.setValue((Object)Integer.MAX_VALUE);
            OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.setValue((Object)Integer.MAX_VALUE);
        }
        if (fix_graph || force_embedded) {
            Map<String, List<String>> options = this.parseOptions(iOptions);
            new OGraphRepair().repair((ODatabaseSession)this.currentDatabase, (OCommandOutputListener)this, options);
        }
        boolean bl2 = fix_links = iOptions == null || iOptions.contains("--fix-links");
        if (fix_links) {
            boolean verbose = iOptions != null && iOptions.contains("-v");
            new ODatabaseRepair().setDatabase(this.currentDatabase).setOutputListener(new OCommandOutputListener(){

                public void onMessage(String iText) {
                    OConsoleDatabaseApp.this.message(iText, new Object[0]);
                }
            }).setVerbose(verbose).run();
        }
        if (!this.currentDatabase.getURL().startsWith("plocal")) {
            this.message("\n fix-bonsai can be run only on plocal connection \n", new Object[0]);
            return;
        }
        boolean fix_ridbags = iOptions == null || iOptions.contains("--fix-ridbags");
        boolean bl3 = fix_bonsai = iOptions == null || iOptions.contains("--fix-bonsai");
        if (fix_ridbags || fix_bonsai || force_embedded) {
            OBonsaiTreeRepair repairer = new OBonsaiTreeRepair();
            repairer.repairDatabaseRidbags((ODatabaseDocument)this.currentDatabase, (OCommandOutputListener)this);
        }
    }

    @ConsoleCommand(description="Compare two databases")
    public void compareDatabases(@ConsoleParameter(name="db1-url", description="URL of the first database") String iDb1URL, @ConsoleParameter(name="db2-url", description="URL of the second database") String iDb2URL, @ConsoleParameter(name="username", description="User name", optional=false) String iUserName, @ConsoleParameter(name="password", description="User password", optional=false) String iUserPassword, @ConsoleParameter(name="detect-mapping-data", description="Whether RID mapping data after DB import should be tried to found on the disk", optional=true) String autoDiscoveringMappingData) throws IOException {
        try {
            ODatabaseCompare compare = new ODatabaseCompare(iDb1URL, iDb2URL, iUserName, iUserPassword, (OCommandOutputListener)this);
            compare.setAutoDetectExportImportMap(autoDiscoveringMappingData != null ? Boolean.valueOf(autoDiscoveringMappingData) : true);
            compare.setCompareIndexMetadata(true);
            compare.compare();
        }
        catch (ODatabaseExportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Load a sql script into the current database", splitInWords=true, onlineHelp="Console-Command-Load-Script")
    public void loadScript(@ConsoleParameter(name="scripPath", description="load script scriptPath") String scriptPath) throws IOException {
        this.checkForDatabase();
        this.message("\nLoading script " + scriptPath + "...", new Object[0]);
        this.executeBatch(scriptPath);
        this.message("\nLoaded script " + scriptPath, new Object[0]);
    }

    @ConsoleCommand(description="Import a database into the current one", splitInWords=false, onlineHelp="Console-Command-Import")
    public void importDatabase(@ConsoleParameter(name="options", description="Import options") String text) throws IOException {
        this.checkForDatabase();
        this.message("\nImporting database " + text + "...", new Object[0]);
        List items = OStringSerializerHelper.smartSplit((String)text, (char)' ', (char[])new char[0]);
        String fileName = items.size() <= 0 || ((String)items.get(1)).charAt(0) == '-' ? null : (String)items.get(1);
        String options = fileName != null ? text.substring(((String)items.get(0)).length() + ((String)items.get(1)).length() + 1).trim() : text;
        try {
            if (this.currentDatabase.isRemote()) {
                ODatabaseImportRemote databaseImport = new ODatabaseImportRemote(this.currentDatabase, fileName, (OCommandOutputListener)this);
                databaseImport.setOptions(options);
                databaseImport.importDatabase();
                databaseImport.close();
            } else {
                ODatabaseImport databaseImport = new ODatabaseImport(this.currentDatabase, fileName, (OCommandOutputListener)this);
                databaseImport.setOptions(options);
                databaseImport.importDatabase();
                databaseImport.close();
            }
        }
        catch (ODatabaseImportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Backup a database", splitInWords=false, onlineHelp="Console-Command-Backup")
    public void backupDatabase(@ConsoleParameter(name="options", description="Backup options") String iText) throws IOException {
        block17: {
            String fileName;
            this.checkForDatabase();
            List items = OStringSerializerHelper.smartSplit((String)iText, (char)' ', (char[])new char[]{' '});
            if (items.size() < 2) {
                try {
                    this.syntaxError("backupDatabase", this.getClass().getMethod("backupDatabase", String.class));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return;
            }
            String string = fileName = items.size() <= 0 || ((String)items.get(1)).charAt(0) == '-' ? null : (String)items.get(1);
            if (fileName == null || fileName.trim().isEmpty()) {
                try {
                    this.syntaxError("backupDatabase", this.getClass().getMethod("backupDatabase", String.class));
                    return;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            int bufferSize = Integer.parseInt((String)this.properties.get("backupBufferSize"));
            int compressionLevel = Integer.parseInt((String)this.properties.get("backupCompressionLevel"));
            boolean incremental = false;
            for (int i = 2; i < items.size(); ++i) {
                String parValue;
                String parName;
                String item = (String)items.get(i);
                int sep = item.indexOf(61);
                if (sep > -1) {
                    parName = item.substring(1, sep);
                    parValue = item.substring(sep + 1);
                } else {
                    parName = item.substring(1);
                    parValue = null;
                }
                if (parName.equalsIgnoreCase("incremental")) {
                    incremental = true;
                    continue;
                }
                if (parName.equalsIgnoreCase("bufferSize")) {
                    bufferSize = Integer.parseInt(parValue);
                    continue;
                }
                if (!parName.equalsIgnoreCase("compressionLevel")) continue;
                compressionLevel = Integer.parseInt(parValue);
            }
            long startTime = System.currentTimeMillis();
            String fName = null;
            try {
                if (incremental) {
                    this.out.println(new StringBuilder("Executing incremental backup of database '" + this.currentDatabaseName + "' to: ").append(iText).append("..."));
                    fName = this.currentDatabase.incrementalBackup(fileName);
                    this.message("\nIncremental Backup executed in %.2f seconds stored in file %s", new Object[]{Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f), fName});
                    break block17;
                }
                this.out.println(new StringBuilder("Executing full backup of database '" + this.currentDatabaseName + "' to: ").append(iText).append("..."));
                FileOutputStream fos = new FileOutputStream(fileName);
                try {
                    this.currentDatabase.backup((OutputStream)fos, null, null, (OCommandOutputListener)this, compressionLevel, bufferSize);
                    fos.flush();
                    fos.close();
                    this.message("\nBackup executed in %.2f seconds", new Object[]{Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f)});
                }
                catch (Exception e) {
                    fos.close();
                    File f = new File(fileName);
                    if (f.exists()) {
                        f.delete();
                    }
                    throw e;
                }
            }
            catch (ODatabaseExportException e) {
                this.printError((Exception)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConsoleCommand(description="Restore a database into the current one", splitInWords=false, onlineHelp="Console-Command-Restore")
    public void restoreDatabase(@ConsoleParameter(name="options", description="Restore options") String text) throws IOException {
        this.checkForDatabase();
        List items = OStringSerializerHelper.smartSplit((String)text, (char)' ', (char[])new char[0]);
        if (items.size() < 2) {
            try {
                this.syntaxError("restoreDatabase", this.getClass().getMethod("restoreDatabase", String.class));
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        String fileName = items.size() <= 0 || ((String)items.get(1)).charAt(0) == '-' ? null : (String)items.get(1);
        long startTime = System.currentTimeMillis();
        try {
            this.message("\nRestoring database '%s' from full backup...", new Object[]{text});
            try (FileInputStream f = new FileInputStream(fileName);){
                this.currentDatabase.restore((InputStream)f, null, null, (OCommandOutputListener)this);
            }
        }
        catch (ODatabaseImportException e) {
            try {
                this.printError((Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.message("\nDatabase restored in %.2f seconds", new Object[]{Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f)});
                throw throwable;
            }
            this.message("\nDatabase restored in %.2f seconds", new Object[]{Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f)});
        }
        this.message("\nDatabase restored in %.2f seconds", new Object[]{Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f)});
    }

    @ConsoleCommand(description="Export a database", splitInWords=false, onlineHelp="Console-Command-Export")
    public void exportDatabase(@ConsoleParameter(name="options", description="Export options") String iText) throws IOException {
        this.checkForDatabase();
        this.out.println(new StringBuilder("Exporting current database to: ").append(iText).append(" in GZipped JSON format ..."));
        List items = OStringSerializerHelper.smartSplit((String)iText, (char)' ', (char[])new char[0]);
        String fileName = items.size() <= 1 || ((String)items.get(1)).charAt(0) == '-' ? null : (String)items.get(1);
        String options = fileName != null ? iText.substring(((String)items.get(0)).length() + ((String)items.get(1)).length() + 1).trim() : iText;
        try {
            new ODatabaseExport(this.currentDatabase, fileName, (OCommandOutputListener)this).setOptions(options).exportDatabase().close();
        }
        catch (ODatabaseExportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Export a database schema")
    public void exportSchema(@ConsoleParameter(name="output-file", description="Output file path") String iOutputFilePath) throws IOException {
        this.checkForDatabase();
        this.message("\nExporting current database to: " + iOutputFilePath + "...", new Object[0]);
        try {
            ODatabaseExport exporter = new ODatabaseExport(this.currentDatabase, iOutputFilePath, (OCommandOutputListener)this);
            exporter.setIncludeRecords(false);
            exporter.exportDatabase().close();
        }
        catch (ODatabaseExportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Export the current record in the requested format", onlineHelp="Console-Command-Export-Record")
    public void exportRecord(@ConsoleParameter(name="format", description="Format, such as 'json'") String iFormat, @ConsoleParameter(name="options", description="Options", optional=true) String iOptions) throws IOException {
        this.checkForDatabase();
        this.checkCurrentObject();
        ORecordSerializer serializer = ORecordSerializerFactory.instance().getFormat(iFormat.toLowerCase(Locale.ENGLISH));
        if (serializer == null) {
            this.message("\nERROR: Format '" + iFormat + "' was not found.", new Object[0]);
            this.printSupportedSerializerFormat();
            return;
        }
        if (!(serializer instanceof ORecordSerializerStringAbstract)) {
            this.message("\nERROR: Format '" + iFormat + "' does not export as text.", new Object[0]);
            this.printSupportedSerializerFormat();
            return;
        }
        if (iOptions == null || iOptions.length() <= 0) {
            iOptions = "rid,version,class,type,keepTypes,alwaysFetchEmbedded,fetchPlan:*:0,prettyPrint";
        }
        try {
            this.out.println(this.currentRecord.toJSON(iOptions));
        }
        catch (ODatabaseExportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Return all configured properties")
    public void properties() {
        this.message("\nPROPERTIES:", new Object[0]);
        ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
        for (Map.Entry p : this.properties.entrySet()) {
            ODocument row = new ODocument();
            resultSet.add(row);
            row.field("NAME", p.getKey());
            row.field("VALUE", p.getValue());
        }
        OTableFormatter formatter = new OTableFormatter(this);
        formatter.setMaxWidthSize(this.getConsoleWidth());
        formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
        formatter.writeRecords(resultSet, -1);
        this.message("\n", new Object[0]);
    }

    @ConsoleCommand(description="Return the value of a property")
    public void get(@ConsoleParameter(name="property-name", description="Name of the property") String iPropertyName) {
        Object value = this.properties.get(iPropertyName);
        this.out.println();
        if (value == null) {
            this.message("\nProperty '" + iPropertyName + "' is not setted", new Object[0]);
        } else {
            this.out.println(iPropertyName + " = " + value);
        }
    }

    @ConsoleCommand(description="Change the value of a property", onlineHelp="Console-Command-Set")
    public void set(@ConsoleParameter(name="property-name", description="Name of the property") String iPropertyName, @ConsoleParameter(name="property-value", description="Value to set") String iPropertyValue) {
        Object prevValue = this.properties.get(iPropertyName);
        this.out.println();
        if (iPropertyName.equalsIgnoreCase("limit") && (Integer.parseInt(iPropertyValue) == 0 || Integer.parseInt(iPropertyValue) < -1)) {
            this.message("\nERROR: Limit must be > 0 or = -1 (no limit)", new Object[0]);
        } else {
            if (prevValue != null) {
                this.message("\nPrevious value was: " + prevValue, new Object[0]);
            }
            this.properties.put(iPropertyName, iPropertyValue);
            this.out.println();
            this.out.println(iPropertyName + " = " + iPropertyValue);
        }
    }

    @ConsoleCommand(description="Declare an intent", onlineHelp="")
    public void declareIntent(@ConsoleParameter(name="Intent name", description="name of the intent to execute") String iIntentName) {
        this.checkForDatabase();
        this.message("\nDeclaring intent '" + iIntentName + "'...", new Object[0]);
        if (iIntentName.equalsIgnoreCase("massiveinsert")) {
            this.currentDatabase.declareIntent((OIntent)new OIntentMassiveInsert());
        } else if (iIntentName.equalsIgnoreCase("massiveread")) {
            this.currentDatabase.declareIntent((OIntent)new OIntentMassiveRead());
        } else if (iIntentName.equalsIgnoreCase("null")) {
            this.currentDatabase.declareIntent(null);
        } else {
            throw new IllegalArgumentException("Intent '" + iIntentName + "' not supported. Available ones are: massiveinsert, massiveread, null");
        }
        this.message("\nIntent '" + iIntentName + "' set successfully", new Object[0]);
    }

    @ConsoleCommand(description="Execute a command against the profiler")
    public void profiler(@ConsoleParameter(name="profiler command", description="command to execute against the profiler") String iCommandName) {
        if (iCommandName.equalsIgnoreCase("on")) {
            Orient.instance().getProfiler().startRecording();
            this.message("\nProfiler is ON now, use 'profiler off' to turn off.", new Object[0]);
        } else if (iCommandName.equalsIgnoreCase("off")) {
            Orient.instance().getProfiler().stopRecording();
            this.message("\nProfiler is OFF now, use 'profiler on' to turn on.", new Object[0]);
        } else if (iCommandName.equalsIgnoreCase("dump")) {
            this.out.println(Orient.instance().getProfiler().dump());
        }
    }

    @ConsoleCommand(description="Return the value of a configuration value")
    public void configGet(@ConsoleParameter(name="config-name", description="Name of the configuration") String iConfigName) throws IOException {
        String value;
        OGlobalConfiguration config = OGlobalConfiguration.findByKey((String)iConfigName);
        if (config == null) {
            throw new IllegalArgumentException("Configuration variable '" + iConfigName + "' wasn't found");
        }
        if (!OrientDBInternal.extract((OrientDB)this.orientDB).isEmbedded()) {
            value = ((OrientDBRemote)OrientDBInternal.extract((OrientDB)this.orientDB)).getGlobalConfiguration(this.currentDatabaseUserName, this.currentDatabaseUserPassword, config);
            this.message("\nRemote configuration: ", new Object[0]);
        } else {
            value = config.getValueAsString();
            this.message("\nLocal configuration: ", new Object[0]);
        }
        this.out.println(iConfigName + " = " + value);
    }

    @ConsoleCommand(description="Sleep X milliseconds")
    public void sleep(String iTime) {
        try {
            Thread.sleep(Long.parseLong(iTime));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @ConsoleCommand(description="Change the value of a configuration value")
    public void configSet(@ConsoleParameter(name="config-name", description="Name of the configuration") String iConfigName, @ConsoleParameter(name="config-value", description="Value to set") String iConfigValue) throws IOException {
        OGlobalConfiguration config = OGlobalConfiguration.findByKey((String)iConfigName);
        if (config == null) {
            throw new IllegalArgumentException("Configuration variable '" + iConfigName + "' not found");
        }
        if (this.orientDB != null && !OrientDBInternal.extract((OrientDB)this.orientDB).isEmbedded()) {
            ((OrientDBRemote)OrientDBInternal.extract((OrientDB)this.orientDB)).setGlobalConfiguration(this.currentDatabaseUserName, this.currentDatabaseUserPassword, config, iConfigValue);
            this.message("\nRemote configuration value changed correctly", new Object[0]);
        } else {
            config.setValue((Object)iConfigValue);
            this.message("\nLocal configuration value changed correctly", new Object[0]);
        }
        this.out.println();
    }

    @ConsoleCommand(description="Return all the configuration values")
    public void config() throws IOException {
        if (!OrientDBInternal.extract((OrientDB)this.orientDB).isEmbedded()) {
            Map values = ((OrientDBRemote)OrientDBInternal.extract((OrientDB)this.orientDB)).getGlobalConfigurations(this.currentDatabaseUserName, this.currentDatabaseUserPassword);
            this.message("\nREMOTE SERVER CONFIGURATION", new Object[0]);
            ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
            for (Map.Entry p : values.entrySet()) {
                ODocument row = new ODocument();
                resultSet.add(row);
                row.field("NAME", p.getKey());
                row.field("VALUE", p.getValue());
            }
            OTableFormatter formatter = new OTableFormatter(this);
            formatter.setMaxWidthSize(this.getConsoleWidth());
            formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
            formatter.writeRecords(resultSet, -1);
        } else {
            this.message("\nLOCAL SERVER CONFIGURATION", new Object[0]);
            ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
            for (OGlobalConfiguration cfg : OGlobalConfiguration.values()) {
                ODocument row = new ODocument();
                resultSet.add(row);
                row.field("NAME", (Object)cfg.getKey());
                row.field("VALUE", cfg.getValue());
            }
            OTableFormatter formatter = new OTableFormatter(this);
            formatter.setMaxWidthSize(this.getConsoleWidth());
            formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
            formatter.writeRecords(resultSet, -1);
        }
        this.message("\n", new Object[0]);
    }

    public ODatabaseDocument getCurrentDatabase() {
        return this.currentDatabase;
    }

    public OConsoleDatabaseApp setCurrentDatabase(ODatabaseDocumentInternal iCurrentDatabase) {
        this.currentDatabase = iCurrentDatabase;
        this.currentDatabaseName = iCurrentDatabase.getName();
        return this;
    }

    public String getCurrentDatabaseName() {
        return this.currentDatabaseName;
    }

    public String getCurrentDatabaseUserName() {
        return this.currentDatabaseUserName;
    }

    public String getCurrentDatabaseUserPassword() {
        return this.currentDatabaseUserPassword;
    }

    public ORecord getCurrentRecord() {
        return this.currentRecord;
    }

    public List<OIdentifiable> getCurrentResultSet() {
        return this.currentResultSet;
    }

    public void loadRecordInternal(String iRecordId, String iFetchPlan) {
        this.checkForDatabase();
        this.currentRecord = (ORecord)this.currentDatabase.load((ORID)new ORecordId(iRecordId), iFetchPlan);
        this.displayRecord(null);
        this.message("\nOK", new Object[0]);
    }

    public void reloadRecordInternal(String iRecordId, String iFetchPlan) {
        this.checkForDatabase();
        this.currentRecord = this.currentDatabase.executeReadRecord(new ORecordId(iRecordId), null, -1, iFetchPlan, true, false, false, OStorage.LOCKING_STRATEGY.NONE, (RecordReader)new SimpleRecordReader(false));
        this.displayRecord(null);
        this.message("\nOK", new Object[0]);
    }

    @ConsoleCommand(description="Open a database", onlineHelp="Console-Command-Use")
    public void open(@ConsoleParameter(name="db-name", description="The database name") String dbName, @ConsoleParameter(name="user", description="The database user") String user, @ConsoleParameter(name="password", description="The database password") String password) {
        if (this.orientDB == null) {
            this.message("Invalid context. Please use 'connect env' first", new Object[0]);
            return;
        }
        this.currentDatabase = (ODatabaseDocumentInternal)this.orientDB.open(dbName, user, password);
        this.currentDatabaseName = this.currentDatabase.getName();
        this.message("OK", new Object[0]);
        ODocument distribCfg = this.getDistributedConfiguration();
        if (distribCfg != null) {
            this.listServers();
        }
    }

    protected OConsoleApplication.RESULT executeServerCommand(String iCommand) {
        if (super.executeServerCommand(iCommand) == OConsoleApplication.RESULT.NOT_EXECUTED) {
            if ((iCommand = iCommand.trim()).toLowerCase().startsWith("connect ")) {
                if (iCommand.substring("connect ".length()).trim().toLowerCase().startsWith("env ")) {
                    return this.connectEnv(iCommand);
                }
                return OConsoleApplication.RESULT.NOT_EXECUTED;
            }
            if (this.orientDB != null) {
                int displayLimit = 20;
                try {
                    if (this.properties.get("limit") != null) {
                        displayLimit = Integer.parseInt((String)this.properties.get("limit"));
                    }
                    OResultSet rs = this.orientDB.execute(iCommand, new Object[0]);
                    int count = 0;
                    ArrayList<OIdentifiable> result = new ArrayList<OIdentifiable>();
                    while (rs.hasNext() && (displayLimit < 0 || count < displayLimit)) {
                        OResult item = rs.next();
                        if (item.isBlob()) {
                            result.add((OIdentifiable)item.getBlob().get());
                            continue;
                        }
                        result.add((OIdentifiable)item.toElement());
                    }
                    this.setResultset(result);
                    this.dumpResultSet(displayLimit);
                    return OConsoleApplication.RESULT.OK;
                }
                catch (OCommandExecutionException e) {
                    this.printError((Exception)((Object)e));
                    return OConsoleApplication.RESULT.ERROR;
                }
                catch (Exception e) {
                    if (e.getCause() instanceof OCommandExecutionException) {
                        this.printError(e);
                        return OConsoleApplication.RESULT.ERROR;
                    }
                    return OConsoleApplication.RESULT.NOT_EXECUTED;
                }
            }
        }
        return OConsoleApplication.RESULT.NOT_EXECUTED;
    }

    private OConsoleApplication.RESULT connectEnv(String iCommand) {
        String[] p = iCommand.split(" ");
        List parts = Arrays.stream(p).filter(x -> x.length() > 0).collect(Collectors.toList());
        if (parts.size() < 3) {
            this.error("\n!Invalid syntax: '%s'", new Object[]{iCommand});
            return OConsoleApplication.RESULT.ERROR;
        }
        String url = (String)parts.get(2);
        String user = null;
        String pw = null;
        if (parts.size() > 4) {
            user = (String)parts.get(3);
            pw = (String)parts.get(4);
        }
        this.orientDB = new OrientDB(url, user, pw, OrientDBConfig.defaultConfig());
        return OConsoleApplication.RESULT.OK;
    }

    protected void checkForRemoteServer() {
        if (this.orientDB == null || OrientDBInternal.extract((OrientDB)this.orientDB).isEmbedded()) {
            throw new OSystemException("Remote server is not connected. Use 'connect remote:<host>[:<port>][/<database-name>]' to connect");
        }
    }

    protected void checkForDatabase() {
        if (this.currentDatabase == null) {
            throw new OSystemException("Database not selected. Use 'connect <url> <user> <password>' to connect to a database.");
        }
        if (this.currentDatabase.isClosed()) {
            throw new ODatabaseException("Database '" + this.currentDatabaseName + "' is closed");
        }
    }

    protected void checkCurrentObject() {
        if (this.currentRecord == null) {
            throw new OSystemException("The is no current object selected: create a new one or load it");
        }
    }

    public String ask(String iText) {
        this.out.print(iText);
        Scanner scanner = new Scanner(this.in);
        String answer = scanner.nextLine();
        scanner.close();
        return answer;
    }

    public void onMessage(String iText) {
        this.message(iText, new Object[0]);
    }

    public void onBegin(Object iTask, long iTotal, Object metadata) {
        this.lastPercentStep = 0;
        this.message("[", new Object[0]);
        if (this.interactiveMode) {
            for (int i = 0; i < 10; ++i) {
                this.message(" ", new Object[0]);
            }
            this.message("]   0%", new Object[0]);
        }
    }

    public boolean onProgress(Object iTask, long iCounter, float iPercent) {
        int completitionBar = (int)iPercent / 10;
        if ((int)(iPercent * 10.0f) == this.lastPercentStep) {
            return true;
        }
        StringBuilder buffer = new StringBuilder(64);
        if (this.interactiveMode) {
            int i;
            buffer.append("\r[");
            for (i = 0; i < completitionBar; ++i) {
                buffer.append('=');
            }
            for (i = completitionBar; i < 10; ++i) {
                buffer.append(' ');
            }
            this.message("] %3.1f%% ", new Object[]{Float.valueOf(iPercent)});
        } else {
            for (int i = this.lastPercentStep / 100; i < completitionBar; ++i) {
                buffer.append('=');
            }
        }
        this.message(buffer.toString(), new Object[0]);
        this.lastPercentStep = (int)(iPercent * 10.0f);
        return true;
    }

    @ConsoleCommand(description="Display the current path")
    public void pwd() {
        this.message("\nCurrent path: " + new File("").getAbsolutePath(), new Object[0]);
    }

    public void onCompletition(Object iTask, boolean iSucceed) {
        if (this.interactiveMode) {
            if (iSucceed) {
                this.message("\r[==========] 100% Done.", new Object[0]);
            } else {
                this.message(" Error!", new Object[0]);
            }
        } else {
            this.message(iSucceed ? "] Done." : " Error!", new Object[0]);
        }
    }

    public void close() {
        if (this.currentDatabase != null) {
            this.currentDatabase.activateOnCurrentThread();
            this.currentDatabase.close();
            this.currentDatabase = null;
        }
        if (this.orientDB != null) {
            this.orientDB.close();
        }
        this.currentResultSet = null;
        this.currentRecord = null;
        this.currentResult = null;
        this.commandBuffer.setLength(0);
    }

    protected void dumpDistributedConfiguration(boolean iForce) {
        if (this.currentDatabase == null) {
            return;
        }
        if (this.currentDatabase.isRemote()) {
            OStorageRemote stg = ((ODatabaseDocumentRemote)this.currentDatabase).getStorageRemote();
            ODocument distributedCfg = stg.getClusterConfiguration();
            if (distributedCfg != null && !distributedCfg.isEmpty()) {
                this.message("\n\nDISTRIBUTED CONFIGURATION:\n" + distributedCfg.toJSON("prettyPrint"), new Object[0]);
            } else if (iForce) {
                this.message("\n\nDISTRIBUTED CONFIGURATION: none (OrientDB is running in standalone mode)", new Object[0]);
            }
        }
    }

    protected ODocument getDistributedConfiguration() {
        OStorage stg;
        if (this.currentDatabase != null && (stg = this.currentDatabase.getStorage()) instanceof OStorageRemote) {
            return ((OStorageRemote)stg).getClusterConfiguration();
        }
        return null;
    }

    protected boolean isCollectingCommands(String iLine) {
        return iLine.startsWith("js") || iLine.startsWith("script");
    }

    @Override
    protected void onBefore() {
        super.onBefore();
        this.setResultset(new ArrayList<OIdentifiable>());
        this.properties.put("limit", "20");
        this.properties.put("debug", "false");
        this.properties.put("collectionMaxItems", "10");
        this.properties.put("maxBinaryDisplay", "150");
        this.properties.put("verbose", "2");
        this.properties.put("ignoreErrors", "false");
        this.properties.put("backupCompressionLevel", "9");
        this.properties.put("backupBufferSize", "1048576");
        this.properties.put("compatibilityLevel", "1");
    }

    protected OIdentifiable setCurrentRecord(int iIndex) {
        this.currentRecordIdx = iIndex;
        this.currentRecord = iIndex < this.currentResultSet.size() ? (ORecord)this.currentResultSet.get(iIndex) : null;
        return this.currentRecord;
    }

    @Override
    protected void printApplicationInfo() {
        this.message("\nOrientDB console v." + OConstants.getVersion() + " " + "https://www.orientdb.com", new Object[0]);
        this.message("\nType 'help' to display all the supported commands.", new Object[0]);
    }

    protected void dumpResultSet(int limit) {
        new OTableFormatter(this).setMaxWidthSize(this.getConsoleWidth()).setMaxMultiValueEntries(this.getMaxMultiValueEntries()).writeRecords(this.currentResultSet, limit);
    }

    protected float getElapsedSecs(long start) {
        return (float)(System.currentTimeMillis() - start) / 1000.0f;
    }

    protected void printError(Exception e) {
        if (this.properties.get("debug") != null && Boolean.parseBoolean((String)this.properties.get("debug"))) {
            this.message("\n\n!ERROR:", new Object[0]);
            e.printStackTrace(this.err);
        } else {
            this.message("\n\n!ERROR: " + e.getMessage(), new Object[0]);
            if (e.getCause() != null) {
                for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
                    this.message("\n-> " + t.getMessage(), new Object[0]);
                }
            }
        }
    }

    protected void updateDatabaseInfo() {
        this.currentDatabase.reload();
    }

    protected String getContext() {
        String promptDateFormat;
        StringBuilder buffer = new StringBuilder(64);
        if (this.currentDatabase != null && this.currentDatabaseName != null) {
            this.currentDatabase.activateOnCurrentThread();
            buffer.append(" {db=");
            buffer.append(this.currentDatabaseName);
            if (this.currentDatabase.getTransaction().isActive()) {
                buffer.append(" tx=[");
                buffer.append(this.currentDatabase.getTransaction().getEntryCount());
                buffer.append(" entries]");
            }
        } else if (this.urlConnection != null) {
            buffer.append(" {server=");
            buffer.append(this.urlConnection.getUrl());
        }
        if ((promptDateFormat = (String)this.properties.get("promptDateFormat")) != null) {
            buffer.append(" (");
            SimpleDateFormat df = new SimpleDateFormat(promptDateFormat);
            buffer.append(df.format(new Date()));
            buffer.append(")");
        }
        if (buffer.length() > 0) {
            buffer.append("}");
        }
        return buffer.toString();
    }

    protected String getPrompt() {
        return String.format("orientdb%s> ", this.getContext());
    }

    protected void parseResult() {
        this.setResultset(null);
        if (this.currentResult instanceof Map) {
            return;
        }
        Object first = OMultiValue.getFirstValue((Object)this.currentResult);
        if (first instanceof OIdentifiable) {
            if (this.currentResult instanceof List) {
                this.currentResultSet = (List)this.currentResult;
            } else if (this.currentResult instanceof Collection) {
                this.currentResultSet = new ArrayList<OIdentifiable>();
                this.currentResultSet.addAll((Collection)this.currentResult);
            } else if (this.currentResult.getClass().isArray()) {
                this.currentResultSet = new ArrayList<OIdentifiable>();
                Collections.addAll(this.currentResultSet, (OIdentifiable[])this.currentResult);
            }
            this.setResultset(this.currentResultSet);
        }
    }

    protected void setResultset(List<OIdentifiable> iResultset) {
        this.currentResultSet = iResultset;
        this.currentRecordIdx = 0;
        this.currentRecord = iResultset == null || iResultset.isEmpty() ? null : iResultset.get(0).getRecord();
    }

    protected void resetResultSet() {
        this.currentResultSet = null;
        this.currentRecord = null;
    }

    protected void executeServerSideScript(String iLanguage, String iText) {
        if (iText == null) {
            return;
        }
        this.resetResultSet();
        long start = System.currentTimeMillis();
        OResultSet rs = this.currentDatabase.execute(iLanguage, iText, new Object[0]);
        this.currentResult = rs.stream().map(x -> x.toElement()).collect(Collectors.toList());
        rs.close();
        float elapsedSeconds = this.getElapsedSecs(start);
        this.parseResult();
        if (this.currentResultSet != null) {
            this.dumpResultSet(-1);
            this.message("\nServer side script executed in %f sec(s). Returned %d records", new Object[]{Float.valueOf(elapsedSeconds), this.currentResultSet.size()});
        } else {
            String lineFeed = this.currentResult instanceof Map ? "\n" : "";
            this.message("\nServer side script executed in %f sec(s). Value returned is: %s%s", new Object[]{Float.valueOf(elapsedSeconds), lineFeed, this.currentResult});
        }
    }

    protected Map<String, List<String>> parseOptions(String iOptions) {
        HashMap<String, List<String>> options = new HashMap<String, List<String>>();
        if (iOptions != null) {
            List opts = OStringSerializerHelper.smartSplit((String)iOptions, (char)' ', (char[])new char[0]);
            for (String o : opts) {
                int sep = o.indexOf(61);
                if (sep == -1) {
                    OLogManager.instance().warn((Object)this, "Unrecognized option %s, skipped", new Object[]{o});
                    continue;
                }
                String option = o.substring(0, sep);
                List items = OStringSerializerHelper.smartSplit((String)o.substring(sep + 1), (char)' ', (char[])new char[0]);
                options.put(option, items);
            }
        }
        return options;
    }

    public int getMaxMultiValueEntries() {
        if (this.properties.containsKey("maxMultiValueEntries")) {
            return Integer.parseInt((String)this.properties.get("maxMultiValueEntries"));
        }
        return this.maxMultiValueEntries;
    }

    private void dumpRecordDetails() {
        if (this.currentRecord == null) {
            return;
        }
        if (this.currentRecord instanceof ODocument) {
            ODocument rec = (ODocument)this.currentRecord;
            if (rec.getClassName() != null || rec.getIdentity().isValid()) {
                this.message("\nDOCUMENT @class:%s @rid:%s @version:%d", new Object[]{rec.getClassName(), rec.getIdentity().toString(), rec.getVersion()});
            }
            ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
            for (String fieldName : rec.getPropertyNames()) {
                ArrayList value = rec.getProperty(fieldName);
                if (value instanceof byte[]) {
                    value = "byte[" + ((byte[])value).length + "]";
                } else if (value instanceof Iterator) {
                    ArrayList coll = new ArrayList();
                    while (((Iterator)((Object)value)).hasNext()) {
                        coll.add(((Iterator)((Object)value)).next());
                    }
                    value = coll;
                } else if (OMultiValue.isMultiValue((Object)value)) {
                    value = OTableFormatter.getPrettyFieldMultiValue(OMultiValue.getMultiValueIterator((Object)value), this.getMaxMultiValueEntries());
                }
                ODocument row = new ODocument();
                resultSet.add(row);
                row.field("NAME", (Object)fieldName);
                row.field("VALUE", (Object)value);
            }
            OTableFormatter formatter = new OTableFormatter(this);
            formatter.setMaxWidthSize(this.getConsoleWidth());
            formatter.setMaxMultiValueEntries(this.getMaxMultiValueEntries());
            formatter.writeRecords(resultSet, -1);
        } else if (this.currentRecord instanceof OBlob) {
            OBlob rec = (OBlob)this.currentRecord;
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            this.message("\n| Bytes    - @rid: %s @version: %d", new Object[]{rec.getIdentity().toString(), rec.getVersion()});
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            byte[] value = rec.toStream();
            int max = Math.min(Integer.parseInt((String)this.properties.get("maxBinaryDisplay")), Array.getLength(value));
            for (int i = 0; i < max; ++i) {
                this.message("%03d", new Object[]{Array.getByte(value, i)});
            }
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
        } else {
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            this.message("\n| %s - record id: %s   v.%d", new Object[]{this.currentRecord.getClass().getSimpleName(), this.currentRecord.getIdentity().toString(), this.currentRecord.getVersion()});
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
        }
        this.out.println();
    }

    private void printSupportedSerializerFormat() {
        this.message("\nSupported formats are:", new Object[0]);
        for (ORecordSerializer s : ORecordSerializerFactory.instance().getFormats()) {
            if (!(s instanceof ORecordSerializerStringAbstract)) continue;
            this.message("\n- " + s.toString(), new Object[0]);
        }
    }

    private void browseRecords(OIdentifiableIterator<?> it) {
        int limit = Integer.parseInt((String)this.properties.get("limit"));
        OTableFormatter tableFormatter = new OTableFormatter(this).setMaxWidthSize(this.getConsoleWidth()).setMaxMultiValueEntries(this.maxMultiValueEntries);
        this.setResultset(new ArrayList<OIdentifiable>());
        while (it.hasNext() && this.currentResultSet.size() <= limit) {
            this.currentResultSet.add((OIdentifiable)it.next());
        }
        tableFormatter.writeRecords(this.currentResultSet, limit);
    }

    private Object sqlCommand(String iExpectedCommand, String iReceivedCommand, String iMessageSuccess, boolean iIncludeResult) {
        List result;
        String iMessageFailure = "\nCommand failed.\n";
        this.checkForDatabase();
        if (iReceivedCommand == null) {
            return null;
        }
        iReceivedCommand = iExpectedCommand + " " + iReceivedCommand.trim();
        this.resetResultSet();
        long start = System.currentTimeMillis();
        try (OResultSet rs = this.currentDatabase.command(iReceivedCommand, new Object[0]);){
            result = rs.stream().map(x -> x.toElement()).collect(Collectors.toList());
        }
        float elapsedSeconds = this.getElapsedSecs(start);
        if (iIncludeResult) {
            this.message(iMessageSuccess, new Object[]{result, Float.valueOf(elapsedSeconds)});
        } else {
            this.message(iMessageSuccess, new Object[]{Float.valueOf(elapsedSeconds)});
        }
        return result;
    }
}

