/*
 * Decompiled with CFR 0.152.
 */
package com.osacky.doctor;

import com.gradle.develocity.agent.gradle.adapters.BuildScanAdapter;
import com.osacky.doctor.BuildStartFinishListener;
import com.osacky.doctor.HasBuildScanTag;
import com.osacky.doctor.JavaHomeCheck;
import com.osacky.doctor.JavaHomeHandler;
import com.osacky.doctor.JvmVariables;
import com.osacky.doctor.internal.DefaultPrescriptionGenerator;
import com.osacky.doctor.internal.JavaHomeCheckPrescriptionsGenerator;
import com.osacky.doctor.internal.PillBoxPrinter;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001eH\u0002J\b\u0010\"\u001a\u00020\u001eH\u0002J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001aH\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0&H\u0016J\b\u0010'\u001a\u00020\u001eH\u0016J\u0014\u0010(\u001a\u0004\u0018\u00010\r2\b\u0010)\u001a\u0004\u0018\u00010\u001aH\u0002J&\u0010*\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u001a2\u0014\b\u0002\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0,H\u0002R\u001d\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0018\u001a&\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a \u001b*\u0012\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a\u0018\u00010\u001c0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/osacky/doctor/JavaHomeCheck;", "Lcom/osacky/doctor/BuildStartFinishListener;", "Lcom/osacky/doctor/HasBuildScanTag;", "jvmVariables", "Lcom/osacky/doctor/JvmVariables;", "javaHomeHandler", "Lcom/osacky/doctor/JavaHomeHandler;", "pillBoxPrinter", "Lcom/osacky/doctor/internal/PillBoxPrinter;", "prescriptionsGenerator", "Lcom/osacky/doctor/internal/JavaHomeCheckPrescriptionsGenerator;", "(Lcom/osacky/doctor/JvmVariables;Lcom/osacky/doctor/JavaHomeHandler;Lcom/osacky/doctor/internal/PillBoxPrinter;Lcom/osacky/doctor/internal/JavaHomeCheckPrescriptionsGenerator;)V", "environmentJavaExecutablePath", "Ljava/nio/file/Path;", "getEnvironmentJavaExecutablePath", "()Ljava/nio/file/Path;", "environmentJavaExecutablePath$delegate", "Lkotlin/Lazy;", "gradleJavaExecutablePath", "getGradleJavaExecutablePath", "gradleJavaExecutablePath$delegate", "isGradleUsingJavaHome", "", "()Z", "recordedErrors", "", "", "kotlin.jvm.PlatformType", "", "addCustomValues", "", "buildScanApi", "Lcom/gradle/develocity/agent/gradle/adapters/BuildScanAdapter;", "ensureJavaHomeIsSet", "ensureJavaHomeMatchesGradleHome", "failOrRecordMessage", "message", "onFinish", "", "onStart", "resolveEnvironmentJavaHome", "location", "resolveExecutableJavaPath", "fallback", "Lkotlin/Function1;", "doctor-plugin"})
public final class JavaHomeCheck
implements BuildStartFinishListener,
HasBuildScanTag {
    @NotNull
    private final JavaHomeHandler javaHomeHandler;
    @NotNull
    private final PillBoxPrinter pillBoxPrinter;
    @NotNull
    private final JavaHomeCheckPrescriptionsGenerator prescriptionsGenerator;
    @NotNull
    private final Lazy gradleJavaExecutablePath$delegate;
    @NotNull
    private final Lazy environmentJavaExecutablePath$delegate;
    private final Set<String> recordedErrors;

    public JavaHomeCheck(@NotNull JvmVariables jvmVariables, @NotNull JavaHomeHandler javaHomeHandler, @NotNull PillBoxPrinter pillBoxPrinter, @NotNull JavaHomeCheckPrescriptionsGenerator prescriptionsGenerator) {
        Intrinsics.checkNotNullParameter((Object)jvmVariables, (String)"jvmVariables");
        Intrinsics.checkNotNullParameter((Object)javaHomeHandler, (String)"javaHomeHandler");
        Intrinsics.checkNotNullParameter((Object)pillBoxPrinter, (String)"pillBoxPrinter");
        Intrinsics.checkNotNullParameter((Object)prescriptionsGenerator, (String)"prescriptionsGenerator");
        this.javaHomeHandler = javaHomeHandler;
        this.pillBoxPrinter = pillBoxPrinter;
        this.prescriptionsGenerator = prescriptionsGenerator;
        this.gradleJavaExecutablePath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this, jvmVariables){
            final /* synthetic */ JavaHomeCheck this$0;
            final /* synthetic */ JvmVariables $jvmVariables;
            {
                this.this$0 = $receiver;
                this.$jvmVariables = $jvmVariables;
                super(0);
            }

            public final Path invoke() {
                return JavaHomeCheck.resolveExecutableJavaPath$default(this.this$0, this.$jvmVariables.getGradleJavaHome(), null, 2, null);
            }
        }));
        this.environmentJavaExecutablePath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this, jvmVariables){
            final /* synthetic */ JavaHomeCheck this$0;
            final /* synthetic */ JvmVariables $jvmVariables;
            {
                this.this$0 = $receiver;
                this.$jvmVariables = $jvmVariables;
                super(0);
            }

            public final Path invoke() {
                return JavaHomeCheck.access$resolveEnvironmentJavaHome(this.this$0, (String)this.$jvmVariables.getEnvironmentJavaHomeProvider().get());
            }
        }));
        this.recordedErrors = Collections.synchronizedSet(new LinkedHashSet());
    }

    public /* synthetic */ JavaHomeCheck(JvmVariables jvmVariables, final JavaHomeHandler javaHomeHandler, PillBoxPrinter pillBoxPrinter, JavaHomeCheckPrescriptionsGenerator javaHomeCheckPrescriptionsGenerator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            javaHomeCheckPrescriptionsGenerator = new DefaultPrescriptionGenerator((Function0<String>)((Function0)new Function0<String>(){

                public final String invoke() {
                    return (String)javaHomeHandler.getExtraMessage().getOrNull();
                }
            }));
        }
        this(jvmVariables, javaHomeHandler, pillBoxPrinter, javaHomeCheckPrescriptionsGenerator);
    }

    private final Path getGradleJavaExecutablePath() {
        Lazy lazy = this.gradleJavaExecutablePath$delegate;
        return (Path)lazy.getValue();
    }

    private final Path getEnvironmentJavaExecutablePath() {
        Lazy lazy = this.environmentJavaExecutablePath$delegate;
        return (Path)lazy.getValue();
    }

    private final boolean isGradleUsingJavaHome() {
        return Intrinsics.areEqual((Object)this.getGradleJavaExecutablePath(), (Object)this.getEnvironmentJavaExecutablePath());
    }

    @Override
    public void onStart() {
        this.ensureJavaHomeIsSet();
        this.ensureJavaHomeMatchesGradleHome();
    }

    @Override
    @NotNull
    public List<String> onFinish() {
        Set<String> set = this.recordedErrors;
        Intrinsics.checkNotNullExpressionValue(set, (String)"recordedErrors");
        return CollectionsKt.toList((Iterable)set);
    }

    @Override
    public void addCustomValues(@NotNull BuildScanAdapter buildScanApi) {
        Intrinsics.checkNotNullParameter((Object)buildScanApi, (String)"buildScanApi");
        buildScanApi.tag("doctor-java-home");
    }

    private final void ensureJavaHomeIsSet() {
        Object object = this.javaHomeHandler.getEnsureJavaHomeIsSet().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"javaHomeHandler.ensureJavaHomeIsSet.get()");
        if (((Boolean)object).booleanValue() && this.getEnvironmentJavaExecutablePath() == null) {
            this.failOrRecordMessage(this.prescriptionsGenerator.generateJavaHomeIsNotSetMessage());
        }
    }

    private final void ensureJavaHomeMatchesGradleHome() {
        Object object = this.javaHomeHandler.getEnsureJavaHomeMatches().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"javaHomeHandler.ensureJavaHomeMatches.get()");
        if (((Boolean)object).booleanValue() && !this.isGradleUsingJavaHome()) {
            Path path = this.getEnvironmentJavaExecutablePath();
            this.failOrRecordMessage(this.prescriptionsGenerator.generateJavaHomeMismatchesGradleHome(path != null ? ((Object)path).toString() : null, ((Object)this.getGradleJavaExecutablePath()).toString()));
        }
    }

    private final void failOrRecordMessage(String message) {
        Object object = this.javaHomeHandler.getFailOnError().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"javaHomeHandler.failOnError.get()");
        if (((Boolean)object).booleanValue()) {
            throw new GradleException(this.pillBoxPrinter.createPill(message));
        }
        this.recordedErrors.add(message);
    }

    private final Path resolveEnvironmentJavaHome(String location) {
        Path path;
        String string = location;
        if (string != null) {
            String it = string;
            boolean bl = false;
            path = this.resolveExecutableJavaPath(it, (Function1<? super Path, ? extends Path>)((Function1)resolveEnvironmentJavaHome.1.1.INSTANCE));
        } else {
            path = null;
        }
        return path;
    }

    private final Path resolveExecutableJavaPath(String location, Function1<? super Path, ? extends Path> fallback) {
        Path path;
        Path path2 = new File(location).toPath();
        try {
            Path path3 = path2.resolve("bin").toRealPath(new LinkOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"{\n            // Follow \u2026R).toRealPath()\n        }");
            path = path3;
        }
        catch (NoSuchFileException exc) {
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            return (Path)fallback.invoke((Object)path2);
        }
        return path;
    }

    static /* synthetic */ Path resolveExecutableJavaPath$default(JavaHomeCheck javaHomeCheck, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = resolveExecutableJavaPath.1.INSTANCE;
        }
        return javaHomeCheck.resolveExecutableJavaPath(string, (Function1<? super Path, ? extends Path>)function1);
    }

    public static final /* synthetic */ Path access$resolveEnvironmentJavaHome(JavaHomeCheck $this, String location) {
        return $this.resolveEnvironmentJavaHome(location);
    }
}

