/*
 * Decompiled with CFR 0.152.
 */
package com.osacky.doctor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/osacky/doctor/internal/PillBoxPrinter;", "", "logger", "Lorg/gradle/api/logging/Logger;", "(Lorg/gradle/api/logging/Logger;)V", "messageLength", "", "title", "", "createEnding", "lineLength", "createPill", "message", "createTitle", "padMessage", "writePrescription", "", "messages", "", "doctor-plugin"})
@SourceDebugExtension(value={"SMAP\nPillBoxPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PillBoxPrinter.kt\ncom/osacky/doctor/internal/PillBoxPrinter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1863#2,2:54\n1368#2:56\n1454#2,2:57\n1557#2:59\n1628#2,3:60\n1456#2,3:63\n*S KotlinDebug\n*F\n+ 1 PillBoxPrinter.kt\ncom/osacky/doctor/internal/PillBoxPrinter\n*L\n19#1:54,2\n32#1:56\n32#1:57,2\n37#1:59\n37#1:60,3\n32#1:63,3\n*E\n"})
public final class PillBoxPrinter {
    @NotNull
    private final Logger logger;
    private final int messageLength;
    @NotNull
    private final String title;

    public PillBoxPrinter(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.messageLength = 100;
        this.title = "Gradle Doctor Prescriptions";
    }

    public final void writePrescription(@NotNull List<String> messages) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        if (!((Collection)messages).isEmpty()) {
            this.logger.warn(this.createTitle(this.messageLength));
        }
        Iterable $this$forEach$iv = messages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String item = (String)element$iv;
            boolean bl = false;
            this.logger.warn(this.padMessage(item));
            this.logger.warn(this.createEnding(this.messageLength));
        }
    }

    private final String createTitle(int lineLength) {
        return StringsKt.padEnd((String)StringsKt.padStart((String)(" " + this.title + " "), (int)(lineLength / 2 + 10), (char)'='), (int)(lineLength + 4), (char)'=');
    }

    private final String createEnding(int lineLength) {
        return StringsKt.padEnd((String)"", (int)(lineLength + 4), (char)'=');
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String padMessage(@NotNull String message) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        char[] cArray = new char[]{'\n'};
        Iterable $this$flatMap$iv = StringsKt.split$default((CharSequence)message, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            String line = (String)element$iv$iv;
            boolean bl = false;
            List chunked = StringsKt.chunked((CharSequence)line, (int)this.messageLength);
            if (chunked.isEmpty()) {
                list = CollectionsKt.listOf((Object)("| " + StringsKt.padEnd$default((String)"", (int)this.messageLength, (char)'\u0000', (int)2, null) + " |"));
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = chunked;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add("| " + StringsKt.padEnd$default((String)it, (int)this.messageLength, (char)'\u0000', (int)2, null) + " |");
                }
                list = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String createPill(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String lines = this.padMessage(message);
        List pilledLines = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.createTitle(this.messageLength)), (Object)lines), (Object)this.createEnding(this.messageLength));
        StringBuilder builder = new StringBuilder();
        for (String line : pilledLines) {
            builder.append(line).append('\n');
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }
}

