/*
 * Decompiled with CFR 0.152.
 */
package com.osacky.doctor;

import com.osacky.doctor.BuildStartFinishListener;
import com.osacky.doctor.DoctorExtension;
import com.osacky.doctor.HasBuildScanTag;
import com.osacky.doctor.internal.Clock;
import com.osacky.doctor.internal.DirtyBeanCollector;
import com.osacky.doctor.internal.ScanApi;
import java.text.NumberFormat;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/osacky/doctor/GarbagePrinter;", "Lcom/osacky/doctor/BuildStartFinishListener;", "Lcom/osacky/doctor/HasBuildScanTag;", "clock", "Lcom/osacky/doctor/internal/Clock;", "collector", "Lcom/osacky/doctor/internal/DirtyBeanCollector;", "extension", "Lcom/osacky/doctor/DoctorExtension;", "(Lcom/osacky/doctor/internal/Clock;Lcom/osacky/doctor/internal/DirtyBeanCollector;Lcom/osacky/doctor/DoctorExtension;)V", "formatter", "Ljava/text/NumberFormat;", "kotlin.jvm.PlatformType", "startBuildTime", "", "startGarbageTime", "", "warningThreshold", "addCustomValues", "", "buildScanApi", "Lcom/osacky/doctor/internal/ScanApi;", "onFinish", "", "", "onStart", "doctor-plugin"})
public final class GarbagePrinter
implements BuildStartFinishListener,
HasBuildScanTag {
    private final int startGarbageTime;
    private final long startBuildTime;
    private final NumberFormat formatter;
    private final int warningThreshold = 10000;
    private final Clock clock;
    private final DirtyBeanCollector collector;
    private final DoctorExtension extension;

    @Override
    public void onStart() {
    }

    @Override
    @NotNull
    public List<String> onFinish() {
        int endGarbageTime = this.collector.collect();
        long endBuildTime = this.clock.upTimeMillis();
        long buildDuration = endBuildTime - this.startBuildTime;
        int garbageDuration = endGarbageTime - this.startGarbageTime;
        float percentGarbageCollecting = (float)garbageDuration * 1.0f / (float)buildDuration;
        if (buildDuration > (long)this.warningThreshold) {
            Object object = this.extension.getGCWarningThreshold().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"extension.GCWarningThreshold.get()");
            if (percentGarbageCollecting > ((Number)object).floatValue()) {
                String message = StringsKt.trimIndent((String)("\n                This build spent " + this.formatter.format(Float.valueOf(percentGarbageCollecting)) + " garbage collecting.\n                If this is the first build with this Daemon, it likely means that this build needs more heap space.\n                Otherwise, if this is happening after several builds it could indicate a memory leak.\n                For a quick fix, restart this Gradle daemon. ./gradlew --stop\n                "));
                return CollectionsKt.listOf((Object)message);
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public void addCustomValues(@NotNull ScanApi buildScanApi) {
        Intrinsics.checkParameterIsNotNull((Object)buildScanApi, (String)"buildScanApi");
        buildScanApi.tag("doctor-high-gc");
    }

    public GarbagePrinter(@NotNull Clock clock, @NotNull DirtyBeanCollector collector, @NotNull DoctorExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        this.clock = clock;
        this.collector = collector;
        this.extension = extension;
        this.startGarbageTime = this.collector.collect();
        this.startBuildTime = this.clock.upTimeMillis();
        this.formatter = NumberFormat.getPercentInstance();
        this.warningThreshold = 10000;
    }
}

