/*
 * Decompiled with CFR 0.152.
 */
package com.osacky.doctor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/osacky/doctor/internal/PillBoxPrinter;", "", "logger", "Lorg/gradle/api/logging/Logger;", "(Lorg/gradle/api/logging/Logger;)V", "messageLength", "", "title", "", "createEnding", "lineLength", "createPill", "message", "createTitle", "padMessage", "writePrescription", "", "messages", "", "doctor-plugin"})
public final class PillBoxPrinter {
    private final int messageLength = 100;
    private final String title = "Gradle Doctor Prescriptions";
    private final Logger logger;

    public final void writePrescription(@NotNull List<String> messages) {
        Intrinsics.checkParameterIsNotNull(messages, (String)"messages");
        Collection collection = messages;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.logger.warn(this.createTitle(this.messageLength));
        }
        Iterable $this$forEach$iv = messages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String item = (String)element$iv;
            boolean bl2 = false;
            this.logger.warn(this.padMessage(item));
            this.logger.warn(this.createEnding(this.messageLength));
        }
    }

    private final String createTitle(int lineLength) {
        return StringsKt.padEnd((String)StringsKt.padStart((String)(' ' + this.title + ' '), (int)(lineLength / 2 + 10), (char)'='), (int)(lineLength + 4), (char)'=');
    }

    private final String createEnding(int lineLength) {
        return StringsKt.padEnd((String)"", (int)(lineLength + 4), (char)'=');
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String padMessage(@NotNull String message) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Iterable $this$flatMap$iv = StringsKt.split$default((CharSequence)message, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable iterable2;
            String line = (String)element$iv$iv;
            boolean bl = false;
            List chunked = StringsKt.chunked((CharSequence)line, (int)this.messageLength);
            if (chunked.isEmpty()) {
                iterable2 = CollectionsKt.listOf((Object)("| " + StringsKt.padEnd$default((String)"", (int)this.messageLength, (char)'\u0000', (int)2, null) + " |"));
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = chunked;
                boolean $i$f$map = false;
                Iterable iterable3 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    String string2 = "| " + StringsKt.padEnd$default((String)it, (int)this.messageLength, (char)'\u0000', (int)2, null) + " |";
                    collection.add(string2);
                }
                iterable2 = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = iterable2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String createPill(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        String lines = this.padMessage(message);
        List pilledLines = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.createTitle(this.messageLength)), (Object)lines), (Object)this.createEnding(this.messageLength));
        StringBuilder builder = new StringBuilder();
        for (String line : pilledLines) {
            builder.append(line).append('\n');
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    public PillBoxPrinter(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.messageLength = 100;
        this.title = "Gradle Doctor Prescriptions";
    }
}

