/*
 * Decompiled with CFR 0.152.
 */
package com.osacky.doctor;

import com.osacky.doctor.BuildStartFinishListener;
import com.osacky.doctor.DoctorExtension;
import com.osacky.doctor.internal.PillBoxPrinter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/osacky/doctor/JavaGCFlagChecker;", "Lcom/osacky/doctor/BuildStartFinishListener;", "pillBoxPrinter", "Lcom/osacky/doctor/internal/PillBoxPrinter;", "extension", "Lcom/osacky/doctor/DoctorExtension;", "(Lcom/osacky/doctor/internal/PillBoxPrinter;Lcom/osacky/doctor/DoctorExtension;)V", "parallelGCFlag", "", "getJavaVersion", "", "onFinish", "", "onStart", "", "doctor-plugin"})
public final class JavaGCFlagChecker
implements BuildStartFinishListener {
    private final String parallelGCFlag;
    private final PillBoxPrinter pillBoxPrinter;
    private final DoctorExtension extension;

    @Override
    public void onStart() {
        if (!((Boolean)this.extension.getWarnWhenNotUsingParallelGC().get()).booleanValue()) {
            return;
        }
        if (this.getJavaVersion() > 9) {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            Intrinsics.checkNotNullExpressionValue((Object)runtimeMXBean, (String)"ManagementFactory.getRuntimeMXBean()");
            if (!runtimeMXBean.getInputArguments().contains(this.parallelGCFlag)) {
                throw (Throwable)new GradleException(this.pillBoxPrinter.createPill(StringsKt.trimIndent((String)("\n                   For faster builds, use the parallel GC.\n                   Add " + this.parallelGCFlag + " to the org.gradle.jvmargs\n                        "))));
            }
        }
    }

    @Override
    @NotNull
    public List<String> onFinish() {
        return CollectionsKt.emptyList();
    }

    private final int getJavaVersion() {
        String string;
        String version;
        String string2 = version = System.getProperty("java.specification.version");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"version");
        if (StringsKt.startsWith$default((String)string2, (String)"1.", (boolean)false, (int)2, null)) {
            string = version;
            int n = 2;
            int n2 = 3;
            String string3 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            version = string3;
        } else {
            int dot = StringsKt.indexOf$default((CharSequence)version, (String)".", (int)0, (boolean)false, (int)6, null);
            if (dot != -1) {
                String string4 = version;
                int n = 0;
                String string5 = string4.substring(n, dot);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                version = string5;
            }
        }
        String string6 = version;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"version");
        string = string6;
        return Integer.parseInt(string);
    }

    public JavaGCFlagChecker(@NotNull PillBoxPrinter pillBoxPrinter, @NotNull DoctorExtension extension) {
        Intrinsics.checkNotNullParameter((Object)pillBoxPrinter, (String)"pillBoxPrinter");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.pillBoxPrinter = pillBoxPrinter;
        this.extension = extension;
        this.parallelGCFlag = "-XX:+UseParallelGC";
    }
}

