/*
 * Decompiled with CFR 0.152.
 */
package com.osacky.doctor;

import com.osacky.doctor.BuildStartFinishListener;
import com.osacky.doctor.DoctorExtension;
import com.osacky.doctor.FailureEventListener;
import com.osacky.doctor.HasBuildScanTag;
import com.osacky.doctor.internal.CoCaHelpersKt;
import com.osacky.tagger.ScanApi;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.service.ServiceRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0011H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/osacky/doctor/KotlinCompileDaemonFallbackDetector;", "Lcom/osacky/doctor/BuildStartFinishListener;", "Lcom/osacky/doctor/HasBuildScanTag;", "project", "Lorg/gradle/api/Project;", "extension", "Lcom/osacky/doctor/DoctorExtension;", "(Lorg/gradle/api/Project;Lcom/osacky/doctor/DoctorExtension;)V", "disposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "failureEventListener", "Lcom/osacky/doctor/FailureEventListener;", "fallbackCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "loggingService", "Lorg/gradle/internal/logging/LoggingManagerInternal;", "addCustomValues", "", "buildScanApi", "Lcom/osacky/tagger/ScanApi;", "hasUsedFallback", "", "isDaemonDisabled", "onFinish", "", "", "onStart", "doctor-plugin"})
public final class KotlinCompileDaemonFallbackDetector
implements BuildStartFinishListener,
HasBuildScanTag {
    private final AtomicInteger fallbackCounter;
    private final LoggingManagerInternal loggingService;
    private final FailureEventListener failureEventListener;
    private final CompositeDisposable disposable;
    private final Project project;
    private final DoctorExtension extension;

    @Override
    public void onStart() {
        if (!((Boolean)this.extension.getWarnIfKotlinCompileDaemonFallback().get()).booleanValue() || this.isDaemonDisabled(this.project)) {
            return;
        }
        this.loggingService.addOutputEventListener((OutputEventListener)this.failureEventListener);
    }

    @Override
    @NotNull
    public List<String> onFinish() {
        this.loggingService.removeOutputEventListener((OutputEventListener)this.failureEventListener);
        this.disposable.dispose();
        if (this.hasUsedFallback()) {
            return CollectionsKt.listOf((Object)"The Kotlin Compiler Daemon failed to connect and likely won't recover on its own.\nThe fallback strategy is incredibly slow and should be avoided.\nhttps://youtrack.jetbrains.com/issue/KT-48843\n\nTo recover, try killing the Kotlin Compiler Daemon:\n   1. ./gradlew --stop\n   2. Find Kotlin daemon process id (pid): `jps | grep Kotlin`\n   3. kill <pid>\n   \nIf that didn't help, check that there are no invalid JVM arguments in \"kotlin.daemon.jvm.options\" property except for Xmx.");
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public void addCustomValues(@NotNull ScanApi buildScanApi) {
        Intrinsics.checkNotNullParameter((Object)buildScanApi, (String)"buildScanApi");
        if (this.hasUsedFallback()) {
            buildScanApi.tag("doctor-kotlin-compile-daemon-fallback");
        }
    }

    private final boolean hasUsedFallback() {
        return this.fallbackCounter.get() > 1;
    }

    private final boolean isDaemonDisabled(Project project) {
        ProviderFactory providerFactory = project.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"project.providers");
        String strategy = CoCaHelpersKt.sysProperty("kotlin.compiler.execution.strategy", providerFactory).orElse("daemon");
        return Intrinsics.areEqual((Object)strategy, (Object)"daemon") ^ true;
    }

    public KotlinCompileDaemonFallbackDetector(@NotNull Project project, @NotNull DoctorExtension extension) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.project = project;
        this.extension = extension;
        this.fallbackCounter = new AtomicInteger(0);
        Gradle gradle = this.project.getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
        Gradle $this$serviceOf$iv = gradle;
        boolean $i$f$serviceOf = false;
        Gradle gradle2 = $this$serviceOf$iv.getGradle();
        if (gradle2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.internal.GradleInternal");
        }
        ServiceRegistry serviceRegistry = ((GradleInternal)gradle2).getServices();
        Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry, (String)"(gradle as GradleInternal).services");
        ServiceRegistry $this$get$iv$iv = serviceRegistry;
        boolean $i$f$get = false;
        Object object = $this$get$iv$iv.get(LoggingManagerInternal.class);
        Intrinsics.checkNotNull((Object)object);
        this.loggingService = (LoggingManagerInternal)object;
        this.failureEventListener = new FailureEventListener(this.fallbackCounter);
        this.disposable = new CompositeDisposable();
    }
}

