/*
 * Decompiled with CFR 0.152.
 */
package com.osacky.doctor.internal;

import com.osacky.doctor.internal.DaemonChecker;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0017\u0010\u0007\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00040\bH\u0002\u00a2\u0006\u0002\u0010\tJ\f\u0010\n\u001a\u00020\u0004*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/osacky/doctor/internal/UnixDaemonChecker;", "Lcom/osacky/doctor/internal/DaemonChecker;", "()V", "check", "", "numberOfDaemons", "", "execute", "", "([Ljava/lang/String;)Ljava/lang/String;", "readToString", "Ljava/io/InputStream;", "doctor-plugin"})
public final class UnixDaemonChecker
implements DaemonChecker {
    @Override
    @Nullable
    public String check() {
        int numberOfDaemons = this.numberOfDaemons();
        return numberOfDaemons > 1 ? StringsKt.trimIndent((String)("\n                   " + numberOfDaemons + " Gradle Daemons Active.\n                   This may indicate a settings mismatch between the IDE and the terminal.\n                   There might also be a bug causing extra Daemons to spawn.\n                   You can check active Daemons with `jps`.\n                   To kill all active Daemons use:\n                   pkill -f '.*GradleDaemon.*'\n\n                   This might be expected if you are working on multiple Gradle projects or if you are using build.gradle.kts.\n                   To disable this message add this to your root build.gradle file:\n                   doctor {\n                     disallowMultipleDaemons = false\n                   }\n            ")) : null;
    }

    private final int numberOfDaemons() {
        String string = this.execute(new String[]{"/bin/bash", "-c", "ps aux | grep GradleDaemon | wc -l"});
        return Integer.parseInt(string) - 2;
    }

    private final String execute(String[] $this$execute) {
        Process process = Runtime.getRuntime().exec($this$execute);
        if (process.waitFor() != 0) {
            Process process2 = process;
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
            InputStream inputStream = process2.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.errorStream");
            throw (Throwable)new RuntimeException(this.readToString(inputStream));
        }
        Process process3 = process;
        Intrinsics.checkNotNullExpressionValue((Object)process3, (String)"process");
        InputStream inputStream = process3.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
        return this.readToString(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readToString(InputStream $this$readToString) {
        String string;
        Closeable closeable = $this$readToString;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Object object = ByteStreamsKt.readBytes((InputStream)it);
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            object = new String((byte[])object, charset);
            string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }
}

