/*
 * Decompiled with CFR 0.152.
 */
package com.osacky.doctor;

import com.osacky.doctor.BuildStartFinishListener;
import com.osacky.doctor.DoctorExtension;
import com.osacky.doctor.internal.PillBoxPrinter;
import java.lang.management.ManagementFactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/osacky/doctor/JavaGCFlagChecker;", "Lcom/osacky/doctor/BuildStartFinishListener;", "pillBoxPrinter", "Lcom/osacky/doctor/internal/PillBoxPrinter;", "extension", "Lcom/osacky/doctor/DoctorExtension;", "(Lcom/osacky/doctor/internal/PillBoxPrinter;Lcom/osacky/doctor/DoctorExtension;)V", "parallelGCFlag", "", "getJavaVersion", "", "onFinish", "", "onStart", "", "doctor-plugin"})
public final class JavaGCFlagChecker
implements BuildStartFinishListener {
    @NotNull
    private final PillBoxPrinter pillBoxPrinter;
    @NotNull
    private final DoctorExtension extension;
    @NotNull
    private final String parallelGCFlag;

    public JavaGCFlagChecker(@NotNull PillBoxPrinter pillBoxPrinter, @NotNull DoctorExtension extension) {
        Intrinsics.checkNotNullParameter((Object)pillBoxPrinter, (String)"pillBoxPrinter");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.pillBoxPrinter = pillBoxPrinter;
        this.extension = extension;
        this.parallelGCFlag = "-XX:+UseParallelGC";
    }

    @Override
    public void onStart() {
        if (!((Boolean)this.extension.getWarnWhenNotUsingParallelGC().get()).booleanValue()) {
            return;
        }
        if (this.getJavaVersion() > 9 && !ManagementFactory.getRuntimeMXBean().getInputArguments().contains(this.parallelGCFlag)) {
            throw new GradleException(this.pillBoxPrinter.createPill(StringsKt.trimIndent((String)("\n                        For faster builds, use the parallel GC.\n                        Add " + this.parallelGCFlag + " to the org.gradle.jvmargs\n                        "))));
        }
    }

    @Override
    @NotNull
    public List<String> onFinish() {
        return CollectionsKt.emptyList();
    }

    private final int getJavaVersion() {
        String version;
        String string = version = System.getProperty("java.specification.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"version");
        if (StringsKt.startsWith$default((String)string, (String)"1.", (boolean)false, (int)2, null)) {
            String string2 = version;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"version");
            String string3 = string2;
            int n = 2;
            int n2 = 3;
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            version = string4;
        } else {
            String string5 = version;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"version");
            int dot = StringsKt.indexOf$default((CharSequence)string5, (String)".", (int)0, (boolean)false, (int)6, null);
            if (dot != -1) {
                String string6 = version;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"version");
                String string7 = string6;
                int n = 0;
                String string8 = string7.substring(n, dot);
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                version = string8;
            }
        }
        String string9 = version;
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"version");
        return Integer.parseInt(string9);
    }
}

