/*
 * Decompiled with CFR 0.152.
 */
package com.osacky.doctor;

import com.osacky.doctor.BuildStartFinishListener;
import com.osacky.doctor.DoctorExtension;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/osacky/doctor/JetifierWarning;", "Lcom/osacky/doctor/BuildStartFinishListener;", "doctorExtension", "Lcom/osacky/doctor/DoctorExtension;", "project", "Lorg/gradle/api/Project;", "(Lcom/osacky/doctor/DoctorExtension;Lorg/gradle/api/Project;)V", "onFinish", "", "", "onStart", "", "Companion", "doctor-plugin"})
public final class JetifierWarning
implements BuildStartFinishListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoctorExtension doctorExtension;
    @NotNull
    private final Project project;
    @NotNull
    public static final String JETIFIER_GRADLE_PROPERTY = "android.enableJetifier";

    public JetifierWarning(@NotNull DoctorExtension doctorExtension, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)doctorExtension, (String)"doctorExtension");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.doctorExtension = doctorExtension;
        this.project = project;
    }

    @Override
    public void onStart() {
    }

    @Override
    @NotNull
    public List<String> onFinish() {
        String isJetifierEnabled = (String)this.project.findProperty(JETIFIER_GRADLE_PROPERTY);
        Object object = this.doctorExtension.getWarnWhenJetifierEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"doctorExtension.warnWhenJetifierEnabled.get()");
        if (((Boolean)object).booleanValue() && isJetifierEnabled != null && Intrinsics.areEqual((Object)isJetifierEnabled, (Object)"true")) {
            return CollectionsKt.listOf((Object)"Jetifier was enabled which means your builds are slower by 4-20%.\nHere's an article to help you disable it:\nhttps://adambennett.dev/2020/08/disabling-jetifier/\n\nTo disable this warning, configure the Gradle Doctor extension:\ndoctor {\n  warnWhenJetifierEnabled.set(false)\n}");
        }
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/osacky/doctor/JetifierWarning$Companion;", "", "()V", "JETIFIER_GRADLE_PROPERTY", "", "doctor-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

