/*
 * Decompiled with CFR 0.152.
 */
package com.osacky.doctor;

import com.osacky.doctor.BuildStartFinishListener;
import com.osacky.doctor.HasBuildScanTag;
import com.osacky.tagger.ScanApi;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationType;
import org.gradle.api.provider.Provider;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationFinishEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/osacky/doctor/SlowerFromCacheCollector;", "Lcom/osacky/doctor/BuildStartFinishListener;", "Lcom/osacky/doctor/HasBuildScanTag;", "negativeAvoidanceThreshold", "Lorg/gradle/api/provider/Provider;", "", "(Lorg/gradle/api/provider/Provider;)V", "longerTaskList", "", "", "addCustomValues", "", "buildScanApi", "Lcom/osacky/tagger/ScanApi;", "onEvent", "buildOperation", "Lorg/gradle/internal/operations/BuildOperationDescriptor;", "finishEvent", "Lorg/gradle/internal/operations/OperationFinishEvent;", "onFinish", "", "onStart", "doctor-plugin"})
public final class SlowerFromCacheCollector
implements BuildStartFinishListener,
HasBuildScanTag {
    @NotNull
    private final Provider<Integer> negativeAvoidanceThreshold;
    @NotNull
    private final List<String> longerTaskList;

    public SlowerFromCacheCollector(@NotNull Provider<Integer> negativeAvoidanceThreshold) {
        Intrinsics.checkNotNullParameter(negativeAvoidanceThreshold, (String)"negativeAvoidanceThreshold");
        this.negativeAvoidanceThreshold = negativeAvoidanceThreshold;
        this.longerTaskList = new ArrayList();
    }

    public final void onEvent(@NotNull BuildOperationDescriptor buildOperation, @NotNull OperationFinishEvent finishEvent) {
        Intrinsics.checkNotNullParameter((Object)buildOperation, (String)"buildOperation");
        Intrinsics.checkNotNullParameter((Object)finishEvent, (String)"finishEvent");
        Object executeResult = finishEvent.getResult();
        if (executeResult instanceof ExecuteTaskBuildOperationType.Result) {
            long duration = finishEvent.getEndTime() - finishEvent.getStartTime();
            if (((ExecuteTaskBuildOperationType.Result)executeResult).getOriginExecutionTime() != null) {
                Object object = this.negativeAvoidanceThreshold.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"negativeAvoidanceThreshold.get()");
                int threshold = ((Number)object).intValue();
                Long l = ((ExecuteTaskBuildOperationType.Result)executeResult).getOriginExecutionTime();
                Intrinsics.checkNotNull((Object)l);
                if (l + (long)threshold < duration) {
                    String string = buildOperation.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buildOperation.name");
                    this.longerTaskList.add(string);
                }
            }
        }
    }

    @Override
    public void onStart() {
    }

    @Override
    @NotNull
    public List<String> onFinish() {
        if (this.longerTaskList.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)("The following operations were slower to pull from the cache than to rerun:\n" + CollectionsKt.joinToString$default((Iterable)this.longerTaskList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\nConsider disabling caching them.\nFor more information see: https://runningcode.github.io/gradle-doctor/slower-from-cache/"));
    }

    @Override
    public void addCustomValues(@NotNull ScanApi buildScanApi) {
        Intrinsics.checkNotNullParameter((Object)buildScanApi, (String)"buildScanApi");
        buildScanApi.tag("doctor-negative-savings");
        buildScanApi.value("doctor-negative-savings-tasks", CollectionsKt.joinToString$default((Iterable)this.longerTaskList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }
}

