/*
 * Decompiled with CFR 0.152.
 */
package com.osohq.oso_cloud;

import com.osohq.oso_cloud.Fact;
import com.osohq.oso_cloud.Value;
import com.osohq.oso_cloud.ValueOfType;
import com.osohq.oso_cloud.ValuePattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class FactPattern {
    public final String predicate;
    public final List<ValuePattern> args;

    public FactPattern(String predicate, ValuePattern ... args) {
        this(predicate, args == null ? new ArrayList() : Arrays.asList(args));
    }

    public FactPattern(String predicate, List<ValuePattern> args) {
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate cannot be null. Use FactPattern.anyPredicate() for a wildcard predicate.");
        }
        ArrayList<ValuePattern> validatedArgs = args == null ? new ArrayList<ValuePattern>() : args;
        for (ValuePattern arg : validatedArgs) {
            if (arg != null) continue;
            throw new IllegalArgumentException("FactPattern argument cannot be null. Use ValuePattern.ANY for wildcards.");
        }
        this.predicate = predicate;
        this.args = validatedArgs;
    }

    Value[] toApiArgs() {
        return (Value[])this.args.stream().map(pattern -> {
            if (pattern instanceof Value) {
                return (Value)pattern;
            }
            if (pattern instanceof ValueOfType) {
                return new Value(((ValueOfType)pattern).type, null, true);
            }
            if (pattern == ValuePattern.ANY) {
                return null;
            }
            throw new IllegalArgumentException("Unexpected ValuePattern type: " + String.valueOf(pattern.getClass()));
        }).toArray(Value[]::new);
    }

    Fact toDeleteFact() {
        Value[] factArgs = (Value[])this.args.stream().map(pattern -> {
            if (pattern instanceof Value) {
                return (Value)pattern;
            }
            if (pattern instanceof ValueOfType) {
                return new Value(((ValueOfType)pattern).type, null, true);
            }
            if (pattern == ValuePattern.ANY) {
                return new Value(null, null, true);
            }
            throw new IllegalArgumentException("Unexpected ValuePattern type: " + String.valueOf(pattern.getClass()));
        }).toArray(Value[]::new);
        return new Fact(this.predicate, factArgs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactPattern that = (FactPattern)o;
        return Objects.equals(this.predicate, that.predicate) && this.args.equals(that.args);
    }

    public int hashCode() {
        return Objects.hash(this.predicate, this.args);
    }

    public String toString() {
        return "FactPattern{predicate='" + this.predicate + "', args=" + String.valueOf(this.args) + "}";
    }
}

