/*
 * Decompiled with CFR 0.152.
 */
package com.osohq.oso_cloud;

import com.osohq.oso_cloud.ApiException;
import com.osohq.oso_cloud.BatchTransaction;
import com.osohq.oso_cloud.Fact;
import com.osohq.oso_cloud.FactPattern;
import com.osohq.oso_cloud.OsoClientOptions;
import com.osohq.oso_cloud.ParityHandle;
import com.osohq.oso_cloud.PolicyMetadata;
import com.osohq.oso_cloud.Value;
import com.osohq.oso_cloud.internal.Api;
import com.osohq.oso_cloud.internal.AsyncQueryBuilderImpl;
import com.osohq.oso_cloud.internal.ParityHandleImpl;
import com.osohq.oso_cloud.internal.QueryBuilderImpl;
import com.osohq.oso_cloud.querybuilder.AsyncQueryBuilder;
import com.osohq.oso_cloud.querybuilder.QueryArg;
import com.osohq.oso_cloud.querybuilder.QueryBuilder;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class Oso {
    final Api api;

    public Oso(String apiKey) {
        this(apiKey, null);
    }

    public Oso(String apiKey, URI uri) {
        this(apiKey, uri, new OsoClientOptions());
    }

    public Oso(String apiKey, URI uri, URI fallbackUri) {
        this(apiKey, uri, new OsoClientOptions.Builder().withFallbackUri(fallbackUri).build());
    }

    public Oso(String apiKey, URI uri, URI fallbackUri, Path dataBindingsPath) {
        this.api = new Api(apiKey, uri, new OsoClientOptions.Builder().withFallbackUri(fallbackUri).withDataBindingsPath(dataBindingsPath).build());
    }

    public Oso(String apiKey, URI uri, OsoClientOptions options) {
        this.api = new Api(apiKey, uri, options);
    }

    Api getApi() {
        return this.api;
    }

    public void setMaxConnections(int maxConnections) {
        this.api.setMaxConnections(maxConnections);
    }

    public String policy() throws IOException, ApiException {
        return this.api.getPolicy(null);
    }

    public PolicyMetadata policyMetadata() throws IOException, ApiException {
        return this.api.getPolicyMetadata(null);
    }

    public void policy(String policy) throws IOException, ApiException {
        this.api.postPolicy(policy, null);
    }

    public void insert(Fact fact) throws IOException, ApiException {
        this.api.insertFact(fact, null);
    }

    public Fact[] get(FactPattern pattern) throws IOException, ApiException {
        return this.api.getFacts(null, pattern.predicate, pattern.toApiArgs());
    }

    public void delete(Fact fact) throws IOException, ApiException {
        this.api.deleteFact(fact, null);
    }

    public void delete(FactPattern pattern) throws IOException, ApiException {
        this.api.deleteFact(pattern.toDeleteFact(), null);
    }

    public void batch(Consumer<BatchTransaction> fn) throws IOException, ApiException {
        this.api.batch(fn, null);
    }

    public boolean authorize(Value actor, String action, Value resource, List<Fact> contextFacts, ParityHandle parityHandle) throws IOException, ApiException {
        return this.api.postAuthorize(actor, action, resource, contextFacts, (ParityHandleImpl)parityHandle, null);
    }

    public boolean authorize(Value actor, String action, Value resource, List<Fact> contextFacts) throws IOException, ApiException {
        return this.authorize(actor, action, resource, contextFacts, null);
    }

    public boolean authorize(Value actor, String action, Value resource, ParityHandle parityHandle) throws IOException, ApiException {
        return this.authorize(actor, action, resource, new ArrayList<Fact>(), parityHandle);
    }

    public boolean authorize(Value actor, String action, Value resource) throws IOException, ApiException {
        return this.authorize(actor, action, resource, new ArrayList<Fact>(), null);
    }

    public String[] list(Value actor, String action, String resourceType, List<Fact> contextFacts) throws IOException, ApiException {
        return this.api.postList(actor, action, resourceType, contextFacts, null);
    }

    public String[] list(Value actor, String action, String resourceType) throws IOException, ApiException {
        return this.list(actor, action, resourceType, new ArrayList<Fact>());
    }

    public String[] actions(Value actor, Value resource, List<Fact> contextFacts) throws IOException, ApiException {
        return this.api.postActions(actor, resource, contextFacts, null);
    }

    public String[] actions(Value actor, Value resource) throws IOException, ApiException {
        return this.actions(actor, resource, new ArrayList<Fact>());
    }

    public String authorizeLocal(Value actor, String action, Value resource, List<Fact> contextFacts, ParityHandle parityHandle) throws IOException, ApiException {
        return this.api.postAuthorizeQuery(actor, action, resource, contextFacts, (ParityHandleImpl)parityHandle, null);
    }

    public String authorizeLocal(Value actor, String action, Value resource, List<Fact> contextFacts) throws IOException, ApiException {
        return this.authorizeLocal(actor, action, resource, contextFacts, null);
    }

    public String authorizeLocal(Value actor, String action, Value resource, ParityHandle parityHandle) throws IOException, ApiException {
        return this.authorizeLocal(actor, action, resource, new ArrayList<Fact>(), parityHandle);
    }

    public String authorizeLocal(Value actor, String action, Value resource) throws IOException, ApiException {
        return this.authorizeLocal(actor, action, resource, new ArrayList<Fact>(), null);
    }

    public String listLocal(Value actor, String action, String resourceType, String column) throws IOException, ApiException {
        return this.listLocal(actor, action, resourceType, column, new ArrayList<Fact>());
    }

    public String listLocal(Value actor, String action, String resourceType, String column, List<Fact> contextFacts) throws IOException, ApiException {
        return this.api.postListQuery(actor, action, resourceType, column, contextFacts, null);
    }

    @Deprecated
    public String actionsLocal(Value actor, String action, Value resource) throws IOException, ApiException {
        return this.actionsLocal(actor, resource);
    }

    public String actionsLocal(Value actor, Value resource) throws IOException, ApiException {
        return this.actionsLocal(actor, resource, new ArrayList<Fact>());
    }

    public String actionsLocal(Value actor, Value resource, List<Fact> contextFacts) throws IOException, ApiException {
        return this.api.postActionsQuery(actor, resource, contextFacts, null);
    }

    public QueryBuilder buildQuery(String predicate, QueryArg ... args) {
        return QueryBuilderImpl.init(this.api, predicate, args);
    }

    public ParityHandle createParityHandle() {
        return new ParityHandleImpl();
    }

    public Async withAsyncExecutor(Executor executor) {
        return new Async(executor);
    }

    public class Async {
        private final Executor executor;

        private Async(Executor executor) {
            this.executor = executor;
        }

        public CompletableFuture<Boolean> authorize(Value actor, String action, Value resource, List<Fact> contextFacts, ParityHandle parityHandle) {
            return Oso.this.api.asynchronously(this.executor, requestHolder -> Oso.this.api.postAuthorize(actor, action, resource, contextFacts, (ParityHandleImpl)parityHandle, requestHolder));
        }

        public CompletableFuture<Boolean> authorize(Value actor, String action, Value resource, List<Fact> contextFacts) {
            return this.authorize(actor, action, resource, contextFacts, null);
        }

        public CompletableFuture<Boolean> authorize(Value actor, String action, Value resource, ParityHandle parityHandle) {
            return this.authorize(actor, action, resource, new ArrayList<Fact>(), parityHandle);
        }

        public CompletableFuture<Boolean> authorize(Value actor, String action, Value resource) {
            return this.authorize(actor, action, resource, new ArrayList<Fact>(), null);
        }

        public CompletableFuture<String> policy() {
            return Oso.this.api.asynchronously(this.executor, Oso.this.api::getPolicy);
        }

        public CompletableFuture<PolicyMetadata> policyMetadata() {
            return Oso.this.api.asynchronously(this.executor, Oso.this.api::getPolicyMetadata);
        }

        public CompletableFuture<Void> policy(String policy) {
            return Oso.this.api.asynchronously(this.executor, requestHolder -> {
                Oso.this.api.postPolicy(policy, requestHolder);
                return null;
            });
        }

        public CompletableFuture<Void> insert(Fact fact) {
            return Oso.this.api.asynchronously(this.executor, requestHolder -> {
                Oso.this.api.insertFact(fact, requestHolder);
                return null;
            });
        }

        public CompletableFuture<Fact[]> get(FactPattern pattern) {
            return Oso.this.api.asynchronously(this.executor, requestHolder -> Oso.this.api.getFacts(requestHolder, pattern.predicate, pattern.toApiArgs()));
        }

        public CompletableFuture<Void> delete(Fact fact) {
            return Oso.this.api.asynchronously(this.executor, requestHolder -> {
                Oso.this.api.deleteFact(fact, requestHolder);
                return null;
            });
        }

        public CompletableFuture<Void> delete(FactPattern pattern) {
            return Oso.this.api.asynchronously(this.executor, requestHolder -> {
                Oso.this.api.deleteFact(pattern.toDeleteFact(), null);
                return null;
            });
        }

        public CompletableFuture<Void> batch(Consumer<BatchTransaction> fn) {
            return Oso.this.api.asynchronously(this.executor, requestHolder -> {
                Oso.this.api.batch(fn, requestHolder);
                return null;
            });
        }

        public CompletableFuture<String[]> list(Value actor, String action, String resourceType, List<Fact> contextFacts) {
            return Oso.this.api.asynchronously(this.executor, requestHolder -> Oso.this.api.postList(actor, action, resourceType, contextFacts, requestHolder));
        }

        public CompletableFuture<String[]> list(Value actor, String action, String resourceType) {
            return this.list(actor, action, resourceType, new ArrayList<Fact>());
        }

        public CompletableFuture<String[]> actions(Value actor, Value resource, List<Fact> contextFacts) {
            return Oso.this.api.asynchronously(this.executor, requestHolder -> Oso.this.api.postActions(actor, resource, contextFacts, requestHolder));
        }

        public CompletableFuture<String[]> actions(Value actor, Value resource) {
            return this.actions(actor, resource, new ArrayList<Fact>());
        }

        public CompletableFuture<String> authorizeLocal(Value actor, String action, Value resource, List<Fact> contextFacts, ParityHandle parityHandle) {
            return Oso.this.api.asynchronously(this.executor, requestHolder -> Oso.this.api.postAuthorizeQuery(actor, action, resource, contextFacts, (ParityHandleImpl)parityHandle, requestHolder));
        }

        public CompletableFuture<String> authorizeLocal(Value actor, String action, Value resource, List<Fact> contextFacts) {
            return this.authorizeLocal(actor, action, resource, contextFacts, null);
        }

        public CompletableFuture<String> authorizeLocal(Value actor, String action, Value resource, ParityHandle parityHandle) {
            return this.authorizeLocal(actor, action, resource, new ArrayList<Fact>(), parityHandle);
        }

        public CompletableFuture<String> authorizeLocal(Value actor, String action, Value resource) {
            return this.authorizeLocal(actor, action, resource, new ArrayList<Fact>(), null);
        }

        public CompletableFuture<String> listLocal(Value actor, String action, String resourceType, String column) {
            return this.listLocal(actor, action, resourceType, column, new ArrayList<Fact>());
        }

        public CompletableFuture<String> listLocal(Value actor, String action, String resourceType, String column, List<Fact> contextFacts) {
            return Oso.this.api.asynchronously(this.executor, requestHolder -> Oso.this.api.postListQuery(actor, action, resourceType, column, contextFacts, requestHolder));
        }

        public CompletableFuture<String> actionsLocal(Value actor, Value resource) {
            return this.actionsLocal(actor, resource, new ArrayList<Fact>());
        }

        public CompletableFuture<String> actionsLocal(Value actor, Value resource, List<Fact> contextFacts) {
            return Oso.this.api.asynchronously(this.executor, requestHolder -> Oso.this.api.postActionsQuery(actor, resource, contextFacts, requestHolder));
        }

        public AsyncQueryBuilder buildQuery(String predicate, QueryArg ... args) {
            return AsyncQueryBuilderImpl.init(this.executor, Oso.this.api, predicate, args);
        }
    }
}

