/*
 * Decompiled with CFR 0.152.
 */
package com.osohq.oso_cloud;

import java.net.URI;
import java.nio.file.Path;

public class OsoClientOptions {
    private URI fallbackUri;
    private Path dataBindingsPath;
    private Integer defaultTimeoutMilliseconds;
    private Integer readTimeoutMilliseconds;
    private Integer writeTimeoutMilliseconds;

    public URI getFallbackUri() {
        return this.fallbackUri;
    }

    public Path getDataBindingsPath() {
        return this.dataBindingsPath;
    }

    @Deprecated
    public Integer getTimeoutMilliseconds() {
        return this.getDefaultTimeoutMilliseconds();
    }

    public Integer getDefaultTimeoutMilliseconds() {
        return this.defaultTimeoutMilliseconds;
    }

    public Integer getReadTimeoutMilliseconds() {
        return this.readTimeoutMilliseconds;
    }

    public Integer getWriteTimeoutMilliseconds() {
        return this.writeTimeoutMilliseconds;
    }

    public static class Builder {
        private final OsoClientOptions options = new OsoClientOptions();

        public Builder withFallbackUri(URI fallbackUri) {
            this.options.fallbackUri = fallbackUri;
            return this;
        }

        public Builder withDataBindingsPath(Path dataBindingsPath) {
            this.options.dataBindingsPath = dataBindingsPath;
            return this;
        }

        @Deprecated
        public Builder withTimeoutMilliseconds(Integer timeoutMilliseconds) {
            return this.withDefaultTimeoutMilliseconds(timeoutMilliseconds);
        }

        public Builder withDefaultTimeoutMilliseconds(Integer defaultTimeoutMilliseconds) {
            this.options.defaultTimeoutMilliseconds = defaultTimeoutMilliseconds;
            return this;
        }

        public Builder withReadTimeoutMilliseconds(Integer readTimeoutMilliseconds) {
            this.options.readTimeoutMilliseconds = readTimeoutMilliseconds;
            return this;
        }

        public Builder withWriteTimeoutMilliseconds(Integer writeTimeoutMilliseconds) {
            this.options.writeTimeoutMilliseconds = writeTimeoutMilliseconds;
            return this;
        }

        public OsoClientOptions build() {
            return this.options;
        }
    }
}

