/*
 * Decompiled with CFR 0.152.
 */
package com.osohq.oso_cloud;

import com.osohq.oso_cloud.ValuePattern;
import com.osohq.oso_cloud.querybuilder.QueryArg;

public class Value
implements ValuePattern,
QueryArg {
    public String type;
    public String id;

    public Value(String type, String id) {
        if (type == null) {
            throw new IllegalArgumentException("Value type cannot be null.");
        }
        if (id == null) {
            throw new IllegalArgumentException("Value ID cannot be null.");
        }
        this.type = type;
        this.id = id;
    }

    public Value(String id) {
        this("String", id);
    }

    public Value(long id) {
        this("Integer", Long.toString(id));
    }

    public Value(boolean id) {
        this("Boolean", Boolean.toString(id));
    }

    Value(String type, String id, boolean internal) {
        this.type = type;
        this.id = id;
    }

    private static String wrapWithQuotes(String input) {
        return input != null ? "\"" + input + "\"" : null;
    }

    public String toString() {
        return String.format("Value(%s, %s)", Value.wrapWithQuotes(this.type), Value.wrapWithQuotes(this.id));
    }

    @Override
    public String getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Value other = (Value)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

