/*
 * Decompiled with CFR 0.152.
 */
package com.osohq.oso_cloud.internal;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.osohq.oso_cloud.ApiException;
import com.osohq.oso_cloud.Fact;
import com.osohq.oso_cloud.OsoClientOptions;
import com.osohq.oso_cloud.OsoTimeoutException;
import com.osohq.oso_cloud.PolicyMetadata;
import com.osohq.oso_cloud.Value;
import com.osohq.oso_cloud.internal.ActionsQuery;
import com.osohq.oso_cloud.internal.ActionsResult;
import com.osohq.oso_cloud.internal.ApiError;
import com.osohq.oso_cloud.internal.AuthorizeQuery;
import com.osohq.oso_cloud.internal.AuthorizeResult;
import com.osohq.oso_cloud.internal.ExpectResponse;
import com.osohq.oso_cloud.internal.ExpectedResult;
import com.osohq.oso_cloud.internal.FactChangeset;
import com.osohq.oso_cloud.internal.GetMetadataResponse;
import com.osohq.oso_cloud.internal.GetPolicyResult;
import com.osohq.oso_cloud.internal.HttpRequestWithPath;
import com.osohq.oso_cloud.internal.ListQuery;
import com.osohq.oso_cloud.internal.ListResult;
import com.osohq.oso_cloud.internal.LocalActionsQuery;
import com.osohq.oso_cloud.internal.LocalAuthQuery;
import com.osohq.oso_cloud.internal.LocalListQuery;
import com.osohq.oso_cloud.internal.LocalQuery;
import com.osohq.oso_cloud.internal.LocalQueryResult;
import com.osohq.oso_cloud.internal.OsoExceptionalRetryHandler;
import com.osohq.oso_cloud.internal.OsoServiceUnavailableRetryStrategy;
import com.osohq.oso_cloud.internal.ParityHandleImpl;
import com.osohq.oso_cloud.internal.Policy;
import com.osohq.oso_cloud.internal.Query;
import com.osohq.oso_cloud.internal.QueryResponse;
import com.osohq.oso_cloud.internal.VersionUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class Api {
    private URI uri;
    private URI fallbackUri;
    private HttpClient client;
    private Gson gson;
    private Header lastOffset;
    private String dataBindings;
    private String apiKey;
    private Integer defaultTimeoutMilliseconds;
    private RequestConfig readRequestConfig;
    private RequestConfig writeRequestConfig;

    static RequestConfig requestConfigWithTimeout(Integer timeoutMilliseconds) {
        return RequestConfig.custom().setCookieSpec("standard").setConnectTimeout(timeoutMilliseconds.intValue()).setConnectionRequestTimeout(timeoutMilliseconds.intValue()).setSocketTimeout(timeoutMilliseconds.intValue()).build();
    }

    public Api(String apiKey, URI uri, OsoClientOptions options) {
        if (apiKey == null) {
            throw new IllegalArgumentException("API key cannot be null.");
        }
        this.uri = uri == null ? URI.create("https://api.osohq.com") : uri;
        this.fallbackUri = options.getFallbackUri();
        this.apiKey = apiKey;
        this.defaultTimeoutMilliseconds = Optional.ofNullable(options.getDefaultTimeoutMilliseconds()).orElse(-1);
        if (options.getReadTimeoutMilliseconds() != null) {
            this.readRequestConfig = Api.requestConfigWithTimeout(options.getReadTimeoutMilliseconds());
        }
        if (options.getWriteTimeoutMilliseconds() != null) {
            this.writeRequestConfig = Api.requestConfigWithTimeout(options.getWriteTimeoutMilliseconds());
        }
        this.client = this.buildClient(apiKey, 20);
        this.gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        if (options.getDataBindingsPath() != null) {
            try {
                this.dataBindings = Files.readString(options.getDataBindingsPath());
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
    }

    @Deprecated
    public Api(String apiKey, URI uri, URI fallbackUri, Path dataBindingsPath) {
        this(apiKey, uri, new OsoClientOptions.Builder().withDataBindingsPath(dataBindingsPath).withFallbackUri(fallbackUri).build());
    }

    public void setMaxConnections(int maxConnections) {
        this.client = this.buildClient(this.apiKey, maxConnections);
    }

    private HttpClient buildClient(final String apiKey, int maxConnections) {
        String javaVersion = Runtime.version().toString();
        String clientVersion = VersionUtil.getVersion();
        final String clientId = UUID.randomUUID().toString();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(maxConnections);
        connectionManager.setDefaultMaxPerRoute(maxConnections);
        CloseableHttpClient client = HttpClientBuilder.create().setRetryHandler((HttpRequestRetryHandler)new OsoExceptionalRetryHandler()).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OsoServiceUnavailableRetryStrategy()).setConnectionManager((HttpClientConnectionManager)connectionManager).setUserAgent(String.format("Oso Cloud (java %s; rv: %s)", javaVersion, clientVersion)).addInterceptorFirst(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) {
                request.addHeader("Authorization", "Bearer " + apiKey);
                request.addHeader("X-OsoApiVersion", "0");
                request.addHeader("X-Request-ID", UUID.randomUUID().toString());
                request.addHeader("X-Oso-Instance-Id", clientId);
                request.addHeader("Accept", "application/json");
                if (Api.this.lastOffset != null) {
                    request.addHeader(Api.this.lastOffset);
                }
            }
        }).addInterceptorFirst(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) {
                Header offsetHeader = response.getFirstHeader("OsoOffset");
                if (offsetHeader != null) {
                    Api.this.lastOffset = offsetHeader;
                }
            }
        }).setDefaultRequestConfig(Api.requestConfigWithTimeout(this.defaultTimeoutMilliseconds)).build();
        return client;
    }

    private URI uriWithEndpoint(URI base, String path) {
        URI uri;
        try {
            ArrayList<String> pathSegments = new ArrayList<String>();
            pathSegments.addAll(Arrays.asList(base.getPath().split("/")));
            pathSegments.addAll(Arrays.asList("api", path));
            uri = new URIBuilder(base).setPathSegments(pathSegments).build();
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
        return uri;
    }

    private HttpRequestWithPath httpRequestWithPath(HttpRequestBase request, String path, boolean isFallbackEligible) {
        HttpRequestWithPath req = new HttpRequestWithPath(request, path, isFallbackEligible);
        req.request.setConfig(isFallbackEligible ? this.readRequestConfig : this.writeRequestConfig);
        return req;
    }

    private HttpRequestWithPath getRequest(String path, List<NameValuePair> params) {
        URI uri;
        try {
            uri = new URIBuilder(this.uriWithEndpoint(this.uri, path)).setParameters(params).build();
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
        HttpGet request = new HttpGet(uri);
        return this.httpRequestWithPath((HttpRequestBase)request, path, true);
    }

    private HttpRequestWithPath getRequest(String path) {
        return this.getRequest(path, new ArrayList<NameValuePair>());
    }

    private HttpRequestWithPath postRequest(String path, Object body, boolean isFallbackEligible) {
        int maxSizeInBytes;
        URI uri = this.uriWithEndpoint(this.uri, path);
        HttpPost request = new HttpPost(uri);
        String jsonBody = this.gson.toJson(body);
        int bodySizeInBytes = jsonBody.getBytes(StandardCharsets.UTF_8).length;
        if (bodySizeInBytes > (maxSizeInBytes = 0xA00000)) {
            throw new IllegalArgumentException("Request body exceeds the maximum allowed size of 10MB.");
        }
        request.setEntity((HttpEntity)new StringEntity(jsonBody, ContentType.APPLICATION_JSON));
        return this.httpRequestWithPath((HttpRequestBase)request, path, isFallbackEligible);
    }

    private boolean isFallbackEligibleStatus(HttpResponse response) {
        return response.getStatusLine().getStatusCode() == 400 || response.getStatusLine().getStatusCode() >= 500;
    }

    private void fallbackifyRequest(HttpRequestWithPath request) {
        try {
            request.request.setURI(new URIBuilder(this.uriWithEndpoint(this.fallbackUri, request.path)).setCustomQuery(request.request.getURI().getQuery()).build());
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }

    private <T> T execute(HttpRequestWithPath request, Class<T> type, ParityHandleImpl parityHandle, RequestHolder requestHolder) throws IOException, ApiException {
        HttpResponse response;
        block10: {
            if (requestHolder != null) {
                requestHolder.setCurrentRequest((HttpUriRequest)request.request);
            }
            try {
                try {
                    response = this.client.execute((HttpUriRequest)request.request);
                    if (this.fallbackUri != null && request.isFallbackEligible && this.isFallbackEligibleStatus(response)) {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                        this.fallbackifyRequest(request);
                        response = this.client.execute((HttpUriRequest)request.request);
                    }
                }
                catch (IOException e) {
                    if (this.fallbackUri != null && request.isFallbackEligible) {
                        this.fallbackifyRequest(request);
                        response = this.client.execute((HttpUriRequest)request.request);
                        break block10;
                    }
                    throw e;
                }
            }
            catch (SocketTimeoutException | ConnectTimeoutException e) {
                throw new OsoTimeoutException(e);
            }
        }
        if (parityHandle != null) {
            parityHandle.set(response.getFirstHeader("X-Request-ID").getValue(), this, requestHolder);
        }
        if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
            InputStreamReader reader = new InputStreamReader(response.getEntity().getContent());
            ApiError error = (ApiError)this.gson.fromJson((Reader)reader, ApiError.class);
            ((Reader)reader).close();
            String requestId = response.getFirstHeader("X-Request-ID").getValue();
            throw new ApiException(error.message, requestId);
        }
        if (type == null) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            return null;
        }
        InputStreamReader reader = new InputStreamReader(response.getEntity().getContent());
        Object result = this.gson.fromJson((Reader)reader, type);
        ((Reader)reader).close();
        return (T)result;
    }

    private <T> T execute(HttpRequestWithPath request, Class<T> type, RequestHolder requestHolder) throws IOException, ApiException {
        return this.execute(request, type, null, requestHolder);
    }

    public String getPolicy(RequestHolder requestHolder) throws IOException, ApiException {
        HttpRequestWithPath request = this.getRequest("policy");
        return this.execute((HttpRequestWithPath)request, GetPolicyResult.class, (RequestHolder)requestHolder).policy.src;
    }

    public void postPolicy(String policy, RequestHolder requestHolder) throws IOException, ApiException {
        Policy policyPayload = new Policy(null, policy);
        HttpRequestWithPath request = this.postRequest("policy", policyPayload, false);
        this.execute(request, null, requestHolder);
    }

    public Fact[] getFacts(RequestHolder requestHolder, String predicate, Value ... args) throws IOException, ApiException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (predicate != null) {
            params.add((NameValuePair)new BasicNameValuePair("predicate", predicate));
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (args[i].type != null) {
                params.add((NameValuePair)new BasicNameValuePair(String.format("args.%d.type", i), args[i].type));
            }
            if (args[i].id == null) continue;
            params.add((NameValuePair)new BasicNameValuePair(String.format("args.%d.id", i), args[i].id));
        }
        HttpRequestWithPath request = this.getRequest("facts", params);
        return this.execute(request, Fact[].class, requestHolder);
    }

    public boolean postAuthorize(Value actor, String action, Value resource, List<Fact> contextFacts, ParityHandleImpl parityHandle, RequestHolder requestHolder) throws IOException, ApiException {
        AuthorizeQuery query = new AuthorizeQuery(actor.type, actor.id, action, resource.type, resource.id, contextFacts.toArray(new Fact[0]));
        HttpRequestWithPath request = this.postRequest("authorize", query, true);
        return this.execute((HttpRequestWithPath)request, AuthorizeResult.class, (ParityHandleImpl)parityHandle, (RequestHolder)requestHolder).allowed;
    }

    public String[] postList(Value actor, String action, String resourceType, List<Fact> contextFacts, RequestHolder requestHolder) throws IOException, ApiException {
        ListQuery query = new ListQuery(actor.type, actor.id, action, resourceType, contextFacts.toArray(new Fact[0]));
        HttpRequestWithPath request = this.postRequest("list", query, true);
        return this.execute((HttpRequestWithPath)request, ListResult.class, (RequestHolder)requestHolder).results;
    }

    public String[] postActions(Value actor, Value resource, List<Fact> contextFacts, RequestHolder requestHolder) throws IOException, ApiException {
        ActionsQuery query = new ActionsQuery(actor.type, actor.id, resource.type, resource.id, contextFacts.toArray(new Fact[0]));
        HttpRequestWithPath request = this.postRequest("actions", query, true);
        return this.execute((HttpRequestWithPath)request, ActionsResult.class, (RequestHolder)requestHolder).results;
    }

    public PolicyMetadata getPolicyMetadata(RequestHolder requestHolder) throws IOException, ApiException {
        HttpRequestWithPath request = this.getRequest("policy_metadata");
        GetMetadataResponse response = this.execute(request, GetMetadataResponse.class, requestHolder);
        return response != null ? response.metadata : null;
    }

    public String postAuthorizeQuery(Value actor, String action, Value resource, List<Fact> contextFacts, ParityHandleImpl parityHandle, RequestHolder requestHolder) throws IOException, ApiException {
        AuthorizeQuery authQuery = new AuthorizeQuery(actor.type, actor.id, action, resource.type, resource.id, contextFacts.toArray(new Fact[0]));
        LocalAuthQuery data = new LocalAuthQuery(authQuery, this.dataBindings);
        HttpRequestWithPath request = this.postRequest("authorize_query", data, true);
        LocalQueryResult result = this.execute(request, LocalQueryResult.class, parityHandle, requestHolder);
        return result != null && result.sql != null ? result.sql.replace(":", "\\:") : null;
    }

    public String postListQuery(Value actor, String action, String resourceType, String column, List<Fact> contextFacts, RequestHolder requestHolder) throws IOException, ApiException {
        ListQuery listQuery = new ListQuery(actor.type, actor.id, action, resourceType, contextFacts.toArray(new Fact[0]));
        LocalListQuery data = new LocalListQuery(listQuery, column, this.dataBindings);
        HttpRequestWithPath request = this.postRequest("list_query", data, true);
        LocalQueryResult result = this.execute(request, LocalQueryResult.class, requestHolder);
        return result != null && result.sql != null ? result.sql.replace(":", "\\:") : null;
    }

    public String postActionsQuery(Value actor, Value resource, List<Fact> contextFacts, RequestHolder requestHolder) throws IOException, ApiException {
        ActionsQuery actionsQuery = new ActionsQuery(actor.type, actor.id, resource.type, resource.id, contextFacts.toArray(new Fact[0]));
        LocalActionsQuery data = new LocalActionsQuery(actionsQuery, this.dataBindings);
        HttpRequestWithPath request = this.postRequest("actions_query", data, true);
        LocalQueryResult result = this.execute(request, LocalQueryResult.class, requestHolder);
        return result != null && result.sql != null ? result.sql.replace(":", "\\:") : null;
    }

    public QueryResponse postQuery(Query query, RequestHolder requestHolder) throws IOException, ApiException {
        HttpRequestWithPath request = this.postRequest("evaluate_query", query, true);
        return this.execute(request, QueryResponse.class, requestHolder);
    }

    public LocalQueryResult postQueryLocal(LocalQuery queryRequest, RequestHolder requestHolder) throws IOException, ApiException {
        if (this.dataBindings == null) {
            throw new IllegalStateException("Data bindings file missing or empty. See https://www.osohq.com/docs/app-integration/client-apis/java#local-check-api for more details");
        }
        queryRequest.dataBindings = this.dataBindings;
        HttpRequestWithPath request = this.postRequest("evaluate_query_local", queryRequest, true);
        return this.execute(request, LocalQueryResult.class, requestHolder);
    }

    private void postBatchInternal(List<FactChangeset> changes, RequestHolder requestHolder) throws IOException, ApiException {
        HttpRequestWithPath request = this.postRequest("batch", changes, false);
        this.execute(request, null, requestHolder);
    }

    public void insertFact(Fact fact, RequestHolder requestHolder) throws IOException, ApiException {
        ArrayList<FactChangeset> changes = new ArrayList<FactChangeset>();
        ArrayList<Fact> inserts = new ArrayList<Fact>();
        inserts.add(fact);
        changes.add(FactChangeset.inserts(inserts));
        this.postBatchInternal(changes, requestHolder);
    }

    public void deleteFact(Fact fact, RequestHolder requestHolder) throws IOException, ApiException {
        ArrayList<FactChangeset> changes = new ArrayList<FactChangeset>();
        ArrayList<Fact> deletes = new ArrayList<Fact>();
        deletes.add(fact);
        changes.add(FactChangeset.deletes(deletes));
        this.postBatchInternal(changes, requestHolder);
    }

    public void batch(Consumer<com.osohq.oso_cloud.BatchTransaction> fn, RequestHolder requestHolder) throws IOException, ApiException {
        BatchTransaction txn = new BatchTransaction();
        fn.accept(txn);
        if (!txn.getChanges().isEmpty()) {
            this.postBatchInternal(txn.getChanges(), requestHolder);
        }
    }

    public ExpectResponse postExpectedResult(ExpectedResult expectedResult, RequestHolder requestHolder) throws IOException, ApiException {
        HttpRequestWithPath request = this.postRequest("expect", expectedResult, false);
        return this.execute(request, ExpectResponse.class, requestHolder);
    }

    public <T> CompletableFuture<T> asynchronously(Executor executor, Synchronous<T> block) {
        final AtomicReference<Object> requestRef = new AtomicReference<Object>(null);
        CompletableFuture future = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                HttpUriRequest request = (HttpUriRequest)requestRef.get();
                if (request != null && !request.isAborted()) {
                    request.abort();
                }
                return super.cancel(mayInterruptIfRunning);
            }
        };
        executor.execute(() -> {
            try {
                future.complete(block.runWithRequestHolder(requestRef::set));
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    @FunctionalInterface
    public static interface RequestHolder {
        public void setCurrentRequest(HttpUriRequest var1);
    }

    @FunctionalInterface
    public static interface Synchronous<T> {
        public T runWithRequestHolder(RequestHolder var1) throws IOException, ApiException;
    }

    public static class BatchTransaction
    implements com.osohq.oso_cloud.BatchTransaction {
        private final List<FactChangeset> changes = new ArrayList<FactChangeset>();

        BatchTransaction() {
        }

        @Override
        public void insert(Fact fact) {
            FactChangeset last;
            FactChangeset factChangeset = last = this.changes.isEmpty() ? null : this.changes.get(this.changes.size() - 1);
            if (last == null || last.inserts == null || last.deletes != null) {
                ArrayList<Fact> inserts = new ArrayList<Fact>();
                inserts.add(fact);
                this.changes.add(FactChangeset.inserts(inserts));
            } else {
                last.inserts.add(fact);
            }
        }

        @Override
        public void delete(Fact fact) {
            FactChangeset last;
            FactChangeset factChangeset = last = this.changes.isEmpty() ? null : this.changes.get(this.changes.size() - 1);
            if (last == null || last.deletes == null || last.inserts != null) {
                ArrayList<Fact> deletes = new ArrayList<Fact>();
                deletes.add(fact);
                this.changes.add(FactChangeset.deletes(deletes));
            } else {
                last.deletes.add(fact);
            }
        }

        List<FactChangeset> getChanges() {
            return this.changes;
        }
    }
}

