/*
 * Decompiled with CFR 0.152.
 */
package com.osohq.oso_cloud.internal;

import com.osohq.oso_cloud.Fact;
import com.osohq.oso_cloud.internal.Api;
import com.osohq.oso_cloud.internal.QueryBuilderImpl;
import com.osohq.oso_cloud.internal.QueryComposerImpl;
import com.osohq.oso_cloud.internal.QueryRunner;
import com.osohq.oso_cloud.querybuilder.AsyncQueryBuilder;
import com.osohq.oso_cloud.querybuilder.QueryArg;
import com.osohq.oso_cloud.querybuilder.TypedVar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class AsyncQueryBuilderImpl
implements AsyncQueryBuilder {
    private final Executor executor;
    private final Api api;
    private final QueryComposerImpl composer;
    private final QueryRunner runner;

    AsyncQueryBuilderImpl(Executor executor, Api api, QueryComposerImpl composer, QueryRunner runner) {
        this.executor = executor;
        this.api = api;
        this.composer = composer;
        this.runner = runner;
    }

    public static AsyncQueryBuilderImpl init(Executor executor, Api api, String predicate, QueryArg ... args) {
        QueryComposerImpl actualBuilder = new QueryComposerImpl(predicate, args);
        QueryRunner runner = new QueryRunner(api);
        return new AsyncQueryBuilderImpl(executor, api, actualBuilder, runner);
    }

    @Override
    public <T> CompletableFuture<T> evaluate(QueryBuilderImpl.EvaluateArg<T> arg) {
        return this.api.asynchronously(this.executor, requestHolder -> this.runner.evaluate(this.composer.asQuery(), arg, requestHolder));
    }

    @Override
    public CompletableFuture<String> evaluateLocalSelect(Map<String, TypedVar> columnNamesToQueryVars) {
        return this.api.asynchronously(this.executor, requestHolder -> this.runner.evaluateLocalSelect(this.composer.asQuery(), columnNamesToQueryVars, requestHolder));
    }

    @Override
    public CompletableFuture<String> evaluateLocalSelect() {
        return this.api.asynchronously(this.executor, requestHolder -> this.runner.evaluateLocalSelect(this.composer.asQuery(), requestHolder));
    }

    @Override
    public CompletableFuture<String> evaluateLocalFilter(String columnName, TypedVar queryVar) {
        return this.api.asynchronously(this.executor, requestHolder -> this.runner.evaluateLocalFilter(this.composer.asQuery(), columnName, queryVar, requestHolder));
    }

    @Override
    public AsyncQueryBuilder and(String predicate, QueryArg ... args) {
        return new AsyncQueryBuilderImpl(this.executor, this.api, this.composer.and(predicate, args), this.runner);
    }

    @Override
    public AsyncQueryBuilder in(TypedVar variable, List<String> values) {
        return new AsyncQueryBuilderImpl(this.executor, this.api, (QueryComposerImpl)this.composer.in(variable, (List)values), this.runner);
    }

    @Override
    public AsyncQueryBuilder withContextFacts(List<Fact> facts) {
        return new AsyncQueryBuilderImpl(this.executor, this.api, (QueryComposerImpl)this.composer.withContextFacts((List)facts), this.runner);
    }
}

