/*
 * Decompiled with CFR 0.152.
 */
package com.osohq.oso_cloud.internal;

import com.osohq.oso_cloud.internal.JitteredBackoff;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.protocol.HttpContext;

public class OsoExceptionalRetryHandler
implements HttpRequestRetryHandler {
    final int MAX_TRIES = 3;

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        if (executionCount <= 3 && (exception instanceof ConnectTimeoutException || exception instanceof SocketTimeoutException)) {
            long retryIntervalMs = JitteredBackoff.jitteredBackoffMs(executionCount);
            try {
                Thread.sleep(retryIntervalMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            return true;
        }
        return false;
    }
}

