/*
 * Decompiled with CFR 0.152.
 */
package com.osohq.oso_cloud.internal;

import com.osohq.oso_cloud.internal.JitteredBackoff;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;

public class OsoServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    final ThreadLocal<Integer> currentExecutionCount = ThreadLocal.withInitial(() -> 1);
    final int MAX_TRIES = 3;

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        this.currentExecutionCount.set(executionCount);
        if (executionCount > 3) {
            return false;
        }
        int statusCode = response.getStatusLine().getStatusCode();
        return statusCode == 429 || 500 <= statusCode && statusCode <= 599;
    }

    public long getRetryInterval() {
        return JitteredBackoff.jitteredBackoffMs(this.currentExecutionCount.get());
    }
}

