/*
 * Decompiled with CFR 0.152.
 */
package com.osohq.oso_cloud.internal;

import com.osohq.oso_cloud.ApiException;
import com.osohq.oso_cloud.Fact;
import com.osohq.oso_cloud.internal.Api;
import com.osohq.oso_cloud.internal.QueryComposerImpl;
import com.osohq.oso_cloud.internal.QueryRunner;
import com.osohq.oso_cloud.querybuilder.QueryArg;
import com.osohq.oso_cloud.querybuilder.QueryBuilder;
import com.osohq.oso_cloud.querybuilder.TypedVar;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class QueryBuilderImpl
implements QueryBuilder {
    private final QueryComposerImpl composer;
    private final QueryRunner runner;

    private QueryBuilderImpl(QueryComposerImpl composer, QueryRunner runner) {
        this.composer = composer;
        this.runner = runner;
    }

    public static QueryBuilderImpl init(Api api, String predicate, QueryArg ... args) {
        QueryComposerImpl actualBuilder = new QueryComposerImpl(predicate, args);
        QueryRunner runner = new QueryRunner(api);
        return new QueryBuilderImpl(actualBuilder, runner);
    }

    @Override
    public QueryBuilderImpl and(String predicate, QueryArg ... args) {
        return new QueryBuilderImpl(this.composer.and(predicate, args), this.runner);
    }

    @Override
    public QueryBuilderImpl in(TypedVar variable, List<String> values) {
        return new QueryBuilderImpl((QueryComposerImpl)this.composer.in(variable, (List)values), this.runner);
    }

    @Override
    public QueryBuilderImpl withContextFacts(List<Fact> facts) {
        return new QueryBuilderImpl((QueryComposerImpl)this.composer.withContextFacts((List)facts), this.runner);
    }

    @Override
    public <T> T evaluate(EvaluateArg<T> arg) throws IOException, ApiException {
        return this.runner.evaluate(this.composer.asQuery(), arg, null);
    }

    @Override
    public String evaluateLocalSelect(Map<String, TypedVar> columnNamesToQueryVars) throws IOException, ApiException {
        return this.runner.evaluateLocalSelect(this.composer.asQuery(), columnNamesToQueryVars, null);
    }

    @Override
    public String evaluateLocalSelect() throws IOException, ApiException {
        return this.runner.evaluateLocalSelect(this.composer.asQuery(), null);
    }

    @Override
    public String evaluateLocalFilter(String columnName, TypedVar queryVar) throws IOException, ApiException {
        return this.runner.evaluateLocalFilter(this.composer.asQuery(), columnName, queryVar, null);
    }

    public static class MapArg<SubT>
    extends EvaluateArg<Map<String, SubT>> {
        private final TypedVar keyVariable;
        private final EvaluateArg<SubT> valueArg;

        public MapArg(TypedVar keyVariable, EvaluateArg<SubT> valueArg) {
            this.keyVariable = Objects.requireNonNull(keyVariable, "keyVariable cannot be null");
            this.valueArg = Objects.requireNonNull(valueArg, "valueArg cannot be null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapArg mapArg = (MapArg)o;
            return this.keyVariable.equals(mapArg.keyVariable) && this.valueArg.equals(mapArg.valueArg);
        }

        public int hashCode() {
            return Objects.hash(this.keyVariable, this.valueArg);
        }

        public String toString() {
            return "MapArg{keyVariable=" + String.valueOf(this.keyVariable) + ", valueArg=" + String.valueOf(this.valueArg) + "}";
        }

        @Override
        Map<String, SubT> evaluateResults(List<Map<String, String>> results) {
            if (results.isEmpty()) {
                return Collections.emptyMap();
            }
            boolean keyVarUsed = results.stream().anyMatch(map -> map.containsKey(this.keyVariable.getId()));
            if (!keyVarUsed) {
                throw new IllegalArgumentException("Map key variable " + String.valueOf(this.keyVariable) + " was not used in the query and cannot be evaluated.");
            }
            Map<String, List<Map>> groupedResults = results.stream().collect(Collectors.groupingBy(row -> QueryRunner.handleWildcard((String)row.get(this.keyVariable.getId()))));
            HashMap<String, SubT> structuredResult = new HashMap<String, SubT>();
            for (Map.Entry<String, List<Map>> groupEntry : groupedResults.entrySet()) {
                String key = groupEntry.getKey();
                List<Map<String, String>> groupedRows = groupEntry.getValue();
                SubT subResult = this.valueArg.evaluateResults(groupedRows);
                structuredResult.put(key, subResult);
            }
            return structuredResult;
        }
    }

    public static class TypedVarArg
    extends EvaluateArg<List<String>> {
        private final TypedVar variable;

        public TypedVarArg(TypedVar variable) {
            this.variable = Objects.requireNonNull(variable, "variable cannot be null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedVarArg that = (TypedVarArg)o;
            return this.variable.equals(that.variable);
        }

        public int hashCode() {
            return Objects.hash(this.variable);
        }

        public String toString() {
            return "TypedVarArg{variable=" + String.valueOf(this.variable) + "}";
        }

        @Override
        List<String> evaluateResults(List<Map<String, String>> results) {
            if (results.isEmpty()) {
                return Collections.emptyList();
            }
            boolean varUsed = results.stream().anyMatch(map -> map.containsKey(this.variable.getId()));
            if (!varUsed) {
                throw new IllegalArgumentException("Variable " + String.valueOf(this.variable) + " was not used in the query and cannot be evaluated.");
            }
            return results.stream().map(row -> (String)row.get(this.variable.getId())).map(QueryRunner::handleWildcard).distinct().collect(Collectors.toList());
        }
    }

    public static class ExistsArg
    extends EvaluateArg<Boolean> {
        private static final ExistsArg INSTANCE = new ExistsArg();

        private ExistsArg() {
        }

        public static ExistsArg getInstance() {
            return INSTANCE;
        }

        public String toString() {
            return "ExistsArg";
        }

        @Override
        Boolean evaluateResults(List<Map<String, String>> results) {
            return !results.isEmpty();
        }
    }

    public static abstract class EvaluateArg<T> {
        abstract T evaluateResults(List<Map<String, String>> var1);
    }
}

