/*
 * Decompiled with CFR 0.152.
 */
package com.osohq.oso_cloud.internal;

import com.osohq.oso_cloud.Fact;
import com.osohq.oso_cloud.Value;
import com.osohq.oso_cloud.internal.Query;
import com.osohq.oso_cloud.internal.QueryCall;
import com.osohq.oso_cloud.internal.QueryConstraint;
import com.osohq.oso_cloud.querybuilder.QueryArg;
import com.osohq.oso_cloud.querybuilder.QueryComposer;
import com.osohq.oso_cloud.querybuilder.TypedVar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class QueryComposerImpl
implements QueryComposer<QueryComposerImpl> {
    private final QueryCall predicate;
    private final List<QueryCall> calls;
    private final Map<String, QueryConstraint> constraints;
    private final List<Fact> contextFacts;

    QueryComposerImpl(QueryCall predicate, List<QueryCall> calls, Map<String, QueryConstraint> constraints, List<Fact> contextFacts) {
        this.predicate = predicate;
        this.calls = calls;
        this.constraints = constraints;
        this.contextFacts = contextFacts;
    }

    QueryComposerImpl(String predicate, QueryArg ... args) {
        this.calls = new ArrayList<QueryCall>();
        this.constraints = new HashMap<String, QueryConstraint>();
        this.contextFacts = new ArrayList<Fact>();
        List<String> queryArgs = Arrays.stream(args).map(this::pushArg).collect(Collectors.toList());
        this.predicate = new QueryCall(predicate, queryArgs);
    }

    @Override
    public QueryComposerImpl and(String predicate, QueryArg ... args) {
        QueryComposerImpl clone = this.cloneBuilder();
        List<String> queryArgs = Arrays.stream(args).map(clone::pushArg).collect(Collectors.toList());
        clone.calls.add(new QueryCall(predicate, queryArgs));
        return clone;
    }

    @Override
    public QueryComposerImpl in(TypedVar variable, List<String> values) {
        QueryComposerImpl clone = this.cloneBuilder();
        String name = variable.getId();
        QueryConstraint constraint = clone.constraints.get(name);
        if (constraint == null) {
            throw new IllegalArgumentException("Can only constrain variables that are used in the query");
        }
        if (constraint.getIds() != null) {
            throw new IllegalArgumentException("Can only set values on each variable once");
        }
        constraint.setIds(values);
        return clone;
    }

    @Override
    public QueryComposerImpl withContextFacts(List<Fact> facts) {
        QueryComposerImpl clone = this.cloneBuilder();
        clone.contextFacts.addAll(facts);
        return clone;
    }

    private String pushArg(QueryArg arg) {
        if (arg instanceof TypedVar) {
            TypedVar var = (TypedVar)arg;
            String argId = var.getId();
            if (!this.constraints.containsKey(argId)) {
                this.constraints.put(argId, new QueryConstraint(var.getType()));
            }
            return argId;
        }
        if (arg instanceof Value) {
            Value value = (Value)arg;
            TypedVar newVar = new TypedVar(value.type);
            String newId = newVar.getId();
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(value.id);
            this.constraints.put(newId, new QueryConstraint(value.type, ids));
            return newId;
        }
        throw new IllegalArgumentException("Unsupported argument type: " + arg.getClass().getName());
    }

    private QueryComposerImpl cloneBuilder() {
        QueryCall predicateClone = this.predicate.clone();
        List<QueryCall> callsClone = this.calls.stream().map(QueryCall::clone).collect(Collectors.toList());
        Map<String, QueryConstraint> constraintsClone = this.constraints.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((QueryConstraint)entry.getValue()).clone()));
        ArrayList<Fact> contextFactsClone = new ArrayList<Fact>(this.contextFacts);
        return new QueryComposerImpl(predicateClone, callsClone, constraintsClone, contextFactsClone);
    }

    Query asQuery() {
        Query query = new Query();
        query.predicate = new ArrayList<Object>();
        query.predicate.add(this.predicate.getPredicate());
        query.predicate.add(this.predicate.getArgs());
        query.calls = new ArrayList<List<Object>>();
        for (QueryCall call : this.calls) {
            ArrayList<Object> callList = new ArrayList<Object>();
            callList.add(call.getPredicate());
            callList.add(call.getArgs());
            query.calls.add(callList);
        }
        query.constraints = this.constraints.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((QueryConstraint)entry.getValue()).clone()));
        query.context_facts = new ArrayList<Fact>(this.contextFacts);
        return query;
    }
}

