/*
 * Decompiled with CFR 0.152.
 */
package com.osohq.oso_cloud.internal;

import com.osohq.oso_cloud.ApiException;
import com.osohq.oso_cloud.internal.Api;
import com.osohq.oso_cloud.internal.LocalQuery;
import com.osohq.oso_cloud.internal.LocalQueryResult;
import com.osohq.oso_cloud.internal.Query;
import com.osohq.oso_cloud.internal.QueryBuilderImpl;
import com.osohq.oso_cloud.internal.QueryResponse;
import com.osohq.oso_cloud.querybuilder.TypedVar;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

class QueryRunner {
    private final Api api;

    QueryRunner(Api api) {
        this.api = api;
    }

    <T> T evaluate(Query query, QueryBuilderImpl.EvaluateArg<T> arg, Api.RequestHolder requestHolder) throws IOException, ApiException {
        Objects.requireNonNull(arg, "Evaluation argument cannot be null");
        QueryResponse response = this.api.postQuery(query, requestHolder);
        return arg.evaluateResults(response.results);
    }

    String evaluateLocalSelect(Query query, Map<String, TypedVar> columnNamesToQueryVars, Api.RequestHolder requestHolder) throws IOException, ApiException {
        Objects.requireNonNull(columnNamesToQueryVars, "columnNamesToQueryVars cannot be null");
        HashMap<String, String> queryVarsToColumnNames = new HashMap<String, String>();
        HashSet<String> seenVarIds = new HashSet<String>();
        for (Map.Entry<String, TypedVar> entry : columnNamesToQueryVars.entrySet()) {
            String columnName = entry.getKey();
            TypedVar queryVar = entry.getValue();
            String varId = queryVar.getId();
            if (!seenVarIds.add(varId)) {
                throw new IllegalArgumentException("Found a duplicated " + queryVar.getType() + " variable - you may not select a query variable more than once.");
            }
            queryVarsToColumnNames.put(varId, columnName);
        }
        LocalQuery.SelectModeParams modeParams = new LocalQuery.SelectModeParams(queryVarsToColumnNames);
        LocalQuery request = new LocalQuery(query, modeParams);
        LocalQueryResult response = this.api.postQueryLocal(request, requestHolder);
        return response.sql;
    }

    String evaluateLocalSelect(Query query, Api.RequestHolder requestHolder) throws IOException, ApiException {
        LocalQuery.SelectModeParams modeParams = new LocalQuery.SelectModeParams(Collections.emptyMap());
        LocalQuery request = new LocalQuery(query, modeParams);
        LocalQueryResult response = this.api.postQueryLocal(request, requestHolder);
        return response.sql;
    }

    String evaluateLocalFilter(Query query, String columnName, TypedVar queryVar, Api.RequestHolder requestHolder) throws IOException, ApiException {
        Objects.requireNonNull(columnName, "columnName cannot be null");
        Objects.requireNonNull(queryVar, "queryVar cannot be null");
        LocalQuery.FilterModeParams modeParams = new LocalQuery.FilterModeParams(queryVar.getId(), columnName);
        LocalQuery request = new LocalQuery(query, modeParams);
        LocalQueryResult response = this.api.postQueryLocal(request, requestHolder);
        return response.sql;
    }

    static String handleWildcard(String value) {
        if (value == null) {
            return "*";
        }
        return value;
    }
}

