/*
 * Decompiled with CFR 0.152.
 */
package com.outbrain.ci.friendly.flatten.maven.plugin;

import com.outbrain.ci.friendly.flatten.maven.plugin.AbstractCiFriendlyMojo;
import com.outbrain.ci.friendly.flatten.maven.plugin.visitor.PomVisitorImpl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="flatten", requiresProject=true, requiresDirectInvocation=false, executionStrategy="once-per-session", requiresDependencyCollection=ResolutionScope.RUNTIME, threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class FlattenMojo
extends AbstractCiFriendlyMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="sha1")
    private String sha1;
    @Parameter(property="changelist")
    private String changeList;
    @Parameter(property="autoRewriteCiFriendlyPoms", defaultValue="true")
    private boolean autoRewriteCiFriendlyPoms;
    private final PomVisitorImpl pomVisitor = new PomVisitorImpl();

    public void execute() throws MojoExecutionException {
        String revision;
        String modifiedPom;
        String originalPom = this.readPom();
        if (originalPom.equals(modifiedPom = this.pomVisitor.visit(originalPom, revision = this.getRevision(), this.sha1, this.changeList))) {
            this.getLog().info((CharSequence)"Pom does not have any CI friendly properties");
        } else {
            File ciFriendlyPomFile = this.isUpdateNeeded(modifiedPom) ? this.writePom(modifiedPom) : this.getCiFriendlyPomFile();
            this.project.setPomFile(ciFriendlyPomFile);
            this.project.setOriginalModel(this.getModel(ciFriendlyPomFile));
        }
    }

    private boolean isUpdateNeeded(String content) throws MojoExecutionException {
        String contentOfFlattenedPomFileBeforeUpdate;
        if (this.autoRewriteCiFriendlyPoms) {
            return true;
        }
        File flattenedPomFile = this.getCiFriendlyPomFile();
        if (flattenedPomFile.exists() && (contentOfFlattenedPomFileBeforeUpdate = this.readFile(flattenedPomFile)).equals(content)) {
            this.getLog().info((CharSequence)("Skipping writing CI friendly properties for project " + this.project.getId() + " as it is already up to date"));
            return false;
        }
        return true;
    }

    private Model getModel(File file) throws MojoExecutionException {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try {
            return reader.read(Files.newInputStream(file.toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading raw model.", e);
        }
    }

    private File writePom(String content) throws MojoExecutionException {
        boolean success;
        this.getLog().info((CharSequence)("Replacing CI friendly properties for project " + this.project.getId() + "..."));
        File flattenedPomFile = this.getCiFriendlyPomFile();
        File parentFile = flattenedPomFile.getParentFile();
        if (!parentFile.exists() && !(success = parentFile.mkdirs())) {
            throw new MojoExecutionException("Failed to create directory " + flattenedPomFile.getParent());
        }
        try (FileWriter writer = new FileWriter(flattenedPomFile);){
            writer.write(content);
            this.getLog().info((CharSequence)("Successfully wrote to " + flattenedPomFile));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("An error occurred while writing " + flattenedPomFile), (Throwable)e);
            String message = e.getMessage();
            throw new MojoExecutionException(message);
        }
        return flattenedPomFile;
    }

    private String readPom() throws MojoExecutionException {
        File originalPomFile = this.project.getFile();
        return this.readFile(originalPomFile);
    }

    private String readFile(File file) throws MojoExecutionException {
        try {
            return FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("An error occurred while reading " + file), (Throwable)e);
            String message = e.getMessage();
            throw new MojoExecutionException(message);
        }
    }

    private String getRevision() {
        if (this.project.getProperties().containsKey("internal.revision")) {
            return this.project.getProperties().getProperty("internal.revision");
        }
        Properties systemProperties = this.session.getSystemProperties();
        if (systemProperties.containsKey("revision")) {
            return systemProperties.getProperty("revision");
        }
        if (this.project.getProperties().containsKey("revision")) {
            return this.project.getProperties().getProperty("revision");
        }
        return this.project.getVersion();
    }
}

