/*
 * Decompiled with CFR 0.152.
 */
package com.outbrain.ci.friendly.flatten.maven.plugin;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="scmTag", aggregator=true, requiresProject=true, requiresDirectInvocation=true, executionStrategy="once-per-session", threadSafe=true)
public class TagMojo
extends AbstractScmMojo {
    @Parameter(property="tag", defaultValue="${project.artifactId}-${project.version}")
    private String tag;
    @Parameter(property="revision")
    private String revision;
    @Parameter(property="message")
    private String message;
    @Parameter(property="remoteTagging", defaultValue="true")
    private boolean remoteTagging;
    @Parameter(property="pinExternals", defaultValue="false")
    private boolean pinExternals;
    @Parameter(property="sign", defaultValue="false")
    private boolean sign;

    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            String finalTag = this.tag;
            if (StringUtils.isEmpty((String)this.tag)) {
                throw new NullPointerException("You need to define a tag parameter in scm or pass it as arg");
            }
            ScmRepository repository = this.getScmRepository();
            ScmProvider provider = this.getScmManager().getProviderByRepository(repository);
            finalTag = provider.sanitizeTagName(finalTag);
            this.getLog().info((CharSequence)("Final Tag Name: '" + finalTag + "'"));
            ScmTagParameters scmTagParameters = new ScmTagParameters(this.message);
            scmTagParameters.setRemoteTagging(this.remoteTagging);
            scmTagParameters.setPinExternals(this.pinExternals);
            scmTagParameters.setSign(this.sign);
            TagScmResult result = provider.tag(repository, this.getFileSet(), finalTag, scmTagParameters);
            this.checkResult((ScmResult)result);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot run tag command : ", (Exception)e);
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run tag command : ", (Exception)((Object)e));
        }
    }
}

