/*
 * Decompiled with CFR 0.152.
 */
package com.outbrain.ci.friendly.flatten.maven.plugin;

import com.outbrain.ci.friendly.flatten.maven.plugin.SemanticVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;

public class VersionUtil {
    public static String getVersion(String prefixedVersion, String prefixRegex) throws MojoExecutionException {
        String regex = prefixRegex + "(.+)";
        Matcher matcher = Pattern.compile(regex).matcher(prefixedVersion);
        if (!matcher.find()) {
            throw new MojoExecutionException("Cannot extract version from " + prefixedVersion + " with prefix regex " + prefixRegex);
        }
        return matcher.group(1);
    }

    public static String incrementRevision(String revision, SemanticVersion semanticVersion) {
        String[] splitRevision = revision.split("\\.");
        int index = splitRevision.length > semanticVersion.index ? semanticVersion.index : splitRevision.length - 1;
        int incremented = Integer.parseInt(splitRevision[index]) + 1;
        boolean resetNextParts = false;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < splitRevision.length; ++i) {
            String number;
            if (index == i) {
                number = Integer.toString(incremented);
                resetNextParts = true;
            } else {
                number = resetNextParts ? "0" : splitRevision[i];
            }
            builder.append(number).append(i == splitRevision.length - 1 ? "" : ".");
        }
        return builder.toString();
    }
}

