package com.outr.mailgun

import java.util.UUID

import com.roundeights.scalon.nObject

import scala.concurrent.Future

/** @see MailSender */
object MailSender {
  /** The result of a piece of sent mail */
  case class Response(id: String, message: String) {

    /** Builds a response from a JSON object */
    def this(obj: nObject) = this(obj.str("id"), obj.str("message"))
  }

  /** A dummy mail sender */
  class Dummy extends MailSender {
    override def send(email: Email): Future[MailSender.Response] = {
      println(email)
      Future.successful(Response(UUID.randomUUID.toString, "Dummy Send"))
    }

    override def toString = "DummyMailSender"

    override def close() = {}
  }

  /** An error encountered while executing a request */
  class Error(message: String) extends Exception(message)
}

/** An interface for sending emails */
trait MailSender {
  /** Sends the given email and returns a response */
  def send(email: Email): Future[MailSender.Response]

  /** Sends the given email and returns a response */
  def send(
            to: String, from: String, subject: String, body: String
          ): Future[MailSender.Response] = send(new Email(to, from, subject, body))

  /** Sends the given email and returns a response */
  def send(
            to: Email.Addr, from: Email.Addr, subject: String, body: Email.Body
          ): Future[MailSender.Response] = send(Email(to, from, subject, body))

  /** Shutsdown the underlying client */
  def close(): Unit
}