package com.outr.mailgun

import scala.concurrent.{ExecutionContext, Future}

/** A mail sender for Mailgun */
class Mailgun(server: String, apiKey: String, msTimeout: Int = 3000, maxConnections: Int = 3)
             (implicit val ctx: ExecutionContext) extends MailSender {
  /** The mailgun API url */
  private val url = "https://api.mailgun.net/v2/" + server + "/messages"
  //private val url = "http://requestb.in/"

  /** A list of headers to send along with each request */
  private val headers = {
    val value = "api:" + apiKey
    val encoded = new sun.misc.BASE64Encoder().encode(value.getBytes)
    Map("Authorization" -> ("Basic " + encoded))
  }

  /** The sends and parses requests */
  private val client = new Requestor(msTimeout, maxConnections)

  override def send(email: Email): Future[MailSender.Response] = {
    try {
      client.request(url, headers, email.toMap)
        .map(new MailSender.Response(_))
    }
    catch {
      case e: Throwable => Future.failed(e)
    }
  }

  override def toString = "MailgunSender(%s)".format(server)

  override def close() = client.close()
}