package perfolation

import NumberFormatUtil._

trait CrossDate {
  def milliseconds: Long
  def hour24: Int
  def minuteOfHour: Int
  def secondOfMinute: Int
  def milliOfSecond: Int
  def isAM: Boolean
  def timeZoneOffsetMillis: Int
  def timeZoneOffsetHH: String = int(math.abs(timeZoneOffsetMillis / (1000 * 60 * 60)), 2)
  def timeZoneOffsetMM: String = int(math.abs(timeZoneOffsetMillis / (1000 * 60) % 60), 2)
  def timeZone: String

  def year: Int
  def month: Int
  def dayOfWeek: Int
  def dayOfMonth: Int
  def dayOfYear: Int

  def hour12: Int = hour24 match {
    case i if i > 11 => i - 11
    case i => i
  }
  def isPM: Boolean = !isAM
  def secondsOfEpoch: Long = milliseconds / 1000L

  // Time short-hand
  def H: String = int(hour24, 2)
  def I: String = int(hour12, 2)
  def k: String = hour24.toString
  def l: String = hour12.toString
  def M: String = int(minuteOfHour, 2)
  def S: String = int(secondOfMinute, 2)
  def L: String = int(milliOfSecond, 3)
  def p: String = if (isAM) "am" else "pm"
  def P: String = if (isAM) "AM" else "PM"
  def z: String = {
    val sign = if (timeZoneOffsetMillis >= 0) "+" else "-"
    p"$sign$timeZoneOffsetHH$timeZoneOffsetMM"
  }
  def Z: String = timeZone
  def s: String = secondsOfEpoch.toString
  def Q: String = milliseconds.toString

  // Date short-hand
  def B: String = CrossDate.Month.Long(month)
  def b: String = CrossDate.Month.Short(month)
  def h: String = CrossDate.Month.Short(month)
  def A: String = CrossDate.Week.Long(dayOfWeek)
  def a: String = CrossDate.Week.Short(dayOfWeek)
  def C: String = (year / 100).toString
  def Y: String = year.toString
  def y: String = (year % 100).toString
  def j: String = (dayOfYear + 1).toString
  def m: String = int(month + 1, 2)
  def d: String = int(dayOfMonth, 2)
  def e: String = dayOfMonth.toString
  def R: String = p"$H:$M"
  def T: String = p"$H:$M:$S"
  def r: String = p"$I:$M:$S:$p"
  def D: String = p"$m/$d/$y"
  def F: String = p"$Y-$m-$d"
  def c: String = p"$a $b $d $T $z $Y"
}

object CrossDate {
  private val cache = new ThreadLocal[CrossDate]

  def apply(l: Long): CrossDate = Option(cache.get()) match {
    case Some(d) if d.milliseconds == l => d
    case _ => {
      val d = Platform.createDate(l)
      cache.set(d)
      d
    }
  }

  object Week {
    val Long: Vector[String] = Vector(
      "Sunday",
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday"
    )
    val Short: Vector[String] = Vector(
      "Sun",
      "Mon",
      "Tues",
      "Wed",
      "Thurs",
      "Fri",
      "Sat"
    )
  }
  object Month {
    val Long: Vector[String] = Vector(
      "January",
      "February",
      "March",
      "April",
      "May",
      "June",
      "July",
      "August",
      "September",
      "October",
      "November",
      "December"
    )
    val Short: Vector[String] = Vector(
      "Jan",
      "Feb",
      "Mar",
      "Apr",
      "May",
      "Jun",
      "Jul",
      "Aug",
      "Sep",
      "Oct",
      "Nov",
      "Dec"
    )
  }
}