/*
 * Decompiled with CFR 0.152.
 */
package scribe.writer.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import scala.Function0;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scribe.writer.file.LogFile$;
import scribe.writer.file.LogFileMode;
import scribe.writer.file.LogFileWriter;

@ScalaSignature(bytes="\u0006\u0001\u0005Mw!B\u0001\u0003\u0011\u0003I\u0011a\u0002'pO\u001aKG.\u001a\u0006\u0003\u0007\u0011\tAAZ5mK*\u0011QAB\u0001\u0007oJLG/\u001a:\u000b\u0003\u001d\taa]2sS\n,7\u0001\u0001\t\u0003\u0015-i\u0011A\u0001\u0004\u0006\u0019\tA\t!\u0004\u0002\b\u0019><g)\u001b7f'\tYa\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006+-!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%A\u0001\u0002G\u0006A\u0002\u0013\u0005!!G\u0001\u0004[\u0006\u0004X#\u0001\u000e\u0011\tm\u0001#%L\u0007\u00029)\u0011QDH\u0001\nS6lW\u000f^1cY\u0016T!a\b\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\"9\t\u0019Q*\u00199\u0011\u0005\rRcB\u0001\u0013)!\t)\u0003#D\u0001'\u0015\t9\u0003\"\u0001\u0004=e>|GOP\u0005\u0003SA\ta\u0001\u0015:fI\u00164\u0017BA\u0016-\u0005\u0019\u0019FO]5oO*\u0011\u0011\u0006\u0005\t\u0003\u001592A\u0001\u0004\u0002\u0001_M\u0011aF\u0004\u0005\tc9\u0012)\u0019!C\u0001e\u0005\u00191.Z=\u0016\u0003\tB\u0001\u0002\u000e\u0018\u0003\u0002\u0003\u0006IAI\u0001\u0005W\u0016L\b\u0005\u0003\u00057]\t\u0015\r\u0011\"\u00018\u0003\u0011\u0001\u0018\r\u001e5\u0016\u0003a\u0002\"!O \u000e\u0003iR!aA\u001e\u000b\u0005qj\u0014a\u00018j_*\ta(\u0001\u0003kCZ\f\u0017B\u0001!;\u0005\u0011\u0001\u0016\r\u001e5\t\u0011\ts#\u0011!Q\u0001\na\nQ\u0001]1uQ\u0002B\u0001\u0002\u0012\u0018\u0003\u0006\u0004%\t!R\u0001\u0007CB\u0004XM\u001c3\u0016\u0003\u0019\u0003\"aD$\n\u0005!\u0003\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0015:\u0012\t\u0011)A\u0005\r\u00069\u0011\r\u001d9f]\u0012\u0004\u0003\u0002\u0003'/\u0005\u000b\u0007I\u0011A#\u0002\u0013\u0005,Ho\u001c$mkND\u0007\u0002\u0003(/\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\u0015\u0005,Ho\u001c$mkND\u0007\u0005\u0003\u0005Q]\t\u0015\r\u0011\"\u0001R\u0003\u001d\u0019\u0007.\u0019:tKR,\u0012A\u0015\t\u0003'Vk\u0011\u0001\u0016\u0006\u0003!nJ!A\u0016+\u0003\u000f\rC\u0017M]:fi\"A\u0001L\fB\u0001B\u0003%!+\u0001\u0005dQ\u0006\u00148/\u001a;!\u0011!QfF!b\u0001\n\u0003Y\u0016\u0001B7pI\u0016,\u0012\u0001\u0018\t\u0003\u0015uK!A\u0018\u0002\u0003\u00171{wMR5mK6{G-\u001a\u0005\tA:\u0012\t\u0011)A\u00059\u0006)Qn\u001c3fA!)QC\fC\u0001ER9Qf\u00193fM\u001eD\u0007\"B\u0019b\u0001\u0004\u0011\u0003\"\u0002\u001cb\u0001\u0004A\u0004\"\u0002#b\u0001\u00041\u0005\"\u0002'b\u0001\u00041\u0005\"\u0002)b\u0001\u0004\u0011\u0006\"\u0002.b\u0001\u0004a\u0006\u0002\u00036/\u0011\u000b\u0007I\u0011B6\u0002\u0017ML'0Z\"pk:$XM]\u000b\u0002YB\u0011Q\u000e^\u0007\u0002]*\u0011q\u000e]\u0001\u0007CR|W.[2\u000b\u0005E\u0014\u0018AC2p]\u000e,(O]3oi*\u00111/P\u0001\u0005kRLG.\u0003\u0002v]\nQ\u0011\t^8nS\u000eduN\\4\t\u0011\u0015q\u0003R1A\u0005\n],\u0012\u0001\u001f\t\u0003\u0015eL!A\u001f\u0002\u0003\u001b1{wMR5mK^\u0013\u0018\u000e^3s\u0011\u0015ah\u0006\"\u0001~\u0003\u0011\u0019\u0018N_3\u0016\u0003y\u0004\"aD@\n\u0007\u0005\u0005\u0001C\u0001\u0003M_:<\u0007bBA\u0003]\u0011\u0015\u0011qA\u0001\u0006oJLG/\u001a\u000b\u0005\u0003\u0013\ty\u0001E\u0002\u0010\u0003\u0017I1!!\u0004\u0011\u0005\u0011)f.\u001b;\t\u000f\u0005E\u00111\u0001a\u0001E\u00051q.\u001e;qkRDq!!\u0006/\t\u0003\t9\"\u0001\u0004sK:\fW.\u001a\u000b\u0004[\u0005e\u0001bBA\u000e\u0003'\u0001\rAI\u0001\tM&dWMT1nK\"9\u0011Q\u0003\u0018\u0005\u0002\u0005}AcA\u0017\u0002\"!9\u00111EA\u000f\u0001\u0004A\u0014a\u00028foB\u000bG\u000f\u001b\u0005\b\u0003OqCQAA\u0015\u0003\u00119'0\u001b9\u0015\r\u0005%\u00111FA\u0018\u0011%\ti#!\n\u0011\u0002\u0003\u0007!%A\u0006eKN$\u0018N\\1uS>t\u0007\"CA\u0019\u0003K\u0001\n\u00111\u0001G\u00039!W\r\\3uK>\u0013\u0018nZ5oC2Dq!!\u000e/\t\u0013\t9$\u0001\u0004tiJ,\u0017-\u001c\u000b\t\u0003\u0013\tI$!\u0013\u0002R!A\u00111HA\u001a\u0001\u0004\ti$A\u0003j]B,H\u000f\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019%P\u0001\u0003S>LA!a\u0012\u0002B\tY\u0011J\u001c9viN#(/Z1n\u0011!\t\t\"a\rA\u0002\u0005-\u0003\u0003BA \u0003\u001bJA!a\u0014\u0002B\taq*\u001e;qkR\u001cFO]3b[\"A\u00111KA\u001a\u0001\u0004\t)&\u0001\u0004ck\u001a4WM\u001d\t\u0006\u001f\u0005]\u00131L\u0005\u0004\u00033\u0002\"!B!se\u0006L\bcA\b\u0002^%\u0019\u0011q\f\t\u0003\t\tKH/\u001a\u0015\u0005\u0003g\t\u0019\u0007\u0005\u0003\u0002f\u0005-TBAA4\u0015\r\tI\u0007E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA7\u0003O\u0012q\u0001^1jYJ,7\rC\u0004\u0002r9\"\t!a\u001d\u0002\u000b\u0019dWo\u001d5\u0015\u0005\u0005%\u0001bBA<]\u0011\u0005\u00111O\u0001\bI&\u001c\bo\\:f\u0011\u001d\tYH\fC\u0001\u0003{\na\u0001Z3mKR,G#\u0001$\t\u0013\u0005\u0005e&%A\u0005\u0006\u0005\r\u0015AD4{SB$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000bS3AIADW\t\tI\t\u0005\u0003\u0002\f\u0006EUBAAG\u0015\u0011\ty)a\u001a\u0002\u0013Ut7\r[3dW\u0016$\u0017\u0002BAJ\u0003\u001b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t9JLI\u0001\n\u000b\tI*\u0001\bhu&\u0004H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m%f\u0001$\u0002\b\"Q\u0011qT\u0006A\u0002\u0013\u0005!!!)\u0002\u000f5\f\u0007o\u0018\u0013fcR!\u0011\u0011BAR\u0011%\t)+!(\u0002\u0002\u0003\u0007!$A\u0002yIEBq!!+\fA\u0003&!$\u0001\u0003nCB\u0004\u0003bBAW\u0017\u0011\u0005\u0011qV\u0001\u0006CB\u0004H.\u001f\u000b\f[\u0005E\u00161WA[\u0003o\u000bI\f\u0003\u00047\u0003W\u0003\r\u0001\u000f\u0005\t\t\u0006-\u0006\u0013!a\u0001\r\"AA*a+\u0011\u0002\u0003\u0007a\t\u0003\u0005Q\u0003W\u0003\n\u00111\u0001S\u0011!Q\u00161\u0016I\u0001\u0002\u0004a\u0006\"CA_\u0017E\u0005I\u0011AAM\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0004\"CAa\u0017E\u0005I\u0011AAM\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0004\"CAc\u0017E\u0005I\u0011AAd\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"TCAAeU\r\u0011\u0016q\u0011\u0005\n\u0003\u001b\\\u0011\u0013!C\u0001\u0003\u001f\fq\"\u00199qYf$C-\u001a4bk2$H%N\u000b\u0003\u0003#T3\u0001XAD\u0001")
public class LogFile {
    private AtomicLong sizeCounter;
    private LogFileWriter writer;
    private final String key;
    private final Path path;
    private final boolean append;
    private final boolean autoFlush;
    private final Charset charset;
    private final LogFileMode mode;
    private volatile byte bitmap$0;

    public static LogFileMode apply$default$5() {
        return LogFile$.MODULE$.apply$default$5();
    }

    public static Charset apply$default$4() {
        return LogFile$.MODULE$.apply$default$4();
    }

    public static boolean apply$default$3() {
        return LogFile$.MODULE$.apply$default$3();
    }

    public static boolean apply$default$2() {
        return LogFile$.MODULE$.apply$default$2();
    }

    public static LogFile apply(Path path, boolean bl, boolean bl2, Charset charset, LogFileMode logFileMode) {
        return LogFile$.MODULE$.apply(path, bl, bl2, charset, logFileMode);
    }

    public String key() {
        return this.key;
    }

    public Path path() {
        return this.path;
    }

    public boolean append() {
        return this.append;
    }

    public boolean autoFlush() {
        return this.autoFlush;
    }

    public Charset charset() {
        return this.charset;
    }

    public LogFileMode mode() {
        return this.mode;
    }

    private AtomicLong sizeCounter$lzycompute() {
        LogFile logFile = this;
        synchronized (logFile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sizeCounter = new AtomicLong(0L);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sizeCounter;
    }

    private AtomicLong sizeCounter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sizeCounter$lzycompute() : this.sizeCounter;
    }

    private LogFileWriter writer$lzycompute() {
        LogFile logFile = this;
        synchronized (logFile) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Files.createDirectories(this.path().getParent(), new FileAttribute[0]);
                this.writer = this.mode().createWriter(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.writer;
    }

    private LogFileWriter writer() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.writer$lzycompute() : this.writer;
    }

    public long size() {
        return this.sizeCounter().get();
    }

    public final void write(String output) {
        this.writer().write(output);
        if (this.autoFlush()) {
            this.writer().flush();
        }
        this.sizeCounter().addAndGet(output.length());
    }

    public LogFile rename(String fileName) {
        return this.rename(this.path().getParent().resolve(fileName));
    }

    public LogFile rename(Path newPath) {
        Object object;
        if (Files.exists(newPath, new LinkOption[0])) {
            Files.delete(newPath);
        }
        if (Files.exists(this.path(), new LinkOption[0])) {
            this.dispose();
            object = Files.move(this.path(), newPath, new CopyOption[0]);
        } else {
            object = BoxedUnit.UNIT;
        }
        return LogFile$.MODULE$.apply(newPath, this.append(), this.autoFlush(), this.charset(), this.mode());
    }

    public final void gzip(String destination, boolean deleteOriginal) {
        this.flush();
        this.dispose();
        byte[] buffer = new byte[1024];
        File file = this.path().toAbsolutePath().toFile();
        File outputFile = new File(file.getParentFile(), destination);
        GZIPInputStream input = new GZIPInputStream(new FileInputStream(file));
        GZIPOutputStream output = new GZIPOutputStream(new FileOutputStream(outputFile));
        try {
            this.stream(input, output, buffer);
            output.flush();
        }
        finally {
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> input.close());
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> output.close());
        }
    }

    public final String gzip$default$1() {
        return new StringBuilder(3).append(((Object)this.path().getFileName()).toString()).append(".gz").toString();
    }

    public final boolean gzip$default$2() {
        return true;
    }

    private void stream(InputStream input, OutputStream output, byte[] buffer) {
        int len;
        while ((len = input.read(buffer)) > 0) {
            output.write(buffer, 0, len);
        }
    }

    public void flush() {
        this.writer().flush();
    }

    public void dispose() {
        LogFile$ logFile$ = LogFile$.MODULE$;
        synchronized (logFile$) {
            LogFile$.MODULE$.map_$eq((Map<String, LogFile>)((Map)LogFile$.MODULE$.map().$minus((Object)this.key())));
        }
        try {
            this.writer().dispose();
        }
        catch (Throwable throwable) {}
    }

    public boolean delete() {
        this.dispose();
        return Files.deleteIfExists(this.path());
    }

    public LogFile(String key, Path path, boolean append, boolean autoFlush, Charset charset, LogFileMode mode) {
        this.key = key;
        this.path = path;
        this.append = append;
        this.autoFlush = autoFlush;
        this.charset = charset;
        this.mode = mode;
    }
}

