/*
 * Decompiled with CFR 0.152.
 */
package scribe;

import java.io.PrintStream;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scribe.Level;
import scribe.Level$;
import scribe.Logger;
import scribe.LoggerId;
import scribe.LoggerId$;
import scribe.MinimumLevel;
import scribe.format.Formatter;
import scribe.handler.LogHandler;
import scribe.modify.LogModifier;
import scribe.writer.Writer;

public final class Logger$
implements scala.Serializable {
    public static Logger$ MODULE$;
    private final PrintStream scribe$Logger$$systemOut;
    private final PrintStream scribe$Logger$$systemErr;
    private final long RootId;
    private Map<LoggerId, Logger> id2Logger;
    private Map<String, LoggerId> name2Id;

    static {
        new Logger$();
    }

    public Option<LoggerId> $lessinit$greater$default$1() {
        return new Some((Object)new LoggerId(this.RootId()));
    }

    public List<LogModifier> $lessinit$greater$default$2() {
        return Nil$.MODULE$;
    }

    public List<LogHandler> $lessinit$greater$default$3() {
        return Nil$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public long $lessinit$greater$default$5() {
        return LoggerId$.MODULE$.apply();
    }

    public PrintStream scribe$Logger$$systemOut() {
        return this.scribe$Logger$$systemOut;
    }

    public PrintStream scribe$Logger$$systemErr() {
        return this.scribe$Logger$$systemErr;
    }

    public long RootId() {
        return this.RootId;
    }

    private Map<LoggerId, Logger> id2Logger() {
        return this.id2Logger;
    }

    private void id2Logger_$eq(Map<LoggerId, Logger> x$1) {
        this.id2Logger = x$1;
    }

    private Map<String, LoggerId> name2Id() {
        return this.name2Id;
    }

    private void name2Id_$eq(Map<String, LoggerId> x$1) {
        this.name2Id = x$1;
    }

    public Logger empty() {
        return new Logger(this.apply$default$1(), this.apply$default$2(), this.apply$default$3(), this.apply$default$4(), this.apply$default$5());
    }

    public Logger root() {
        return this.apply(this.RootId());
    }

    public Map<String, Logger> loggersByName() {
        return (Map)this.name2Id().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            long id = ((LoggerId)tuple2._2()).value();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), MODULE$.id2Logger().apply((Object)new LoggerId(id)));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public Logger apply(String name) {
        Logger logger;
        Option<Logger> option = this.get(name);
        if (option instanceof Some) {
            Logger logger2;
            Some some = (Some)option;
            logger = logger2 = (Logger)some.value();
        } else if (None$.MODULE$.equals(option)) {
            Logger logger3;
            Logger$ logger$ = this;
            synchronized (logger$) {
                long l;
                String n = this.fixName(name);
                int dotIndex = n.lastIndexOf(46);
                if (dotIndex > 0) {
                    String parentName = n.substring(0, dotIndex);
                    Logger parent = this.apply(parentName);
                    l = parent.id();
                } else {
                    l = this.RootId();
                }
                long parentId = l;
                Logger logger4 = new Logger((Option<LoggerId>)new Some((Object)new LoggerId(parentId)), this.apply$default$2(), this.apply$default$3(), this.apply$default$4(), this.apply$default$5());
                this.id2Logger_$eq((Map<LoggerId, Logger>)this.id2Logger().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new LoggerId(logger4.id())), (Object)logger4)));
                this.name2Id_$eq((Map<String, LoggerId>)this.name2Id().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n), (Object)new LoggerId(logger4.id()))));
                logger3 = logger4;
            }
            logger = logger3;
        } else {
            throw new MatchError(option);
        }
        return logger;
    }

    public Logger apply(long id) {
        Logger logger;
        Option<Logger> option = this.get(id);
        if (option instanceof Some) {
            Logger logger2;
            Some some = (Some)option;
            logger = logger2 = (Logger)some.value();
        } else if (None$.MODULE$.equals(option)) {
            Logger logger3;
            Logger$ logger$ = this;
            synchronized (logger$) {
                long x$1 = id;
                Option<LoggerId> x$2 = this.$lessinit$greater$default$1();
                List<LogModifier> x$3 = this.$lessinit$greater$default$2();
                List<LogHandler> x$4 = this.$lessinit$greater$default$3();
                Option<String> x$5 = this.$lessinit$greater$default$4();
                Logger logger4 = new Logger(x$2, x$3, x$4, x$5, x$1);
                this.id2Logger_$eq((Map<LoggerId, Logger>)this.id2Logger().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new LoggerId(logger4.id())), (Object)logger4)));
                logger3 = logger4;
            }
            logger = logger3;
        } else {
            throw new MatchError(option);
        }
        return logger;
    }

    public void minimumLevels(Seq<MinimumLevel> minimums) {
        minimums.foreach((Function1 & Serializable & scala.Serializable)m -> {
            Logger qual$1 = m.logger().withMinimumLevel(m.minimumLevel());
            Option<String> x$1 = qual$1.replace$default$1();
            return qual$1.replace(x$1);
        });
    }

    public <T> Logger apply(ClassTag<T> t) {
        return this.apply(t.runtimeClass().getName());
    }

    public Option<LoggerId> apply$default$1() {
        return new Some((Object)new LoggerId(this.RootId()));
    }

    public List<LogModifier> apply$default$2() {
        return Nil$.MODULE$;
    }

    public List<LogHandler> apply$default$3() {
        return Nil$.MODULE$;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public long apply$default$5() {
        return LoggerId$.MODULE$.apply();
    }

    public Option<Logger> get(String name) {
        Map<LoggerId, Logger> map = this.id2Logger();
        return this.name2Id().get((Object)this.fixName(name)).flatMap((Function1 & Serializable & scala.Serializable)key -> map.get((Object)new LoggerId(((LoggerId)key).value())));
    }

    public Option<Logger> get(long id) {
        return this.id2Logger().get((Object)new LoggerId(id));
    }

    public <T> Option<Logger> get(ClassTag<T> t) {
        return this.get(t.runtimeClass().getName());
    }

    public synchronized Logger replace(Logger logger) {
        this.id2Logger_$eq((Map<LoggerId, Logger>)this.id2Logger().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new LoggerId(logger.id())), (Object)logger)));
        return logger;
    }

    public synchronized Logger replaceByName(String name, Logger logger) {
        this.replace(logger);
        this.name2Id_$eq((Map<String, LoggerId>)this.name2Id().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fixName(name)), (Object)new LoggerId(logger.id()))));
        return logger;
    }

    public Set<String> namesFor(long loggerId) {
        return ((TraversableOnce)this.name2Id().collect((PartialFunction)new scala.Serializable(loggerId){
            public static final long serialVersionUID = 0L;
            private final long loggerId$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, LoggerId>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String name = (String)A1._1();
                    long id = ((LoggerId)A1._2()).value();
                    if (id == this.loggerId$1) {
                        object = name;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, LoggerId> x1) {
                long id;
                Tuple2<String, LoggerId> tuple2 = x1;
                boolean bl = tuple2 != null && (id = ((LoggerId)tuple2._2()).value()) == this.loggerId$1;
                return bl;
            }
            {
                this.loggerId$1 = loggerId$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private String fixName(String name) {
        return name.replaceAll("[$]", "");
    }

    public Logger apply(Option<LoggerId> parentId, List<LogModifier> modifiers, List<LogHandler> handlers, Option<String> overrideClassName, long id) {
        return new Logger(parentId, modifiers, handlers, overrideClassName, id);
    }

    public Option<Tuple5<Option<LoggerId>, List<LogModifier>, List<LogHandler>, Option<String>, LoggerId>> unapply(Logger x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5(x$0.parentId(), x$0.modifiers(), x$0.handlers(), x$0.overrideClassName(), (Object)new LoggerId(x$0.id())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Logger$() {
        MODULE$ = this;
        this.scribe$Logger$$systemOut = System.out;
        this.scribe$Logger$$systemErr = System.err;
        this.RootId = 0L;
        this.id2Logger = Predef$.MODULE$.Map().empty();
        this.name2Id = Predef$.MODULE$.Map().empty();
        Logger qual$1 = this.root().orphan();
        Some x$1 = new Some((Object)Level$.MODULE$.Info());
        Formatter x$2 = qual$1.withHandler$default$1();
        Writer x$3 = qual$1.withHandler$default$2();
        List<LogModifier> x$4 = qual$1.withHandler$default$4();
        qual$1.withHandler(x$2, x$3, (Option<Level>)x$1, x$4).replace((Option<String>)new Some((Object)"root"));
    }
}

