/*
 * Decompiled with CFR 0.152.
 */
package scribe;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import moduload.Moduload$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scribe.PlatformImplementation;
import scribe.output.format.OutputFormat;
import scribe.writer.SystemWriter$;
import scribe.writer.Writer;

public final class Platform$
implements PlatformImplementation {
    public static Platform$ MODULE$;
    private File cacheDirectory;
    private File scriptFile;
    private int maximumColumns;
    private int minimumColumns;
    private int minimumRows;
    private Option<Object> columnsOverride;
    private Option<Object> rowsOverride;
    private long lastChecked;
    private int cachedColumns;
    private int cachedRows;
    private long columnCheckFrequency;
    private int columnsAdjust;
    private boolean supportsANSI;
    private volatile byte bitmap$0;

    static {
        new Platform$();
    }

    @Override
    public Option<String> env(String key) {
        return PlatformImplementation.env$(this, key);
    }

    @Override
    public OutputFormat outputFormat() {
        return PlatformImplementation.outputFormat$(this);
    }

    @Override
    public int columnsAdjust() {
        return this.columnsAdjust;
    }

    @Override
    public void columnsAdjust_$eq(int x$1) {
        this.columnsAdjust = x$1;
    }

    private boolean supportsANSI$lzycompute() {
        Platform$ platform$ = this;
        synchronized (platform$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.supportsANSI = PlatformImplementation.supportsANSI$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.supportsANSI;
    }

    @Override
    public boolean supportsANSI() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.supportsANSI$lzycompute();
        }
        return this.supportsANSI;
    }

    public int maximumColumns() {
        return this.maximumColumns;
    }

    public void maximumColumns_$eq(int x$1) {
        this.maximumColumns = x$1;
    }

    public int minimumColumns() {
        return this.minimumColumns;
    }

    public void minimumColumns_$eq(int x$1) {
        this.minimumColumns = x$1;
    }

    public int minimumRows() {
        return this.minimumRows;
    }

    public void minimumRows_$eq(int x$1) {
        this.minimumRows = x$1;
    }

    public Option<Object> columnsOverride() {
        return this.columnsOverride;
    }

    public void columnsOverride_$eq(Option<Object> x$1) {
        this.columnsOverride = x$1;
    }

    public Option<Object> rowsOverride() {
        return this.rowsOverride;
    }

    public void rowsOverride_$eq(Option<Object> x$1) {
        this.rowsOverride = x$1;
    }

    private long lastChecked() {
        return this.lastChecked;
    }

    private void lastChecked_$eq(long x$1) {
        this.lastChecked = x$1;
    }

    private int cachedColumns() {
        return this.cachedColumns;
    }

    private void cachedColumns_$eq(int x$1) {
        this.cachedColumns = x$1;
    }

    private int cachedRows() {
        return this.cachedRows;
    }

    private void cachedRows_$eq(int x$1) {
        this.cachedRows = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private File cacheDirectory$lzycompute() {
        Platform$ platform$ = this;
        synchronized (platform$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                File f = new File(System.getProperty("user.home"), ".cache/scribe");
                f.mkdirs();
                this.cacheDirectory = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.cacheDirectory;
    }

    private File cacheDirectory() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.cacheDirectory$lzycompute();
        }
        return this.cacheDirectory;
    }

    public long columnCheckFrequency() {
        return this.columnCheckFrequency;
    }

    public void columnCheckFrequency_$eq(long x$1) {
        this.columnCheckFrequency = x$1;
    }

    @Override
    public boolean isJVM() {
        return true;
    }

    @Override
    public boolean isJS() {
        return false;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    public void init() {
        Moduload$.MODULE$.load();
    }

    @Override
    public Writer consoleWriter() {
        return SystemWriter$.MODULE$;
    }

    @Override
    public int columns() {
        return BoxesRunTime.unboxToInt((Object)this.columnsOverride().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            MODULE$.updateConsoleSize();
            if (MODULE$.cachedColumns() < MODULE$.minimumColumns()) {
                return MODULE$.maximumColumns();
            }
            return MODULE$.cachedColumns() + MODULE$.columnsAdjust();
        }));
    }

    @Override
    public int rows() {
        return BoxesRunTime.unboxToInt((Object)this.rowsOverride().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            MODULE$.updateConsoleSize();
            if (MODULE$.cachedRows() < MODULE$.minimumRows()) {
                return -1;
            }
            return MODULE$.cachedRows();
        }));
    }

    private void updateConsoleSize() {
        long now = System.currentTimeMillis();
        if (now - this.lastChecked() >= this.columnCheckFrequency()) {
            this.lastChecked_$eq(now);
            Tuple2<Object, Object> tuple2 = this.queryTput();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int c = tuple2._1$mcI$sp();
            int r = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(c, r);
            int c2 = sp2._1$mcI$sp();
            int r2 = sp2._2$mcI$sp();
            this.cachedColumns_$eq(c2);
            this.cachedRows_$eq(r2);
            return;
        }
    }

    public Tuple2<Object, Object> queryTput() {
        return (Tuple2)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Tuple2.mcII.sp sp2;
            ProcessBuilder pb = new ProcessBuilder("bash", "-c", "tput cols lines 2> /dev/tty");
            Process p = pb.start();
            try (BufferedReader i = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                int columns = new StringOps(Predef$.MODULE$.augmentString(i.readLine().trim())).toInt();
                int rows = new StringOps(Predef$.MODULE$.augmentString(i.readLine().trim())).toInt();
                sp2 = new Tuple2.mcII.sp(columns, rows);
            }
            return sp2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcII.sp(-1, -1));
    }

    private File scriptFile$lzycompute() {
        Platform$ platform$ = this;
        synchronized (platform$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.scriptFile = new File(this.cacheDirectory(), "cursor-position.sh");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.scriptFile;
    }

    private File scriptFile() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.scriptFile$lzycompute();
        }
        return this.scriptFile;
    }

    public Tuple2<Object, Object> cursor() {
        return (Tuple2)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Tuple2.mcII.sp sp2;
            Object object;
            if (!MODULE$.scriptFile().isFile()) {
                String script = new StringOps(Predef$.MODULE$.augmentString("exec < /dev/tty\n          |oldstty=$(stty -g)\n          |stty raw -echo min 0\n          |echo -en \"\\033[6n\" > /dev/tty\n          |IFS=';' read -r -d R -a pos\n          |stty $oldstty\n          |row=$((${pos[0]:2} - 1))\n          |col=$((${pos[1]} - 1))\n          |echo $row $col")).stripMargin();
                Files.write(MODULE$.scriptFile().toPath(), script.getBytes("UTF-8"), new OpenOption[0]);
                ProcessBuilder pb = new ProcessBuilder("bash", new StringBuilder(9).append("chmod +x ").append(MODULE$.scriptFile().getCanonicalPath()).toString());
                object = BoxesRunTime.boxToInteger((int)pb.start().waitFor());
            } else {
                object = BoxedUnit.UNIT;
            }
            ProcessBuilder pb = new ProcessBuilder("bash", MODULE$.scriptFile().getCanonicalPath());
            Process p = pb.start();
            try (BufferedReader i = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line = i.readLine();
                Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(line)).splitAt(line.indexOf(32));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String row = (String)tuple2._1();
                String col = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)row, (Object)col);
                String row2 = (String)tuple22._1();
                String col2 = (String)tuple22._2();
                sp2 = new Tuple2.mcII.sp(new StringOps(Predef$.MODULE$.augmentString(row2.trim())).toInt(), new StringOps(Predef$.MODULE$.augmentString(col2.trim())).toInt());
            }
            return sp2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcII.sp(-1, -1));
    }

    @Override
    public ExecutionContext executionContext() {
        return ExecutionContext$.MODULE$.global();
    }

    private Platform$() {
        MODULE$ = this;
        PlatformImplementation.$init$(this);
        this.maximumColumns = 5000;
        this.minimumColumns = 10;
        this.minimumRows = 5;
        this.columnsOverride = None$.MODULE$;
        this.rowsOverride = None$.MODULE$;
        this.lastChecked = 0L;
        this.cachedColumns = -1;
        this.cachedRows = -1;
        this.columnCheckFrequency = 5000L;
    }
}

