package scribe.message

import scribe.output.{LogOutput, TextOutput}
import scribe.throwable.TraceLoggableMessage
import scribe.Loggable

import scala.language.implicitConversions

trait LoggableMessage {
  def value: Any
  def logOutput: LogOutput
}

object LoggableMessage {
  implicit def logOutput2Message(lo: => LogOutput): LoggableMessage = apply[LogOutput](identity)(lo)
  implicit def string2Message(s: => String): LoggableMessage = apply[String](new TextOutput(_))(s)
  implicit def stringList2Messages(list: => List[String]): List[LoggableMessage] = list.map(f => string2Message(f))
  implicit def throwable2Message(throwable: => Throwable): LoggableMessage = TraceLoggableMessage(throwable)
  implicit def throwableList2Messages(list: List[Throwable]): List[LoggableMessage] =
    list.map(f => throwable2Message(f))

  def apply[V](toLogOutput: V => LogOutput)(value: => V): LoggableMessage =
    new LazyMessage[V](() => value)(new Loggable[V] {
      override def apply(value: V): LogOutput = toLogOutput(value)
    })
}